/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.AsciiInputStream;
import gnu.inet.ftp.ConnectionEvent;
import gnu.inet.ftp.Getter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.zip.InflaterInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveGetter
extends Getter {
    private static final Log log = LogFactory.getLog(ActiveGetter.class);
    private InetAddress address;
    private int port;
    private ServerSocket server = new ServerSocket(0);
    private int timeout = 30000;

    public ActiveGetter(OutputStream out) throws IOException {
        this.port = this.server.getLocalPort();
        this.address = this.server.getInetAddress();
        this.ostream = out;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public void setTimeout(int milliseconds) {
        this.timeout = milliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean signalClosure = false;
        Socket sock = null;
        InputStream istream = null;
        long amount = 0L;
        long buffer_size = 0L;
        byte[] buffer = new byte[1024];
        try {
            this.server.setSoTimeout(this.timeout);
            if (this.cancelled) {
                throw new InterruptedIOException("Transfer cancelled");
            }
            sock = this.server.accept();
            this.signalConnectionOpened(new ConnectionEvent(sock.getInetAddress(), sock.getPort()));
            signalClosure = true;
            this.signalTransferStarted();
            try {
                int len;
                switch (this.type) {
                    case 'A': {
                        istream = new AsciiInputStream(sock.getInputStream());
                        break;
                    }
                    default: {
                        istream = sock.getInputStream();
                    }
                }
                switch (this.mode) {
                    case 'Z': {
                        istream = new InflaterInputStream(istream);
                        break;
                    }
                }
                while (!this.cancelled && (len = istream.read(buffer)) > 0) {
                    this.ostream.write(buffer, 0, len);
                    amount += (long)len;
                    if ((buffer_size += (long)len) >= 1024L) {
                        buffer_size %= 1024L;
                        this.signalTransfered(amount);
                    }
                    ActiveGetter.yield();
                }
                this.ostream.flush();
            }
            catch (InterruptedIOException iioe) {
                if (!this.cancelled) {
                    log.error(iioe.getMessage(), iioe);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            finally {
                log.debug("Closing inputstream");
                if (istream != null) {
                    istream.close();
                }
                if (!sock.isClosed()) {
                    try {
                        log.debug("Setting socket to 0 lingering");
                        sock.setSoLinger(true, 0);
                        sock.close();
                    }
                    catch (SocketException iioe) {}
                }
                this.signalTransferCompleted();
            }
        }
        catch (InterruptedIOException eiioe) {
            this.signalConnectionFailed(eiioe);
            if (!this.cancelled) {
                log.error(eiioe.getMessage(), eiioe);
            }
        }
        catch (Exception ee) {
            this.signalConnectionFailed(ee);
            log.error(ee.getMessage(), ee);
        }
        finally {
            try {
                log.debug("Closing server socket");
                this.server.close();
            }
            catch (IOException eiioe) {}
        }
        if (signalClosure && sock != null) {
            this.signalConnectionClosed(new ConnectionEvent(sock.getInetAddress(), sock.getPort()));
        }
    }
}

