/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import yajhfc.DesktopManager;
import yajhfc.Utils;
import yajhfc.util.CancelAction;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.URIClickListener;

public class AboutDialog
extends JDialog
implements HyperlinkListener {
    private static final Logger log = Logger.getLogger(AboutDialog.class.getName());
    private static final String[] readmeFiles = new String[]{"README.txt", "doc/faq.html", "LICENSE", "COPYING"};
    private static final boolean[] addEnglishReadme = new boolean[]{true, true, false, false};
    private JPanel jContentPane;
    private Box boxButtons;
    private JButton buttonOK;
    private JTabbedPane tabMain;
    private JPanel aboutPane;

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
            try {
                URL uRL = hyperlinkEvent.getURL();
                String string = uRL.getProtocol();
                if (string.equals("file") || string.equals("jar")) {
                    jEditorPane.setPage(uRL);
                } else {
                    DesktopManager.getDefault().safeBrowse(uRL.toURI(), this);
                }
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error handling hyperlink:", exception);
            }
        }
    }

    private JScrollPane addScrollTxt(String string, boolean bl) {
        URL uRL = bl && !Utils.getLocale().equals(Locale.ENGLISH) ? Utils.getYajHFCLanguage().getLocalizedFile(string, false) : AboutDialog.class.getResource(string);
        if (uRL == null) {
            return null;
        }
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setFont(new Font("DialogInput", 0, 12));
        jEditorPane.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        jEditorPane.addHyperlinkListener(this);
        try {
            jEditorPane.putClientProperty("charset", "UTF-8");
            jEditorPane.setPage(uRL);
        }
        catch (IOException iOException) {
            jEditorPane.setText("Error loading text file " + string + ".");
        }
        JScrollPane jScrollPane = new JScrollPane(jEditorPane, 20, 30);
        return jScrollPane;
    }

    private JScrollPane addSysPropTxt() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        jTextArea.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        Properties properties = System.getProperties();
        Object[] objectArray = new String[properties.size()];
        Enumeration<?> enumeration = properties.propertyNames();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n++] = (String)enumeration.nextElement();
        }
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            jTextArea.append((String)objectArray[n] + "=" + properties.getProperty((String)objectArray[n]) + "\n");
        }
        jTextArea.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        return jScrollPane;
    }

    private JPanel getAboutPane() {
        if (this.aboutPane == null) {
            double d = 15.0;
            double[][] dArrayArray = new double[][]{{d, -2.0, d, -1.0, d}, {d, -2.0, d, -2.0, d, -2.0, -2.0, d, 0.25, 0.3, d}};
            this.aboutPane = new JPanel(new TableLayout(dArrayArray));
            JLabel jLabel = new JLabel(new ImageIcon(AboutDialog.class.getResource("logo-large.png")));
            JLabel jLabel2 = new JLabel("<html>Yet Another Java HylaFAX Client (YajHFC)</html>");
            jLabel2.setFont(new Font("Serif", 1, 18));
            JLabel jLabel3 = new JLabel(MessageFormat.format(Utils._("Version {0}"), "0.6.1 (srfax v4)"));
            jLabel3.setFont(new Font("Dialog", 2, 11));
            Box box = new Box(3);
            box.add(jLabel2);
            box.add(Box.createVerticalStrut(4));
            box.add(jLabel3);
            JLabel jLabel4 = new JLabel("Copyright \u00a9 2005-2016 by Jonas Wolz");
            JLabel jLabel5 = new JLabel("<html>" + Utils._("YajHFC is a client for the HylaFAX fax server.") + "</html>");
            JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0), false);
            jPanel.add(new JLabel(Utils._("Homepage") + ": "));
            JLabel jLabel6 = new JLabel("<html><a href=\"http://www.yajhfc.de\">http://www.yajhfc.de/</a></html>");
            jLabel6.addMouseListener(new URIClickListener("http://www.yajhfc.de/"));
            jLabel6.setCursor(Cursor.getPredefinedCursor(12));
            jPanel.add(jLabel6);
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0), false);
            jPanel2.add(new JLabel(Utils._("Author") + ": " + "Jonas Wolz"));
            JLabel jLabel7 = new JLabel("<html>&lt;<a href=\"mailto:info@yajhfc.de\">info@yajhfc.de</a>&gt;</html>");
            jLabel7.addMouseListener(new URIClickListener("mailto:info@yajhfc.de"));
            jLabel7.setCursor(Cursor.getPredefinedCursor(12));
            jPanel2.add(jLabel7);
            JLabel jLabel8 = null;
            String string = Utils._("$TRANSLATOR$");
            if (!string.equals("$TRANSLATOR$")) {
                jLabel8 = new JLabel(MessageFormat.format(Utils._("$LANGUAGE$ translation by {0}"), string));
            }
            this.aboutPane.add((Component)jLabel, "1, 1");
            this.aboutPane.add((Component)box, "3, 1, F, C");
            this.aboutPane.add((Component)jLabel5, "1, 3, 3, 3, F, C");
            this.aboutPane.add((Component)jPanel, "1, 5, 3, 5, F, C");
            this.aboutPane.add((Component)jPanel2, "1, 6, 3, 6, F, C");
            if (jLabel8 != null) {
                this.aboutPane.add((Component)jLabel8, "1, 8, 3, 8, F, C");
            }
            this.aboutPane.add((Component)jLabel4, "1, 9, 3, 9, F, C");
        }
        return this.aboutPane;
    }

    private Box getBoxButtons() {
        if (this.boxButtons == null) {
            this.boxButtons = new Box(2);
            CancelAction cancelAction = new CancelAction(this, Utils._("OK"));
            this.buttonOK = cancelAction.createCancelButton();
            this.boxButtons.add(Box.createHorizontalGlue());
            this.boxButtons.add(this.buttonOK);
            this.boxButtons.add(Box.createHorizontalGlue());
        }
        return this.boxButtons;
    }

    private JTabbedPane getTabMain() {
        if (this.tabMain == null) {
            this.tabMain = new JTabbedPane(3);
        }
        return this.tabMain;
    }

    private JPanel getjContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel(new BorderLayout());
            this.jContentPane.add((Component)this.getBoxButtons(), "South");
            this.jContentPane.add((Component)this.getTabMain(), "Center");
        }
        return this.jContentPane;
    }

    private void initialize() {
        this.setModal(true);
        this.setSize(640, 380);
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getjContentPane());
        this.getRootPane().setDefaultButton(this.buttonOK);
    }

    public void setMode(Mode mode) {
        this.getTabMain().removeAll();
        switch (mode) {
            case ABOUT: {
                this.tabMain.addTab(Utils._("About"), this.getAboutPane());
                this.tabMain.addTab(Utils._("License"), this.addScrollTxt("/COPYING", false));
                this.tabMain.addTab(Utils._("System properties"), this.addSysPropTxt());
                this.setTitle(MessageFormat.format(Utils._("About {0}"), "YajHFC"));
                break;
            }
            case READMES: {
                for (int i = 0; i < readmeFiles.length; ++i) {
                    JScrollPane jScrollPane = this.addScrollTxt("/" + readmeFiles[i], true);
                    if (jScrollPane != null) {
                        this.tabMain.addTab(readmeFiles[i], jScrollPane);
                    }
                    if (jScrollPane != null && (!addEnglishReadme[i] || Utils.getLocale().equals(Locale.ENGLISH)) || (jScrollPane = this.addScrollTxt("/" + readmeFiles[i], false)) == null) continue;
                    this.tabMain.addTab(MessageFormat.format("{0} ({1})", readmeFiles[i], Locale.ENGLISH.getDisplayLanguage(Utils.getLocale())), jScrollPane);
                }
                this.setTitle(Utils._("Documentation"));
                this.setSize(640, 480);
                break;
            }
            default: {
                log.log(Level.WARNING, "Invalid mode!");
            }
        }
    }

    public AboutDialog(Frame frame) {
        super(frame);
        this.initialize();
        this.setLocationRelativeTo(frame);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ABOUT,
        READMES;

    }
}

