/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.EnumMap;
import java.util.Map;
import yajhfc.DateStyle;
import yajhfc.FaxOptions;
import yajhfc.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DateKind {
    TIME_ONLY,
    DATE_ONLY,
    DATE_AND_TIME,
    DURATION;

    private static final Map<DateKind, DateFormat> lastInstances;
    private static String lastDateStyle;
    private static String lastTimeStyle;

    public DateFormat getFormat() {
        return DateKind.getInstanceFromKind(this);
    }

    public static DateFormat getInstanceFromKind(DateKind dateKind) {
        DateFormat dateFormat;
        FaxOptions faxOptions = Utils.getFaxOptions();
        if (lastDateStyle != faxOptions.dateStyle && !faxOptions.dateStyle.equals(lastDateStyle) || lastTimeStyle != faxOptions.timeStyle && !faxOptions.timeStyle.equals(lastTimeStyle)) {
            lastInstances.clear();
            dateFormat = null;
            lastDateStyle = faxOptions.dateStyle;
            lastTimeStyle = faxOptions.timeStyle;
        } else {
            dateFormat = lastInstances.get((Object)dateKind);
        }
        if (dateFormat == null) {
            switch (dateKind) {
                case DATE_ONLY: {
                    dateFormat = DateStyle.getDateFormatFromString(faxOptions.dateStyle);
                    break;
                }
                case TIME_ONLY: {
                    dateFormat = DateStyle.getTimeFormatFromString(faxOptions.timeStyle);
                    break;
                }
                case DATE_AND_TIME: {
                    dateFormat = DateStyle.getDateTimeFormatFromString(faxOptions.dateStyle, faxOptions.timeStyle);
                    break;
                }
                case DURATION: {
                    dateFormat = new SimpleDateFormat("HH:mm:ss");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown kind!");
                }
            }
            lastInstances.put(dateKind, dateFormat);
        }
        return dateFormat;
    }

    static {
        lastInstances = new EnumMap<DateKind, DateFormat>(DateKind.class);
    }
}

