/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.PlatformInfo;
import yajhfc.Utils;
import yajhfc.util.ExceptionDialog;

public class DesktopManager {
    protected final String viewer = PlatformInfo.getSystemViewerCommandLine();
    private static DesktopManager defaultManager;
    private static final String JAVA6_MANAGER = "yajhfc.Java6DesktopManager";

    public void safeBrowse(URI uRI, Component component) {
        try {
            this.browse(uRI);
        }
        catch (IOException iOException) {
            StringSelection stringSelection = new StringSelection(uRI.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            ExceptionDialog.showExceptionDialog(component, MessageFormat.format(Utils._("Could not start the default browser for the URL \"{0}\".\nThe URL has been copied to the clipboard instead."), uRI), iOException);
        }
    }

    public void browse(URI uRI) throws IOException {
        if (this.viewer == null) {
            throw new IOException("Could not determine the system viewer application.");
        }
        Utils.startViewer(this.viewer, uRI);
    }

    public void open(File file) throws IOException {
        if (this.viewer == null) {
            throw new IOException("Could not determine the system viewer application.");
        }
        Utils.startViewer(this.viewer, file);
    }

    public static DesktopManager getDefault() {
        if (defaultManager == null) {
            try {
                Class.forName("java.awt.Desktop");
                defaultManager = (DesktopManager)Class.forName(JAVA6_MANAGER).newInstance();
            }
            catch (Exception exception) {
                if (Utils.debugMode) {
                    Logger.getLogger(DesktopManager.class.getName()).log(Level.INFO, "Using Java 5 desktop manager:", exception);
                }
                defaultManager = new DesktopManager();
            }
        }
        return defaultManager;
    }
}

