/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import yajhfc.Utils;

public final class PlatformInfo {
    private static final Logger log = Logger.getLogger(PlatformInfo.class.getName());
    public static final boolean IS_WINDOWS;
    public static final boolean IS_MACOSX;
    public static final boolean IS_UNIX_LIKE;
    public static final boolean IS_X11;
    static final boolean buggyLocationByPlatform;
    private static String systemViewer;

    public static boolean isKDE() {
        return IS_X11 && Utils.firstDefined(System.getenv("KDE_FULL_SESSION"), "").length() > 0;
    }

    public static boolean isGNOME() {
        return IS_X11 && Utils.firstDefined(System.getenv("GNOME_DESKTOP_SESSION_ID"), "").length() > 0;
    }

    public static int getGNOMEMajorVersion() {
        if (!PlatformInfo.isGNOME()) {
            return -1;
        }
        try {
            int n;
            Process process = new ProcessBuilder("gnome-session", "--version").redirectErrorStream(true).start();
            process.getOutputStream().close();
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[255];
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            while ((n = inputStreamReader.read(cArray)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
            ((Reader)inputStreamReader).close();
            String string = stringBuilder.toString();
            log.fine(string);
            Matcher matcher = Pattern.compile("^[\\w\\-]+\\s+(\\d+)\\.(\\d+)").matcher(string);
            if (matcher.find()) {
                int n2 = Integer.parseInt(matcher.group(1));
                log.fine("Detected gnome version: " + n2);
                return n2;
            }
            log.info("Cannot parse 'gnome-session --version'-output: " + string);
            return -1;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Cannot determine GNOME version", exception);
            return -1;
        }
    }

    public static String getSystemViewerCommandLine() {
        if ("".equals(systemViewer)) {
            if (IS_WINDOWS) {
                String string = System.getenv("COMSPEC");
                if (string == null) {
                    string = "COMMAND";
                }
                systemViewer = string = string + " /C start \"Viewer\" \"%s\"";
            } else {
                systemViewer = IS_MACOSX ? "open \"%s\"" : (Utils.searchExecutableInPath("xdg-open") != null ? "xdg-open \"%s\"" : (PlatformInfo.isKDE() ? "kfmclient exec \"%s\"" : (PlatformInfo.isGNOME() ? "gnome-open \"%s\"" : (Utils.searchExecutableInPath("exo-open") != null ? "exo-open \"%s\"" : (Utils.searchExecutableInPath("gnome-open") != null ? "gnome-open \"%s\"" : (Utils.searchExecutableInPath("kfmclient") != null ? "kfmclient exec \"%s\"" : null))))));
            }
        }
        return systemViewer;
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        IS_WINDOWS = string.contains("windows");
        IS_MACOSX = string.startsWith("mac os x");
        IS_UNIX_LIKE = IS_MACOSX || !IS_WINDOWS && File.separatorChar == '/';
        IS_X11 = !IS_WINDOWS && !IS_MACOSX && (System.getProperty("java.awt.graphicsenv", "").contains("X11") || Utils.firstDefined(System.getenv("DISPLAY"), "").length() > 0);
        boolean bl = buggyLocationByPlatform = IS_WINDOWS && (string.equals("windows 95") || string.equals("windows 98") || string.equals("windows me"));
        if (Utils.debugMode) {
            log.info("IS_WINDOWS=" + IS_WINDOWS + "; IS_MACOSX=" + IS_MACOSX + "; IS_UNIX_LIKE=" + IS_UNIX_LIKE + "; IS_X11=" + IS_X11);
        }
        systemViewer = "";
    }
}

