/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import yajhfc.DateKind;
import yajhfc.DesktopManager;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.YajHFCVersion;
import yajhfc.launch.Launcher2;
import yajhfc.util.ProgressWorker;

public class UpdateChecker {
    static final Logger log = Logger.getLogger(UpdateChecker.class.getName());
    private static final String UPDATE_URL = "http://update.yajhfc.de/versioninfo.xml";
    private static final String RELEASE_DATE_FORMAT = "yyyy-MM-dd";
    private static final long CHECK_INTERVAL = 604800000L;
    protected YajHFCVersion currentVersion = null;
    protected Date releaseDate = null;
    protected URI infoURI = null;

    public boolean showInfoDialog(final Window window, boolean bl) {
        String string = Utils._("There is a new version of YajHFC available!") + "\n\n" + Utils._("Version") + ": " + this.currentVersion + '\n' + Utils._("Release date") + ": " + DateKind.getInstanceFromKind(DateKind.DATE_ONLY).format(this.releaseDate);
        JButton jButton = new JButton(Utils._("Go to website"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DesktopManager.getDefault().safeBrowse(UpdateChecker.this.infoURI, window);
            }
        });
        Object[] objectArray = bl ? new Object[]{jButton, Utils._("Remind me again"), Utils._("Do not remind me again")} : new Object[]{jButton, Utils._("Close")};
        int n = JOptionPane.showOptionDialog(window, string, Utils._("Check for update"), -1, 1, null, objectArray, objectArray[0]);
        return n == -1 || n == 1;
    }

    public boolean checkForUpdates() throws ParserConfigurationException, MalformedURLException, IOException, SAXException, DOMException, ParseException, URISyntaxException {
        log.info("Checking for updates from URL http://update.yajhfc.de/versioninfo.xml");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputStream inputStream = new URL(UPDATE_URL).openStream();
        Document document = documentBuilder.parse(inputStream);
        inputStream.close();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        this.currentVersion = null;
        this.releaseDate = null;
        this.infoURI = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string = node.getNodeName();
            String string2 = node.getTextContent().trim();
            if ("currentVersion".equals(string)) {
                log.fine("Found currentVersion tag: " + string2);
                this.currentVersion = new YajHFCVersion(string2);
                continue;
            }
            if ("releaseDate".equals(string)) {
                log.fine("Found releaseDate tag: " + string2);
                this.releaseDate = new SimpleDateFormat(RELEASE_DATE_FORMAT).parse(string2);
                continue;
            }
            if ("infoURL".equals(string)) {
                log.fine("Found infoURL tag: " + string2);
                this.infoURI = new URI(string2);
                continue;
            }
            log.warning("Unknown element \"" + string + "\" with content: " + string2);
        }
        if (this.currentVersion == null || this.releaseDate == null || this.infoURI == null) {
            throw new ParseException("Not all required fields found in XML.", -1);
        }
        log.fine(String.format("Successfully loaded update XML: currentVersion=\"%s\", releaseDate=\"%tF\", infoURL=\"%s\"", this.currentVersion, this.releaseDate, this.infoURI));
        YajHFCVersion yajHFCVersion = new YajHFCVersion();
        if (yajHFCVersion.compareTo(this.currentVersion) < 0) {
            log.info("A newer version is available: local: " + yajHFCVersion + "; remote: " + this.currentVersion);
            return true;
        }
        log.info("No newer version available: local: " + yajHFCVersion + "; remote: " + this.currentVersion);
        return false;
    }

    public static void startSilentUpdateCheck() {
        final FaxOptions faxOptions = Utils.getFaxOptions();
        if (System.currentTimeMillis() - faxOptions.lastUpdateCheck > 604800000L) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        final UpdateChecker updateChecker = new UpdateChecker();
                        if (updateChecker.checkForUpdates() && ("".equals(faxOptions.lastSeenUpdateVersion) || new YajHFCVersion(faxOptions.lastSeenUpdateVersion).compareTo(updateChecker.currentVersion) >= 0)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    faxOptions.lastSeenUpdateVersion = updateChecker.showInfoDialog(Launcher2.application.getFrame(), true) ? "" : updateChecker.currentVersion.toString();
                                }
                            });
                        }
                        faxOptions.lastUpdateCheck = System.currentTimeMillis();
                    }
                    catch (Exception exception) {
                        log.log(Level.WARNING, "Exception checking for updates:", exception);
                    }
                }
            };
            Utils.executorService.submit(runnable);
        }
    }

    public static void doGUIUpdateCheck(Window window, ProgressWorker.ProgressUI progressUI) {
        ProgressWorker progressWorker = new ProgressWorker(){
            private UpdateChecker uc;
            private Boolean checkResult;

            public void doWork() {
                this.updateNote(Utils._("Connecting to server..."));
                this.uc = new UpdateChecker();
                try {
                    this.checkResult = this.uc.checkForUpdates();
                }
                catch (Exception exception) {
                    this.showExceptionDialog(Utils._("Error checking for updates:"), exception);
                    this.checkResult = null;
                }
                Utils.getFaxOptions().lastUpdateCheck = System.currentTimeMillis();
            }

            protected void pMonClosed() {
                if (this.checkResult != null) {
                    if (this.checkResult.booleanValue()) {
                        this.uc.showInfoDialog(this.dialogs.getParent(), false);
                    } else {
                        this.dialogs.showMessageDialog(Utils._("Your version of YajHFC is up to date."), Utils._("Check for update"), 1);
                    }
                }
            }
        };
        progressWorker.setProgressMonitor(progressUI);
        progressWorker.startWork(window, Utils._("Checking for updates..."));
    }
}

