/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.customprops;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.customprops.CustomPropOptionsPanel;
import yajhfc.options.PanelTreeNode;
import yajhfc.plugin.PluginManager;
import yajhfc.plugin.PluginUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryPoint
extends PluginUI {
    public static final String PROP_USE_SYSTEM_PROXIES = "java.net.useSystemProxies";
    public static final String PROP_HTTP_HOST = "http.proxyHost";
    public static final String PROP_HTTP_PORT = "http.proxyPort";
    public static final String PROP_HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String PREFIX = "javaprop";
    private static final int VERSION = 1;
    static final Logger log = Logger.getLogger(EntryPoint.class.getName());
    protected static Map<String, String> customJavaProperties;

    private static Map<String, String> loadCustomProperties(Properties properties) {
        int n;
        String string = properties.getProperty("javaprop-VERSION");
        if (string == null) {
            n = 0;
        } else {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (n < 1) {
            // empty if block
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("javaprop--")) continue;
            hashMap.put(string2.substring(PREFIX.length() + 2), properties.getProperty(string2));
        }
        return hashMap;
    }

    private static void saveCustomProperties(Map<String, String> map, Properties properties) {
        properties.put("javaprop-VERSION", String.valueOf(1));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            properties.put("javaprop--" + entry.getKey(), entry.getValue());
        }
    }

    public static Map<String, String> getCustomJavaProperties() {
        return customJavaProperties;
    }

    public static boolean init(int n) {
        PluginManager.pluginUIs.add(new EntryPoint());
        customJavaProperties = EntryPoint.loadCustomProperties(Utils.getSettingsProperties());
        System.getProperties().putAll(customJavaProperties);
        return true;
    }

    @Override
    public void saveOptions(Properties properties) {
        EntryPoint.saveCustomProperties(customJavaProperties, properties);
    }

    @Override
    public PanelTreeNode createOptionsPanel(PanelTreeNode panelTreeNode) {
        return new PanelTreeNode(panelTreeNode, new CustomPropOptionsPanel(), Utils._("Proxies and system properties"), Utils.loadIcon("development/WebComponent"));
    }

    @Override
    public int getOptionsPanelParent() {
        return 1;
    }
}

