/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.export;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import yajhfc.MainWin;
import yajhfc.Utils;
import yajhfc.export.ExportCSVAction;
import yajhfc.export.ExportXMLAction;
import yajhfc.export.TooltipJTableHTMLExporter;
import yajhfc.file.FileFormat;
import yajhfc.model.FmtItem;
import yajhfc.model.ui.TooltipJTable;
import yajhfc.server.ServerManager;
import yajhfc.util.ExampleFileFilter;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.ProgressWorker;
import yajhfc.util.SafeJFileChooser;

public class ExportAction
extends ExcDialogAbstractAction {
    protected final MainWin parent;
    private JFileChooser fileChooser;
    private static final FileFormat[] supportedFormats = new FileFormat[]{FileFormat.CSV, FileFormat.HTML, FileFormat.XML};
    private FileFilter[] filters;

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new SafeJFileChooser();
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            for (FileFormat fileFormat : supportedFormats) {
                this.fileChooser.addChoosableFileFilter(new ExampleFileFilter(fileFormat.getPossibleExtensions(), fileFormat.getDescription()));
            }
            this.filters = this.fileChooser.getChoosableFileFilters();
            this.fileChooser.setFileFilter(this.getFilterFromFormat(Utils.getFaxOptions().lastExportFormat));
            if (Utils.getFaxOptions().lastExportSavePath != null) {
                this.fileChooser.setCurrentDirectory(new File(Utils.getFaxOptions().lastExportSavePath));
            }
        }
        return this.fileChooser;
    }

    private FileFilter getFilterFromFormat(FileFormat fileFormat) {
        for (int i = 0; i < supportedFormats.length; ++i) {
            if (supportedFormats[i] != fileFormat) continue;
            return this.filters[i];
        }
        return null;
    }

    private FileFormat getFormatFromFilter(FileFilter fileFilter) {
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i] != fileFilter) continue;
            return supportedFormats[i];
        }
        return null;
    }

    protected void actualActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.showSaveDialog(this.parent) != 0) {
            return;
        }
        try {
            FileFormat fileFormat;
            Utils.getFaxOptions().lastExportSavePath = jFileChooser.getCurrentDirectory().getAbsolutePath();
            Utils.getFaxOptions().lastExportFormat = fileFormat = this.getFormatFromFilter(jFileChooser.getFileFilter());
            File file = Utils.getSelectedFileFromSaveChooser(jFileChooser);
            switch (fileFormat) {
                case CSV: {
                    ExportCSVAction.exportToCSV(this.parent, file);
                    break;
                }
                case HTML: {
                    this.exportToHTML(file);
                    break;
                }
                case XML: {
                    ExportXMLAction.exportToXML(this.parent, file);
                    break;
                }
                default: {
                    Logger.getLogger(ExportAction.class.getName()).severe("Unsupported file format selected.");
                    JOptionPane.showMessageDialog(this.parent, "Unsupported file format selected.");
                    break;
                }
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog(this.parent, Utils._("Error saving the table:"), exception);
        }
    }

    private void exportToHTML(final File file) {
        Utils.setWaitCursor(null);
        final String string = this.parent.getSelectedTableDescription();
        final TooltipJTable<? extends FmtItem> tooltipJTable = this.parent.getSelectedTable();
        ProgressWorker progressWorker = new ProgressWorker(){

            protected void initialize() {
                this.progressMonitor = ExportAction.this.parent.getTablePanel();
            }

            public void doWork() {
                try {
                    this.updateNote(Utils._("Exporting..."));
                    String string2 = Utils._("Server") + ": " + ServerManager.getDefault().getCurrent().toString();
                    TooltipJTableHTMLExporter tooltipJTableHTMLExporter = new TooltipJTableHTMLExporter();
                    tooltipJTableHTMLExporter.saveToFile(file, tooltipJTable.getModel(), string, string2);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog(ExportAction.this.parent, Utils._("Error saving the table:"), exception);
                }
            }

            protected void done() {
                Utils.unsetWaitCursor(null);
            }
        };
        progressWorker.startWork(this.parent, Utils._("Export to HTML"));
    }

    public ExportAction(MainWin mainWin) {
        this.putValue("Name", Utils._("Export") + "...");
        this.putValue("ShortDescription", Utils._("Exports the list of faxes in CSV, HTML or XML format"));
        this.putValue("SmallIcon", Utils.loadIcon("general/Save"));
        this.parent = mainWin;
    }
}

