/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.export;

import au.com.bytecode.opencsv.CSVWriter;
import java.awt.Frame;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import javax.swing.table.TableModel;
import yajhfc.MainWin;
import yajhfc.Utils;
import yajhfc.export.ExportCSVSettings;
import yajhfc.model.FmtItem;
import yajhfc.model.ui.TooltipJTable;
import yajhfc.phonebook.csv.CSVDialog;
import yajhfc.util.ProgressWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportCSVAction {
    public static void exportToCSV(final MainWin mainWin, File file) {
        final ExportCSVSettings exportCSVSettings = new ExportCSVSettings();
        exportCSVSettings.loadFromString(Utils.getFaxOptions().csvExportSettings);
        exportCSVSettings.fileName = file.getPath();
        CSVDialog cSVDialog = new CSVDialog((Frame)mainWin, exportCSVSettings, MessageFormat.format(Utils._("Save to CSV file {0}"), Utils.shortenFileNameForDisplay(exportCSVSettings.fileName, 30)));
        Utils.setDefWinPos(cSVDialog);
        cSVDialog.setVisible(true);
        if (!cSVDialog.clickedOK) {
            return;
        }
        Utils.setWaitCursor(null);
        final TooltipJTable<? extends FmtItem> tooltipJTable = mainWin.getSelectedTable();
        ProgressWorker progressWorker = new ProgressWorker(){

            protected void initialize() {
                this.progressMonitor = mainWin.getTablePanel();
            }

            public void doWork() {
                try {
                    this.updateNote(Utils._("Exporting..."));
                    CSVWriter cSVWriter = exportCSVSettings.createWriter();
                    ExportCSVAction.exportTableModeltoCSV(tooltipJTable.getModel(), tooltipJTable.getRealModel().getColumns(), cSVWriter, exportCSVSettings.firstLineAreHeaders);
                    cSVWriter.close();
                    Utils.getFaxOptions().csvExportSettings = exportCSVSettings.saveToString();
                }
                catch (Exception exception) {
                    this.showExceptionDialog(Utils._("Error saving the table:"), exception);
                }
            }

            protected void done() {
                Utils.unsetWaitCursor(null);
            }
        };
        progressWorker.startWork(mainWin, Utils._("Save to CSV"));
    }

    public static void exportTableModeltoCSV(TableModel tableModel, List<? extends FmtItem> list, CSVWriter cSVWriter, boolean bl) {
        int n;
        String[] stringArray = new String[tableModel.getColumnCount()];
        if (bl) {
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = tableModel.getColumnName(n);
            }
            cSVWriter.writeNext(stringArray);
        }
        for (n = 0; n < tableModel.getRowCount(); ++n) {
            for (int i = 0; i < stringArray.length; ++i) {
                Object object = tableModel.getValueAt(n, i);
                stringArray[i] = object instanceof Date ? list.get(i).getDisplayDateFormat().format(object) : (object instanceof Boolean ? ((Boolean)object != false ? "Y" : "N") : (object != null ? object.toString() : ""));
            }
            cSVWriter.writeNext(stringArray);
        }
    }
}

