/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.faxcover.tag;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import yajhfc.faxcover.Faxcover;
import yajhfc.faxcover.tag.ConditionState;
import yajhfc.faxcover.tag.ElseTag;
import yajhfc.faxcover.tag.EndIfTag;
import yajhfc.faxcover.tag.IfAllFilledTag;
import yajhfc.faxcover.tag.IfNotTag;
import yajhfc.faxcover.tag.IfSomeFilledTag;
import yajhfc.faxcover.tag.PBFieldTag;
import yajhfc.faxcover.tag.ReflectionTag;
import yajhfc.faxcover.tag.RuleTag;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.convrules.PBEntryFieldContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Tag {
    static final Logger log = Logger.getLogger(Tag.class.getName());
    public static final Map<String, Tag> availableTags = new HashMap<String, Tag>();

    public abstract String getValue(Faxcover var1, List<ConditionState> var2, String var3);

    public boolean valueIsRaw() {
        return false;
    }

    static {
        availableTags.put("name", new RuleTag("nameRule", false));
        availableTags.put("surname", new PBFieldTag(PBEntryField.Name, false));
        availableTags.put("givenname", new PBFieldTag(PBEntryField.GivenName, false));
        availableTags.put("title", new PBFieldTag(PBEntryField.Title, false));
        availableTags.put("position", new PBFieldTag(PBEntryField.Position, false));
        availableTags.put("company", new RuleTag("companyRule", false));
        availableTags.put("companyname", new PBFieldTag(PBEntryField.Company, false));
        availableTags.put("department", new PBFieldTag(PBEntryField.Department, false));
        availableTags.put("location", new RuleTag("locationRule", false));
        availableTags.put("street", new PBFieldTag(PBEntryField.Street, false));
        availableTags.put("place", new PBFieldTag(PBEntryField.Location, false));
        availableTags.put("zipcode", new PBFieldTag(PBEntryField.ZIPCode, false));
        availableTags.put("state", new PBFieldTag(PBEntryField.State, false));
        availableTags.put("country", new PBFieldTag(PBEntryField.Country, false));
        availableTags.put("faxnumber", new PBFieldTag(PBEntryField.FaxNumber, false));
        availableTags.put("voicenumber", new PBFieldTag(PBEntryField.VoiceNumber, false));
        availableTags.put("email", new PBFieldTag(PBEntryField.EMailAddress, false));
        availableTags.put("website", new PBFieldTag(PBEntryField.WebSite, false));
        availableTags.put("fromname", new RuleTag("nameRule", true));
        availableTags.put("fromsurname", new PBFieldTag(PBEntryField.Name, true));
        availableTags.put("fromgivenname", new PBFieldTag(PBEntryField.GivenName, true));
        availableTags.put("fromtitle", new PBFieldTag(PBEntryField.Title, true));
        availableTags.put("fromposition", new PBFieldTag(PBEntryField.Position, true));
        availableTags.put("fromcompany", new RuleTag("companyRule", true));
        availableTags.put("fromcompanyname", new PBFieldTag(PBEntryField.Company, true));
        availableTags.put("fromdepartment", new PBFieldTag(PBEntryField.Department, true));
        availableTags.put("fromlocation", new RuleTag("locationRule", true));
        availableTags.put("fromstreet", new PBFieldTag(PBEntryField.Street, true));
        availableTags.put("fromplace", new PBFieldTag(PBEntryField.Location, true));
        availableTags.put("fromzipcode", new PBFieldTag(PBEntryField.ZIPCode, true));
        availableTags.put("fromstate", new PBFieldTag(PBEntryField.State, true));
        availableTags.put("fromcountry", new PBFieldTag(PBEntryField.Country, true));
        availableTags.put("fromfaxnumber", new PBFieldTag(PBEntryField.FaxNumber, true));
        availableTags.put("fromvoicenumber", new PBFieldTag(PBEntryField.VoiceNumber, true));
        availableTags.put("fromemail", new PBFieldTag(PBEntryField.EMailAddress, true));
        availableTags.put("fromwebsite", new PBFieldTag(PBEntryField.WebSite, true));
        availableTags.put("subject", new ReflectionTag("regarding"));
        availableTags.put("comments", new ReflectionTag("comments"));
        availableTags.put("date", new Tag(){

            @Override
            public String getValue(Faxcover faxcover, List<ConditionState> list, String string) {
                return faxcover.dateFmt.format(faxcover.coverDate);
            }
        });
        availableTags.put("pagecount", new ReflectionTag("pageCount"));
        availableTags.put("totalpagecount", new Tag(){

            @Override
            public String getValue(Faxcover faxcover, List<ConditionState> list, String string) {
                return String.valueOf(faxcover.pageCount + 1);
            }
        });
        availableTags.put("ccnameandfax", new Tag(){

            @Override
            public String getValue(Faxcover faxcover, List<ConditionState> list, String string) {
                if (faxcover.ccData == null || faxcover.ccData.length == 0) {
                    return "";
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (PBEntryFieldContainer pBEntryFieldContainer : faxcover.ccData) {
                    if (pBEntryFieldContainer == null) continue;
                    faxcover.nameRule.applyRule(pBEntryFieldContainer, stringBuilder);
                    stringBuilder.append(" <");
                    stringBuilder.append(pBEntryFieldContainer.getField(PBEntryField.FaxNumber));
                    stringBuilder.append(">; ");
                }
                if (stringBuilder.length() > 2) {
                    return stringBuilder.substring(0, stringBuilder.length() - 2);
                }
                return "";
            }
        });
        IfAllFilledTag ifAllFilledTag = new IfAllFilledTag();
        IfSomeFilledTag ifSomeFilledTag = new IfSomeFilledTag();
        availableTags.put("ifallfilled", ifAllFilledTag);
        availableTags.put("ifsomefilled", ifSomeFilledTag);
        availableTags.put("ifallempty", new IfNotTag(ifSomeFilledTag));
        availableTags.put("ifsomeempty", new IfNotTag(ifAllFilledTag));
        availableTags.put("else", new ElseTag());
        availableTags.put("endif", new EndIfTag());
    }
}

