/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.swing.JEditorPane;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import yajhfc.PaperSize;
import yajhfc.Utils;
import yajhfc.file.FileConverter;
import yajhfc.file.FileFormat;
import yajhfc.file.PrintServiceFileConverter;
import yajhfc.util.BOMInputStream;

public class EditorPaneFileConverter
extends PrintServiceFileConverter {
    public static final EditorPaneFileConverter HTML_CONVERTER = new EditorPaneFileConverter("text/html");
    protected String contentType;
    protected Font baseFont;

    public EditorPaneFileConverter(String string) {
        super(DocFlavor.SERVICE_FORMATTED.PRINTABLE);
        this.contentType = string;
    }

    public EditorPaneFileConverter(String string, Font font) {
        super(DocFlavor.SERVICE_FORMATTED.PRINTABLE);
        this.contentType = string;
        this.baseFont = font;
    }

    public void convertToHylaFormat(File file, OutputStream outputStream, PaperSize paperSize, FileFormat fileFormat) throws FileConverter.ConversionException {
        try {
            URL uRL = file.toURI().toURL();
            this.convertToHylaFormat(uRL, outputStream, paperSize, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileConverter.ConversionException(malformedURLException);
        }
    }

    public void convertToHylaFormat(URL uRL, OutputStream outputStream, PaperSize paperSize, URL uRL2) throws FileConverter.ConversionException {
        try {
            PrintableEditorPane printableEditorPane = new PrintableEditorPane(paperSize.getSize());
            if (this.baseFont != null) {
                printableEditorPane.setFont(this.baseFont);
            }
            printableEditorPane.loadURL(uRL, this.contentType, uRL2);
            this.convertUsingPrintService(printableEditorPane, outputStream, paperSize);
        }
        catch (IOException iOException) {
            throw new FileConverter.ConversionException(iOException);
        }
    }

    public static class SyncHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        public View create(Element element) {
            Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (object == HTML.Tag.IMG) {
                ImageView imageView = new ImageView(element);
                imageView.setLoadsSynchronously(true);
                return imageView;
            }
            return super.create(element);
        }
    }

    public static class SyncHTMLEditorKit
    extends HTMLEditorKit {
        protected static final HTMLEditorKit.HTMLFactory factory = new SyncHTMLFactory();

        public ViewFactory getViewFactory() {
            return factory;
        }
    }

    public static class FixedBaseHTMLDocument
    extends HTMLDocument {
        protected URL fixedBase;

        public FixedBaseHTMLDocument(URL uRL) {
            this.fixedBase = uRL;
            this.setAsynchronousLoadPriority(-1);
        }

        public URL getBase() {
            return this.fixedBase;
        }
    }

    public static class PrintableEditorPane
    extends JEditorPane
    implements Printable {
        private static final int assumedBordersMM = 0;

        public PrintableEditorPane(Dimension dimension) {
            this.setDoubleBuffered(false);
            this.setSize((int)((double)((dimension.width - 0) * 72) / 25.4), (int)((double)((dimension.height - 0) * 72) / 25.4));
        }

        public void loadURL(URL uRL, String string, URL uRL2) throws IOException {
            if (string.contains("text/html")) {
                this.setEditorKit(new SyncHTMLEditorKit());
                FixedBaseHTMLDocument fixedBaseHTMLDocument = new FixedBaseHTMLDocument(uRL2);
                fixedBaseHTMLDocument.putProperty("stream", uRL);
                this.read(uRL.openStream(), (Object)fixedBaseHTMLDocument);
            } else {
                BOMInputStream bOMInputStream = new BOMInputStream(uRL.openStream());
                this.setContentType(string + "; charset=" + Utils.firstDefined(bOMInputStream.getDetectedCharset(), System.getProperty("file.encoding", "utf-8")));
                this.read(bOMInputStream, (Object)uRL2);
            }
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.black);
            Dimension dimension = this.getPreferredSize();
            double d = this.getWidth();
            double d2 = dimension.height;
            double d3 = pageFormat.getImageableWidth();
            double d4 = pageFormat.getImageableHeight();
            double d5 = d3 / d;
            int n2 = (int)Math.ceil(d5 * d2 / d4);
            if (Utils.debugMode) {
                Logger logger = Logger.getLogger(PrintableEditorPane.class.getName());
                logger.fine(String.format("Panel: Size : %d x %d; Preferred Size = %d x %d", this.getWidth(), this.getHeight(), dimension.width, dimension.height));
                logger.fine(String.format("ImageableWidth: %f, ImageableHeight: %f, pageIndex: %d, totalNumPages: %d", d3, d4, n, n2));
            }
            if (n >= n2) {
                return 1;
            }
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY() - (double)n * d4);
            graphics2D.scale(d5, d5);
            this.paint(graphics2D);
            return 0;
        }
    }
}

