/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import java.util.Collection;
import javax.swing.filechooser.FileFilter;
import yajhfc.Utils;
import yajhfc.util.ExampleFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileFormat {
    PostScript(Utils._("Postscript documents"), "ps"),
    PDF(Utils._("PDF documents"), "pdf"),
    PCL(Utils._("PCL files"), "pcl"),
    JPEG(Utils._("JPEG pictures"), "jpeg", "jpg"),
    PNG(Utils._("PNG pictures"), "png"),
    GIF(Utils._("GIF pictures"), "gif"),
    TIFF(Utils._("TIFF pictures"), "tiff", "tif"),
    PlainText(Utils._("Text files"), "txt"),
    XML(Utils._("XML documents"), "xml"),
    FOP(Utils._("XSL:FO documents"), "fo", "xml", "fop"),
    ODT(Utils._("OpenDocument text documents"), "odt"),
    HTML(Utils._("HTML documents"), "html", "htm"),
    RTF(Utils._("RTF documents"), "rtf"),
    CSV(Utils._("CSV files"), "csv", "txt"),
    PJL(Utils._("PJL printer job"), "pjl"),
    Any(Utils._("Any files"), "dat", "/any\\"),
    Unknown(Utils._("Unknown files"), "");

    private String defaultExt;
    private String[] possibleExts;
    private String description;
    private String shortDesc;

    private FileFormat(String string2, String ... stringArray) {
        this(string2, (String)null, stringArray[0], stringArray);
    }

    private FileFormat(String string2, String string3, String string4, String[] stringArray) {
        this.defaultExt = string4;
        this.possibleExts = stringArray;
        this.description = string2;
        this.shortDesc = string3;
    }

    public String getDefaultExtension() {
        return this.defaultExt;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getPossibleExtensions() {
        return this.possibleExts;
    }

    public String toString() {
        if (this.shortDesc != null) {
            return this.shortDesc;
        }
        return super.toString();
    }

    public String getHylaFAXFormatString() {
        switch (this) {
            case PDF: {
                return "pdf";
            }
            case PostScript: {
                return "ps";
            }
            case TIFF: {
                return "tiff";
            }
        }
        return "data";
    }

    public FileFilter createFileFilter() {
        return new ExampleFileFilter(this.getPossibleExtensions(), this.getDescription());
    }

    public static FileFilter[] createFileFiltersFromFormats(Collection<FileFormat> collection) {
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter((String)null, Utils._("All supported file formats"));
        exampleFileFilter.setExtensionListInDescription(false);
        FileFilter[] fileFilterArray = new FileFilter[collection.size() + 1];
        fileFilterArray[0] = exampleFileFilter;
        int n = 0;
        for (FileFormat fileFormat : collection) {
            for (String string : fileFormat.getPossibleExtensions()) {
                exampleFileFilter.addExtension(string);
            }
            fileFilterArray[++n] = fileFormat.createFileFilter();
        }
        return fileFilterArray;
    }
}

