/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdErrThread
extends Thread {
    private static final Logger log = Logger.getLogger(StdErrThread.class.getName());
    protected final String commandName;
    protected final InputStream errStream;
    protected final LinkedList<String> tail = new LinkedList();
    protected final int maxTail;

    public StdErrThread(String string, InputStream inputStream) {
        this(string, inputStream, 10);
    }

    public StdErrThread(String string, InputStream inputStream, int n) {
        super("StdErrThread-" + string);
        this.commandName = string;
        this.errStream = inputStream;
        this.maxTail = n;
        this.setDaemon(true);
        this.setPriority(1);
        this.start();
    }

    @Override
    public void run() {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.errStream));
            while ((string = bufferedReader.readLine()) != null) {
                log.info(this.commandName + " output: " + string);
                this.tail.offer(string);
                while (this.tail.size() > this.maxTail) {
                    this.tail.poll();
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error reading stderr for " + this.commandName, exception);
        }
    }

    public LinkedList<String> getTail() {
        return this.tail;
    }
}

