/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.filters;

import java.util.regex.Pattern;
import yajhfc.filters.Filter;
import yajhfc.filters.FilterKey;
import yajhfc.filters.FilterableObject;
import yajhfc.filters.StringFilterOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStringFilter<V extends FilterableObject, K extends FilterKey>
implements Filter<V, K> {
    protected Object compareValue = null;
    protected StringFilterOperator operator;
    protected boolean caseSensitive;

    public AbstractStringFilter(StringFilterOperator stringFilterOperator, String string, boolean bl) {
        this.operator = stringFilterOperator;
        this.compareValue = stringFilterOperator == StringFilterOperator.MATCHES ? Pattern.compile(string, bl ? 0 : 66) : (bl ? string : string.toLowerCase());
        this.caseSensitive = bl;
    }

    protected boolean doActualMatch(String string) {
        if (this.compareValue == null || this.operator == null) {
            return false;
        }
        if (!this.caseSensitive && this.operator != StringFilterOperator.MATCHES) {
            string = string.toLowerCase();
        }
        switch (this.operator) {
            case EQUAL: {
                return string.equals(this.compareValue);
            }
            case NOTEQUAL: {
                return !string.equals(this.compareValue);
            }
            case CONTAINS: {
                return string.contains((String)this.compareValue);
            }
            case CONTAINS_NOT: {
                return !string.contains((String)this.compareValue);
            }
            case STARTSWITH: {
                return string.startsWith((String)this.compareValue);
            }
            case ENDSWITH: {
                return string.endsWith((String)this.compareValue);
            }
            case MATCHES: {
                return ((Pattern)this.compareValue).matcher(string).matches();
            }
        }
        return true;
    }

    public Object getCompareValue() {
        return this.compareValue;
    }

    public StringFilterOperator getOperator() {
        return this.operator;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    protected abstract void fieldToString(StringBuilder var1);

    @Override
    public void toString(StringBuilder stringBuilder) {
        this.fieldToString(stringBuilder);
        stringBuilder.append(' ').append((Object)this.operator).append(" \"").append(this.compareValue).append('\"');
    }
}

