/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.filters.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import yajhfc.Utils;
import yajhfc.filters.AndFilter;
import yajhfc.filters.CombinationFilter;
import yajhfc.filters.Filter;
import yajhfc.filters.FilterKey;
import yajhfc.filters.FilterKeyList;
import yajhfc.filters.FilterableObject;
import yajhfc.filters.OrFilter;
import yajhfc.filters.ui.FilterPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomFilterDialog<V extends FilterableObject, K extends FilterKey>
extends JDialog
implements ActionListener {
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton buttonAdd;
    private JRadioButton radAll;
    private JRadioButton radAny;
    private ButtonGroup groupAllAny;
    private JScrollPane scrollConditions;
    private JPanel panelConditions;
    private JPanel panelCondButtons;
    private final String noConditionsEnteredPrompt;
    private final String invalidDateTimeMsg;
    private final String invalidNumberMsg = Utils._("Please enter a valid number!");
    private FilterKeyList<K> columns;
    public boolean okClicked = false;
    public Filter<V, K> returnValue = null;

    private void initialize(String string, String string2, FilterKeyList<K> filterKeyList, Filter<V, K> filter) {
        double[][] dArrayArray = new double[][]{{12.0, -1.0, 12.0, -2.0, 12.0}, {12.0, -2.0, 6.0, -2.0, 6.0, -2.0, 12.0, -1.0, 12.0}};
        this.columns = filterKeyList;
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray));
        this.buttonOK = new JButton(Utils._("OK"));
        this.buttonOK.setActionCommand("ok");
        this.buttonOK.addActionListener(this);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomFilterDialog.this.returnValue = null;
                CustomFilterDialog.this.okClicked = false;
                CustomFilterDialog.this.dispose();
            }
        };
        abstractAction.putValue("Name", Utils._("Cancel"));
        this.buttonCancel = new JButton(abstractAction);
        this.buttonCancel.getActionMap().put("EscapePressed", abstractAction);
        this.buttonCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "EscapePressed");
        Dimension dimension = new Dimension(this.buttonOK.getPreferredSize());
        dimension.width = Integer.MAX_VALUE;
        this.buttonOK.setMaximumSize(dimension);
        this.buttonCancel.setMaximumSize(dimension);
        Box box = Box.createVerticalBox();
        box.add(this.buttonOK);
        box.add(Box.createVerticalStrut(12));
        box.add(this.buttonCancel);
        box.add(Box.createVerticalGlue());
        this.buttonAdd = new JButton(Utils._("Add"));
        this.buttonAdd.setActionCommand("add");
        this.buttonAdd.addActionListener(this);
        this.panelCondButtons = new JPanel(null, false);
        this.panelCondButtons.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.panelCondButtons.setLayout(new BoxLayout(this.panelCondButtons, 2));
        this.panelCondButtons.add(this.buttonAdd);
        this.panelCondButtons.add(Box.createHorizontalGlue());
        this.panelCondButtons.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.panelCondButtons.getPreferredSize().height));
        JLabel jLabel = new JLabel(string2);
        this.radAny = new JRadioButton(Utils._("Any of the following conditions"));
        this.radAny.setSelected(true);
        this.radAll = new JRadioButton(Utils._("All of the following conditions"));
        this.groupAllAny = new ButtonGroup();
        this.groupAllAny.add(this.radAny);
        this.groupAllAny.add(this.radAll);
        this.panelConditions = new JPanel(null);
        this.panelConditions.setLayout(new BoxLayout(this.panelConditions, 3));
        this.scrollConditions = new JScrollPane(this.panelConditions, 22, 30);
        if (filter != null && filter instanceof CombinationFilter) {
            for (Filter filter2 : ((CombinationFilter)filter).getChildList()) {
                FilterPanel filterPanel = this.newFilterPanel();
                filterPanel.initFromFilter(filter2);
                this.panelConditions.add(filterPanel);
            }
            if (filter instanceof OrFilter) {
                this.radAny.setSelected(true);
            } else {
                this.radAll.setSelected(true);
            }
        }
        if (this.panelConditions.getComponentCount() < 3) {
            for (int i = this.panelConditions.getComponentCount(); i < 3; ++i) {
                this.panelConditions.add(this.newFilterPanel());
            }
        }
        this.panelConditions.add(this.panelCondButtons);
        this.panelConditions.add(Box.createVerticalGlue());
        jPanel.add((Component)jLabel, "1, 1");
        jPanel.add((Component)this.radAll, "1, 3");
        jPanel.add((Component)this.radAny, "1, 5");
        jPanel.add((Component)this.scrollConditions, "1, 7");
        jPanel.add((Component)new JSeparator(1), "2, 0, 2, 8, c, f");
        jPanel.add((Component)box, "3, 1, 3, 7");
        this.setTitle(string);
        this.setDefaultCloseOperation(2);
        this.setContentPane(jPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CustomFilterDialog.this.returnValue = null;
                CustomFilterDialog.this.okClicked = false;
            }

            public void windowClosed(WindowEvent windowEvent) {
                Utils.getFaxOptions().customFilterBounds = CustomFilterDialog.this.getBounds();
            }
        });
        if (Utils.getFaxOptions().customFilterBounds != null) {
            this.setBounds(Utils.getFaxOptions().customFilterBounds);
        } else {
            this.pack();
            Utils.setDefWinPos(this);
        }
    }

    private FilterPanel<V, K> newFilterPanel() {
        FilterPanel filterPanel = new FilterPanel(this.columns);
        filterPanel.setDeleteActionCommand("fp_delete");
        filterPanel.addDeleteActionListener(this);
        return filterPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            AndFilter andFilter = this.radAll.isSelected() ? new AndFilter() : new OrFilter();
            for (Component component : this.panelConditions.getComponents()) {
                if (!(component instanceof FilterPanel)) continue;
                try {
                    Filter filter = ((FilterPanel)component).getFilter();
                    if (filter == null) continue;
                    andFilter.addChild(filter);
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(this, this.invalidDateTimeMsg, Utils._("Error"), 0);
                    ((FilterPanel)component).focusInput();
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, this.invalidNumberMsg, Utils._("Error"), 0);
                    ((FilterPanel)component).focusInput();
                    return;
                }
            }
            if (andFilter.childCount() == 0) {
                if (JOptionPane.showConfirmDialog(this, this.noConditionsEnteredPrompt, Utils._("Question"), 0) == 0) {
                    andFilter = null;
                } else {
                    return;
                }
            }
            this.returnValue = andFilter;
            this.okClicked = true;
            this.dispose();
        } else if (string.equals("add")) {
            this.panelConditions.add((Component)this.newFilterPanel(), this.panelConditions.getComponentCount() - 2);
            this.panelConditions.revalidate();
            this.panelCondButtons.scrollRectToVisible(this.panelCondButtons.getBounds());
        } else if (string.equals("fp_delete")) {
            this.panelConditions.remove(((JComponent)actionEvent.getSource()).getParent());
            this.panelConditions.revalidate();
        }
    }

    public CustomFilterDialog(Frame frame, String string, String string2, String string3, String string4, FilterKeyList<K> filterKeyList, Filter<V, K> filter) throws HeadlessException {
        super(frame, true);
        this.invalidDateTimeMsg = string4;
        this.noConditionsEnteredPrompt = string3;
        this.initialize(string, string2, filterKeyList, filter);
    }

    public CustomFilterDialog(Dialog dialog, String string, String string2, String string3, String string4, FilterKeyList<K> filterKeyList, Filter<V, K> filter) throws HeadlessException {
        super(dialog, true);
        this.invalidDateTimeMsg = string4;
        this.noConditionsEnteredPrompt = string3;
        this.initialize(string, string2, filterKeyList, filter);
    }
}

