/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.filters.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import yajhfc.Utils;
import yajhfc.filters.Filter;
import yajhfc.filters.FilterCreator;
import yajhfc.filters.FilterKey;
import yajhfc.filters.FilterableObject;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExceptionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SearchWin<T extends FilterableObject, S extends FilterKey>
extends JDialog
implements ActionListener {
    protected JPanel myContentPane;
    protected JButton buttonSearch;
    protected JButton buttonClose;
    protected JComboBox comboFields;
    protected JComboBox comboOp;
    protected JTextField textCondition;
    protected JRadioButton radioForward;
    protected JRadioButton radioBackward;
    protected JCheckBox checkCaseSensitive;
    protected JCheckBox checkWrapAround;
    protected ButtonGroup groupDirection;
    protected Class<?> oldDataClass;
    private static final int border = 10;

    protected abstract void performSearch(Filter<T, S> var1, boolean var2, boolean var3);

    protected abstract S[] getAvailableFields();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Class<?> clazz;
        String string = actionEvent.getActionCommand();
        if (string.equals("search")) {
            try {
                Filter filter = FilterCreator.getFilter((FilterKey)this.comboFields.getSelectedItem(), this.comboOp.getSelectedItem(), this.textCondition.getText(), this.checkCaseSensitive.isSelected());
                this.performSearch(filter, this.radioBackward.isSelected(), this.checkWrapAround.isSelected());
            }
            catch (ParseException parseException) {
                ExceptionDialog.showExceptionDialog(this, Utils._("Please enter a valid compare value."), parseException);
            }
        } else if (string.equals("fieldsel") && this.oldDataClass != (clazz = ((FilterKey)this.comboFields.getSelectedItem()).getDataType())) {
            this.oldDataClass = clazz;
            Object[] objectArray = FilterCreator.getOperators(clazz);
            if (objectArray == null) {
                this.comboOp.setEnabled(false);
                this.textCondition.setEnabled(false);
            } else {
                this.comboOp.setEnabled(true);
                this.comboOp.setModel(new DefaultComboBoxModel<Object>(objectArray));
                this.textCondition.setEnabled(FilterCreator.isInputEnabled(clazz));
                this.checkCaseSensitive.setEnabled(FilterCreator.isCaseSensitiveEnabled(clazz));
            }
        }
    }

    protected void refreshFieldList() {
        Object object = this.comboFields.getSelectedItem();
        Object[] objectArray = this.getAvailableFields();
        this.comboFields.setModel(new DefaultComboBoxModel<FilterKey>(objectArray));
        if (Utils.indexOfArray(objectArray, object) >= 0) {
            this.comboFields.setSelectedItem(object);
        } else if (objectArray.length > 0) {
            this.comboFields.setSelectedIndex(0);
        }
    }

    private JPanel getMyContentPane() {
        if (this.myContentPane == null) {
            double[][] dArrayArray = new double[][]{{10.0, -2.0, 10.0, -2.0, 10.0, -1.0, 10.0}, {10.0, -1.0, -2.0, 10.0, -2.0, 10.0, -1.0, 10.0, -2.0, 10.0}};
            this.myContentPane = new JPanel(new TableLayout(dArrayArray));
            this.comboFields = new JComboBox<FilterKey>(this.getAvailableFields());
            this.comboFields.setActionCommand("fieldsel");
            this.comboFields.addActionListener(this);
            this.comboOp = new JComboBox();
            this.textCondition = new JTextField(30);
            this.textCondition.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
            this.buttonSearch = new JButton(Utils._("Search"), Utils.loadIcon("general/Find"));
            this.buttonSearch.setActionCommand("search");
            this.buttonSearch.addActionListener(this);
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchWin.this.setVisible(false);
                }
            };
            abstractAction.putValue("Name", Utils._("Close"));
            this.buttonClose = new JButton(abstractAction);
            this.buttonClose.getActionMap().put("EscapePressed", abstractAction);
            this.buttonClose.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "EscapePressed");
            this.radioForward = new JRadioButton(Utils._("Forward"));
            this.radioForward.setSelected(true);
            this.radioBackward = new JRadioButton(Utils._("Backward"));
            this.groupDirection = new ButtonGroup();
            this.groupDirection.add(this.radioForward);
            this.groupDirection.add(this.radioBackward);
            this.checkCaseSensitive = new JCheckBox(Utils._("Case sensitive"));
            this.checkWrapAround = new JCheckBox(Utils._("Wrap Search"));
            JPanel jPanel = new JPanel(new GridLayout(2, 1));
            jPanel.setBorder(BorderFactory.createTitledBorder(Utils._("Direction:")));
            jPanel.add(this.radioForward);
            jPanel.add(this.radioBackward);
            JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
            jPanel2.setBorder(BorderFactory.createTitledBorder(Utils._("Search options:")));
            jPanel2.add(this.checkCaseSensitive);
            jPanel2.add(this.checkWrapAround);
            JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
            jPanel3.add(jPanel);
            jPanel3.add(jPanel2);
            Box box = new Box(0);
            box.add(this.buttonSearch);
            box.add(Box.createHorizontalStrut(10));
            box.add(this.buttonClose);
            box.add(Box.createHorizontalGlue());
            this.myContentPane.add((Component)this.comboFields, "1, 2");
            this.myContentPane.add((Component)this.comboOp, "3, 2");
            this.myContentPane.add((Component)this.textCondition, "5, 2");
            this.myContentPane.add((Component)jPanel3, "1, 4, 5, 4");
            this.myContentPane.add((Component)new JSeparator(0), "0, 6, 6, 6, f, c");
            this.myContentPane.add((Component)box, "1, 8, 5, 8");
        }
        return this.myContentPane;
    }

    private void initialize() {
        this.setContentPane(this.getMyContentPane());
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(this.getOwner());
        this.pack();
        if (this.comboFields.getModel().getSize() > 0) {
            this.comboFields.setSelectedIndex(0);
        }
    }

    public SearchWin(Dialog dialog, String string) {
        super(dialog, string, false);
        this.initialize();
    }

    public SearchWin(Frame frame, String string) {
        super(frame, string, false);
        this.initialize();
    }
}

