/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.launch;

import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public class HelpPrinter {
    public static final int MIN_OPT_VAL = 48;
    protected final ResourceBundle resources;
    private static final Pattern wordSplitter = Pattern.compile("(\\s|\n)+");

    public HelpPrinter() {
        this("yajhfc.i18n.CommandLineOpts");
    }

    public HelpPrinter(String string) {
        this.resources = ResourceBundle.getBundle(string);
    }

    public String getResource(String string) {
        try {
            return this.resources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public String getDescription(LongOpt longOpt) {
        return this.getResource(longOpt.getName() + "-desc");
    }

    public String getArgDesc(LongOpt longOpt) {
        return this.getResource(longOpt.getName() + "-arg");
    }

    public LongOpt[] filterOptions(LongOpt[] longOptArray) {
        int n;
        for (n = longOptArray.length - 1; n >= 0 && longOptArray[n].getName() != null && longOptArray[n].getName().startsWith("X"); --n) {
        }
        if (n + 1 == longOptArray.length) {
            return longOptArray;
        }
        LongOpt[] longOptArray2 = new LongOpt[n + 1];
        System.arraycopy(longOptArray, 0, longOptArray2, 0, n + 1);
        return longOptArray2;
    }

    public void printHelp(PrintWriter printWriter, LongOpt[] longOptArray, String string) {
        this.printHelp(printWriter, longOptArray, string, "java -jar yajhfc.jar");
    }

    public void printHelp(PrintWriter printWriter, LongOpt[] longOptArray, String string, String string2) {
        int n;
        LongOpt longOpt;
        int n2;
        int n3 = 80;
        if (string != null) {
            try {
                n3 = Integer.parseInt(string);
                if (n3 < 40) {
                    n3 = 40;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Invalid number of columns: " + string);
            }
        }
        longOptArray = this.filterOptions(longOptArray);
        String[] stringArray = new String[longOptArray.length];
        int n4 = 0;
        for (n2 = 0; n2 < longOptArray.length; ++n2) {
            longOpt = longOptArray[n2];
            n = 0;
            switch (longOpt.getHasArg()) {
                case 2: {
                    n += 2;
                }
                case 1: {
                    stringArray[n2] = this.getArgDesc(longOpt);
                    n += stringArray[n2].length() + 1;
                }
                case 0: {
                    n += longOpt.getName().length();
                }
            }
            if (n <= n4) continue;
            n4 = n;
        }
        ++n4;
        printWriter.append(this.getResource("usage")).println(':');
        printWriter.append(string2).append(" [").append(this.getResource("options")).append("]... [").append(this.getResource("files-to-send")).println("]...");
        printWriter.println();
        printWriter.append(this.getResource("argument-description")).println(':');
        for (n2 = 0; n2 < longOptArray.length; ++n2) {
            longOpt = longOptArray[n2];
            if (longOpt.getVal() < 48) {
                printWriter.append("  ");
            } else {
                printWriter.append('-');
                printWriter.append((char)longOpt.getVal());
            }
            if (longOpt.getName() == null) {
                HelpPrinter.appendSpaces(printWriter, n4 + 4);
            } else {
                if (longOpt.getVal() < 48) {
                    printWriter.append("  --");
                } else {
                    printWriter.append(", --");
                }
                printWriter.append(longOpt.getName());
                n = longOpt.getHasArg();
                if (n != 0) {
                    if (n == 2) {
                        printWriter.append('[');
                    }
                    printWriter.append('=').append(stringArray[n2]);
                    if (n == 2) {
                        printWriter.append(']');
                    }
                    HelpPrinter.appendSpaces(printWriter, n4 - longOpt.getName().length() - stringArray[n2].length() - (n == 2 ? 3 : 1));
                } else {
                    HelpPrinter.appendSpaces(printWriter, n4 - longOpt.getName().length());
                }
            }
            HelpPrinter.printWrapped(printWriter, n4 + 6, this.getDescription(longOpt), n3);
            printWriter.println();
        }
        printWriter.flush();
    }

    protected static void appendSpaces(PrintWriter printWriter, int n) {
        for (int i = 0; i < n; ++i) {
            printWriter.append(' ');
        }
    }

    public static void printWrapped(PrintWriter printWriter, int n, String string, int n2) {
        int n3 = n;
        for (String string2 : wordSplitter.split(string)) {
            if ((n3 += string2.length()) >= n2) {
                printWriter.println();
                HelpPrinter.appendSpaces(printWriter, n);
                n3 = n + string2.length();
            }
            printWriter.append(string2);
            if (n3 >= n2 - 1) continue;
            printWriter.append(' ');
            ++n3;
        }
    }
}

