/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.launch;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.file.textextract.RecipientExtractionMode;
import yajhfc.launch.LockThread;
import yajhfc.launch.ResponseException;
import yajhfc.launch.SubmitProtocol;
import yajhfc.shutdown.ShutdownManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lock
implements SubmitProtocol {
    private static final Logger log = Logger.getLogger(Lock.class.getName());
    static final int CODE_SUBMIT_STREAM = 1;
    static final int CODE_SUBMIT = 3;
    static final int CODE_ADD_FILES = 5;
    static final int CODE_BRING_TO_FRONT = 6;
    static final int CODE_ADD_RECIPIENTS = 7;
    static final int CODE_USE_COVER = 8;
    static final int CODE_SET_SUBJECT = 9;
    static final int CODE_SET_COMMENT = 10;
    static final int CODE_SET_MODEM = 11;
    static final int CODE_SET_SERVER = 12;
    static final int CODE_SET_IDENTITY = 13;
    static final int CODE_EXTRACT_RECIPIENTS = 14;
    public static final int RESPONSE_OK = 0;
    public static final int RESPONSE_NOT_CONNECTED = 10;
    public static final int RESPONSE_GENERAL_ERROR = 1;
    public static final int RESPONSE_GOT_EXCEPTION = 2;
    public static final int RESPONSE_UNKNOWN_OPCODE = 255;
    protected final Socket sock;
    protected DataOutputStream outStream;
    protected DataInputStream inStream;
    protected InputStream inStreamToSubmit = null;
    public static LockThread lockThread;

    protected Lock(Socket socket) throws IOException {
        this.sock = socket;
        this.outStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.inStream = new DataInputStream(socket.getInputStream());
    }

    private void checkResponse() throws IOException {
        int n = this.inStream.read();
        String string = null;
        if (n >= 0) {
            string = this.inStream.readUTF();
        }
        if (Utils.debugMode) {
            log.info("Got response : " + n + "; msg: " + string);
        }
        if (n != 0) {
            if (n > 0) {
                throw new ResponseException("Error " + n + " received from old instance: " + string, n);
            }
            throw new ResponseException("Could not read response from old instance", -1);
        }
    }

    @Override
    public void addFiles(Collection<String> collection) throws IOException {
        if (Utils.debugMode) {
            log.finer("addFiles: " + collection);
        }
        this.outStream.write(5);
        this.outStream.writeInt(collection.size());
        for (String string : collection) {
            this.outStream.writeUTF(new File(string).getAbsolutePath());
        }
        this.outStream.flush();
        this.checkResponse();
    }

    @Override
    public void addRecipients(Collection<String> collection) throws IOException {
        if (Utils.debugMode) {
            log.finer("addRecipients: " + collection);
        }
        this.outStream.write(7);
        this.outStream.writeInt(collection.size());
        for (String string : collection) {
            this.outStream.writeUTF(string);
        }
        this.outStream.flush();
        this.checkResponse();
    }

    @Override
    public void setCloseAfterSubmit(boolean bl) {
        throw new UnsupportedOperationException("CloseAfterSubmit not supported.");
    }

    @Override
    public void setComments(String string) throws IOException {
        if (Utils.debugMode) {
            log.finer("setComments: " + string);
        }
        this.outStream.write(10);
        this.outStream.writeUTF(string);
        this.outStream.flush();
        this.checkResponse();
    }

    @Override
    public void setCover(boolean bl) throws IOException {
        if (Utils.debugMode) {
            log.finer("setCover: " + bl);
        }
        this.outStream.write(8);
        this.outStream.writeBoolean(bl);
        this.outStream.flush();
        this.checkResponse();
    }

    @Override
    public void setExtractRecipients(RecipientExtractionMode recipientExtractionMode) throws IOException {
        if (Utils.debugMode) {
            log.finer("setExtractRecipients: " + (Object)((Object)recipientExtractionMode));
        }
        this.outStream.write(14);
        this.outStream.writeInt(recipientExtractionMode.ordinal());
        this.outStream.flush();
        this.checkResponse();
    }

    @Override
    public void setInputStream(InputStream inputStream, String string) {
        if (Utils.debugMode) {
            log.finer("setInputStream: " + inputStream);
        }
        this.inStreamToSubmit = inputStream;
    }

    @Override
    public void setSubject(String string) throws IOException {
        if (Utils.debugMode) {
            log.finer("setSubject: " + string);
        }
        this.outStream.write(9);
        this.outStream.writeUTF(string);
        this.outStream.flush();
        this.checkResponse();
    }

    @Override
    public void setModem(String string) throws IOException {
        if (Utils.debugMode) {
            log.finer("setModem: " + string);
        }
        this.outStream.write(11);
        this.outStream.writeUTF(string);
        this.outStream.flush();
        this.checkResponse();
    }

    @Override
    public void setServer(String string) throws IOException {
        if (Utils.debugMode) {
            log.finer("setServer: " + string);
        }
        this.outStream.write(12);
        this.outStream.writeUTF(string);
        this.outStream.flush();
        this.checkResponse();
    }

    @Override
    public void setIdentity(String string) throws IOException {
        if (Utils.debugMode) {
            log.finer("setIdentity: " + string);
        }
        this.outStream.write(13);
        this.outStream.writeUTF(string);
        this.outStream.flush();
        this.checkResponse();
    }

    public void bringToFront() throws IOException {
        if (Utils.debugMode) {
            log.finer("bringToFront");
        }
        this.outStream.write(6);
        this.outStream.flush();
        this.checkResponse();
    }

    @Override
    public long[] submit(boolean bl) throws IOException {
        if (this.inStreamToSubmit == null) {
            if (Utils.debugMode) {
                log.finer("submit: no stream, wait=" + bl);
            }
            this.outStream.write(3);
            this.outStream.writeBoolean(bl);
            this.outStream.flush();
        } else {
            if (Utils.debugMode) {
                log.finer("submit: have stream, wait=" + bl);
            }
            this.outStream.write(1);
            this.outStream.writeBoolean(bl);
            Utils.copyStream(this.inStreamToSubmit, this.outStream);
            this.outStream.flush();
            this.sock.shutdownOutput();
        }
        this.checkResponse();
        int n = this.inStream.readInt();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.inStream.readLong();
        }
        return lArray;
    }

    public void close() {
        if (!this.sock.isClosed()) {
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Error closing outStream:", iOException);
            }
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Error closing inStream:", iOException);
            }
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Error closing sock:", iOException);
            }
        }
    }

    private static InetAddress getLocalhost() throws UnknownHostException {
        byte[] byArray = new byte[]{127, 0, 0, 1};
        return InetAddress.getByAddress(byArray);
    }

    private static File getLockFile() {
        return new File(Utils.getConfigDir(), "lock");
    }

    public static Lock checkLock() {
        File file = Lock.getLockFile();
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                bufferedReader.close();
                int n = Integer.parseInt(string);
                Socket socket = new Socket(Lock.getLocalhost(), n);
                return new Lock(socket);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void createLock() {
        ServerSocket serverSocket = null;
        File file = Lock.getLockFile();
        try {
            int n;
            for (n = 64007; n <= 65269; ++n) {
                try {
                    serverSocket = new ServerSocket(n, 50, Lock.getLocalhost());
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (serverSocket != null) {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
                outputStreamWriter.write("" + n + "\n");
                ((Writer)outputStreamWriter).close();
                ShutdownManager.deleteOnExit(file);
                lockThread = new LockThread(serverSocket);
            }
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, "Could not create lock: ", iOException);
        }
    }

    public static void startLockThread() {
        if (lockThread != null) {
            lockThread.start();
        }
    }

    public static void releaseLock() {
        if (lockThread == null) {
            return;
        }
        try {
            lockThread.releaseLock();
            if (Lock.lockThread.socket != null) {
                Lock.lockThread.socket.close();
            }
            lockThread = null;
            Lock.getLockFile().delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

