/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.launch;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import yajhfc.NoGUISender;
import yajhfc.launch.FaxSenderSubmitProtocol;
import yajhfc.launch.Launcher2;
import yajhfc.launch.SubmitProtocol;
import yajhfc.send.SendController;
import yajhfc.send.SendControllerListener;
import yajhfc.server.ServerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendControllerSubmitProtocol
extends FaxSenderSubmitProtocol
implements SubmitProtocol,
Runnable,
SendControllerListener {
    protected List<Long> submittedIDs = null;
    private int exitCode = -1;

    @Override
    public long[] submit(boolean bl) throws IOException {
        this.prepareSubmit();
        if (bl) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(this);
                    this.waitReady();
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, "Error submitting the fax:", exception);
                }
            }
        } else {
            SwingUtilities.invokeLater(this);
        }
        if (this.submittedIDs == null) {
            return null;
        }
        return SendControllerSubmitProtocol.listToArray(this.submittedIDs);
    }

    private static long[] listToArray(List<Long> list) {
        long[] lArray = new long[list.size()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = list.get(i);
        }
        return lArray;
    }

    protected void dispatchToSendController() {
        try {
            Launcher2.application.bringToFront();
            SendController sendController = new SendController(ServerManager.getDefault().getCurrent(), Launcher2.application.getFrame(), false);
            if (Launcher2.application instanceof NoGUISender) {
                sendController.setProgressMonitor(((NoGUISender)Launcher2.application).getProgressPanel());
            }
            this.submitTo(sendController);
            sendController.addSendControllerListener(this);
            if (sendController.validateEntries()) {
                sendController.sendFax();
            } else {
                this.setReady(false);
            }
        }
        catch (RuntimeException runtimeException) {
            this.setReady(false);
            throw runtimeException;
        }
    }

    @Override
    public void run() {
        this.dispatchToSendController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setReady(boolean bl) {
        SendControllerSubmitProtocol sendControllerSubmitProtocol = this;
        synchronized (sendControllerSubmitProtocol) {
            this.exitCode = bl ? 1 : 0;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitReady() {
        try {
            SendControllerSubmitProtocol sendControllerSubmitProtocol = this;
            synchronized (sendControllerSubmitProtocol) {
                while (this.exitCode == -1) {
                    this.wait();
                }
                return this.exitCode == 1;
            }
        }
        catch (InterruptedException interruptedException) {
            log.log(Level.WARNING, "Error submitting the fax:", interruptedException);
            return false;
        }
    }

    @Override
    public void sendOperationComplete(boolean bl) {
        this.setReady(bl);
    }
}

