/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.logconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import yajhfc.Utils;
import yajhfc.file.FileFormat;
import yajhfc.launch.Launcher2;
import yajhfc.logconsole.SwingLogHandler;
import yajhfc.util.CancelAction;
import yajhfc.util.ExampleFileFilter;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.SafeJFileChooser;

public class LogConsole
extends JFrame
implements SwingLogHandler.LogListener {
    static final Logger log = Logger.getLogger(LogConsole.class.getName());
    JTextArea textLog;
    Action actCopy;
    Action actSave;
    JComboBox comboLevel;
    SimpleFormatter formatter = new SimpleFormatter();
    private static final int border = 8;

    public LogConsole() throws HeadlessException {
        super(Utils._("YajHFC log console"));
        this.initialize();
    }

    private void initialize() {
        this.actCopy = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                StringSelection stringSelection = new StringSelection(LogConsole.this.textLog.getText());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
        };
        this.actCopy.putValue("Name", Utils._("Copy"));
        this.actCopy.putValue("SmallIcon", Utils.loadIcon("general/Copy"));
        this.actSave = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                SafeJFileChooser safeJFileChooser = new SafeJFileChooser();
                if (Utils.getFaxOptions().lastSavePath.length() > 0) {
                    safeJFileChooser.setCurrentDirectory(new File(Utils.getFaxOptions().lastSavePath));
                }
                safeJFileChooser.resetChoosableFileFilters();
                ExampleFileFilter exampleFileFilter = new ExampleFileFilter(FileFormat.PlainText.getPossibleExtensions(), FileFormat.PlainText.getDescription());
                ExampleFileFilter exampleFileFilter2 = new ExampleFileFilter("log", Utils._("Log files"));
                safeJFileChooser.addChoosableFileFilter(exampleFileFilter);
                safeJFileChooser.addChoosableFileFilter(exampleFileFilter2);
                safeJFileChooser.setFileFilter(exampleFileFilter);
                if (safeJFileChooser.showSaveDialog(LogConsole.this) == 0) {
                    Utils.getFaxOptions().lastSavePath = safeJFileChooser.getCurrentDirectory().getAbsolutePath();
                    File file = Utils.getSelectedFileFromSaveChooser(safeJFileChooser);
                    try {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
                        outputStreamWriter.write(LogConsole.this.textLog.getText());
                        outputStreamWriter.close();
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog(LogConsole.this, Utils._("Error saving the log file"), exception);
                    }
                }
            }
        };
        this.actSave.putValue("Name", Utils._("Save") + "...");
        this.actSave.putValue("SmallIcon", Utils.loadIcon("general/Save"));
        CancelAction cancelAction = new CancelAction(this, Utils._("Close"));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.textLog = new JTextArea();
        this.textLog.setEditable(false);
        this.textLog.setFont(new Font("Monospaced", 0, 12));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 3, 8, 8));
        Level[] levelArray = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
        this.comboLevel = new JComboBox<Level>(levelArray);
        this.comboLevel.setSelectedItem(Launcher2.swingLogHandler.getLevel());
        this.comboLevel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Launcher2.swingLogHandler.setLevel((Level)LogConsole.this.comboLevel.getSelectedItem());
            }
        });
        jPanel2.add(Box.createRigidArea(new Dimension(8, 8)));
        JLabel jLabel = new JLabel("Log level:");
        jLabel.setAlignmentX(1.0f);
        jLabel.setHorizontalAlignment(4);
        jPanel2.add(jLabel);
        jPanel2.add(this.comboLevel);
        jPanel2.add(new JButton(this.actCopy));
        jPanel2.add(new JButton(this.actSave));
        jPanel2.add(cancelAction.createCancelButton());
        jPanel.add((Component)new JScrollPane(this.textLog, 22, 30), "Center");
        jPanel.add((Component)jPanel2, "South");
        this.setContentPane(jPanel);
        this.setSize(800, 600);
        Utils.setDefWinPos(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Launcher2.swingLogHandler.removeLogListener(LogConsole.this);
                LogConsole.this.dispose();
            }
        });
        this.setDefaultCloseOperation(0);
        Launcher2.swingLogHandler.addLogListenerAndPublishBuffer(this);
    }

    public void recordPublished(LogRecord logRecord) {
        this.textLog.append(this.formatter.format(logRecord));
        this.textLog.append("\n");
    }
}

