/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import yajhfc.Utils;
import yajhfc.model.IconMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JobState implements IconMap
{
    UNDEFINED('?', -1, Utils._("Undefined")),
    FAILED('F', 8, Utils._("Failed")),
    SUSPENDED('T', 1, Utils._("Suspended"), Utils._("Suspended (not being scheduled)")),
    PENDING('P', 2, Utils._("Pending"), Utils._("Pending (waiting for the time to send to arrive)")),
    SLEEPING('S', 3, Utils._("Sleeping"), Utils._("Sleeping (waiting for a scheduled timeout such as a delay between attempts to send)")),
    BLOCKED('B', 4, Utils._("Blocked"), Utils._("Blocked (by concurrent activity to the same destination)")),
    WAITING('W', 5, Utils._("Waiting"), Utils._("Waiting (for resources such as a free modem)")),
    RUNNING('R', 6, Utils._("Running")),
    DONE('D', 7, Utils._("Done"));

    private final char singleCharCode;
    private final int queueCode;
    private final String label;
    private final String description;
    private transient ImageIcon displayIcon = null;
    public static final int QUEUESTATE_SUSPENDED = 1;
    public static final int QUEUESTATE_PENDING = 2;
    public static final int QUEUESTATE_SLEEPING = 3;
    public static final int QUEUESTATE_BLOCKED = 4;
    public static final int QUEUESTATE_READY = 5;
    public static final int QUEUESTATE_ACTIVE = 6;
    public static final int QUEUESTATE_DONE = 7;
    public static final int QUEUESTATE_FAILED = 8;
    public static final int QUEUESTATE_UNKNOWN = -1;
    public static final char JOBSTATE_UNDEFINED = '?';
    public static final char JOBSTATE_FAILED = 'F';
    public static final char JOBSTATE_SUSPENDED = 'T';
    public static final char JOBSTATE_PENDING = 'P';
    public static final char JOBSTATE_SLEEPING = 'S';
    public static final char JOBSTATE_BLOCKED = 'B';
    public static final char JOBSTATE_WAITING = 'W';
    public static final char JOBSTATE_RUNNING = 'R';
    public static final char JOBSTATE_DONE = 'D';

    private JobState(char c, int n2, String string2) {
        this(c, n2, string2, string2);
    }

    private JobState(char c, int n2, String string2, String string3) {
        this.singleCharCode = c;
        this.queueCode = n2;
        this.label = string2;
        this.description = string3;
    }

    public char getSingleCharCode() {
        return this.singleCharCode;
    }

    public int getQueueCode() {
        return this.queueCode;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ImageIcon getDisplayIcon() {
        if (this.displayIcon == null) {
            String string = this.singleCharCode == '?' ? "jobstate_questionmark.gif" : "jobstate_" + this.singleCharCode + ".gif";
            this.displayIcon = Utils.loadCustomIcon(string);
        }
        return this.displayIcon;
    }

    @Override
    public String getText() {
        return this.label;
    }

    public String toString() {
        return this.label;
    }

    public static JobState getJobStateFromQueueCode(int n) {
        switch (n) {
            case 6: {
                return RUNNING;
            }
            case 4: {
                return BLOCKED;
            }
            case 7: {
                return DONE;
            }
            case 8: {
                return FAILED;
            }
            case 2: {
                return PENDING;
            }
            case 5: {
                return WAITING;
            }
            case 3: {
                return SLEEPING;
            }
            case 1: {
                return SUSPENDED;
            }
        }
        return UNDEFINED;
    }

    public static JobState getJobStateFromCharCode(char c) {
        switch (c) {
            case 'B': {
                return BLOCKED;
            }
            case 'D': {
                return DONE;
            }
            case 'F': {
                return FAILED;
            }
            case 'P': {
                return PENDING;
            }
            case 'R': {
                return RUNNING;
            }
            case 'S': {
                return SLEEPING;
            }
            case 'T': {
                return SUSPENDED;
            }
            default: {
                return UNDEFINED;
            }
            case 'W': 
        }
        return WAITING;
    }

    public static JobState getJobStateFromJPARMValue(String string) {
        try {
            if ("ACTIVE".equals(string)) {
                return RUNNING;
            }
            return Enum.valueOf(JobState.class, string);
        }
        catch (Exception exception) {
            Logger.getLogger(JobState.class.getName()).log(Level.INFO, "Unknown job state, returning UNDEFINED: " + string);
            return UNDEFINED;
        }
    }
}

