/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.directaccess.fritz;

import gnu.inet.ftp.ServerResponseException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import yajhfc.Utils;
import yajhfc.file.FileFormat;
import yajhfc.model.RecvFormat;
import yajhfc.model.jobq.FTPHylaDirAccessor;
import yajhfc.model.jobq.HylaDirAccessor;
import yajhfc.model.servconn.JobState;
import yajhfc.model.servconn.directaccess.DirectAccessFaxDoc;
import yajhfc.model.servconn.directaccess.DirectAccessFaxJob;
import yajhfc.model.servconn.directaccess.DirectAccessFaxJobList;
import yajhfc.model.servconn.directaccess.fritz.FritzFaxList;
import yajhfc.model.servconn.directaccess.recvq.RecvQFaxJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FritzFaxJob
extends DirectAccessFaxJob<RecvFormat> {
    private static final long serialVersionUID = 1L;
    static final Logger log = Logger.getLogger(FritzFaxJob.class.getName());

    protected FritzFaxJob(DirectAccessFaxJobList<RecvFormat> directAccessFaxJobList, String string, String string2) throws IOException {
        super(directAccessFaxJobList, string, string2);
        this.documents.clear();
        this.documents.add(new DirectAccessFaxDoc<RecvFormat>(this, string2, FileFormat.PDF));
    }

    @Override
    public void delete() throws IOException, ServerResponseException {
        this.getDirAccessor().deleteFile(this.fileName);
    }

    @Override
    protected void readSpoolFile(HylaDirAccessor hylaDirAccessor) throws IOException {
        if (Utils.debugMode) {
            log.fine("Parsing file name " + this.fileName);
        }
        String string = "<unknown>";
        Date date = null;
        Matcher matcher = ((FritzFaxList)this.parent).getFaxPattern().matcher(this.fileName);
        if (matcher.matches()) {
            string = matcher.group(2);
            try {
                date = ((FritzFaxList)this.parent).getFaxDateFormat().parse(matcher.group(1));
            }
            catch (ParseException parseException) {
                log.log(Level.WARNING, "Unparseable file date for \"" + this.fileName + "\": " + matcher.group(1), parseException);
            }
        } else {
            log.warning("File name \"" + this.fileName + "\" does not match the expected pattern!");
        }
        if (date == null) {
            date = new Date(hylaDirAccessor.getLastModified(this.fileName));
        }
        List list = this.parent.getColumns().getCompleteView();
        Object[] objectArray = new Object[list.size()];
        block23: for (int i = 0; i < list.size(); ++i) {
            switch ((RecvFormat)list.get(i)) {
                case a: {
                    objectArray[i] = "";
                    continue block23;
                }
                case b: {
                    objectArray[i] = -1;
                    continue block23;
                }
                case d: {
                    objectArray[i] = "PDF";
                    continue block23;
                }
                case e: {
                    objectArray[i] = "";
                    continue block23;
                }
                case f: {
                    objectArray[i] = this.jobID;
                    continue block23;
                }
                case h: {
                    objectArray[i] = null;
                    continue block23;
                }
                case i: {
                    objectArray[i] = "";
                    continue block23;
                }
                case j: {
                    objectArray[i] = string;
                    continue block23;
                }
                case l: {
                    objectArray[i] = -1;
                    continue block23;
                }
                case m: {
                    objectArray[i] = RecvQFaxJob.getProtection(hylaDirAccessor.getProtection(this.fileName));
                    continue block23;
                }
                case n: {
                    objectArray[i] = (int)hylaDirAccessor.getSize(this.fileName);
                    continue block23;
                }
                case o: {
                    if (hylaDirAccessor instanceof FTPHylaDirAccessor) {
                        objectArray[i] = ((FTPHylaDirAccessor)hylaDirAccessor).getOwner(this.fileName);
                        continue block23;
                    }
                    objectArray[i] = "<unknown>";
                    continue block23;
                }
                case p: {
                    objectArray[i] = -1;
                    continue block23;
                }
                case r: {
                    objectArray[i] = -1;
                    continue block23;
                }
                case s: {
                    objectArray[i] = string;
                    continue block23;
                }
                case t: {
                    objectArray[i] = DateFormat.getDateTimeInstance().format(date);
                    continue block23;
                }
                case w: {
                    objectArray[i] = -1;
                    continue block23;
                }
                case z: {
                    objectArray[i] = Boolean.FALSE;
                    continue block23;
                }
                case Y: 
                case Z: {
                    objectArray[i] = date;
                }
            }
        }
        this.data = objectArray;
        if (Utils.debugMode) {
            log.finest(this.jobID + " data after reading: " + Arrays.toString(objectArray));
        }
        this.state = JobState.DONE;
    }

    @Override
    protected JobState calculateJobState() {
        return JobState.DONE;
    }
}

