/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.directaccess.jobq;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import yajhfc.model.FmtItemList;
import yajhfc.model.TableType;
import yajhfc.model.jobq.QueueFileFormat;
import yajhfc.model.servconn.FaxListConnection;
import yajhfc.model.servconn.directaccess.DirectAccessFaxJob;
import yajhfc.model.servconn.directaccess.DirectAccessFaxJobList;
import yajhfc.model.servconn.directaccess.jobq.JobQueueFaxJob;
import yajhfc.server.ServerOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobQueueFaxJobList
extends DirectAccessFaxJobList<QueueFileFormat> {
    protected Map<String, int[]> desiredItems;
    protected static final Pattern queueFilePattern = Pattern.compile("q(\\d+)");

    public JobQueueFaxJobList(FaxListConnection faxListConnection, FmtItemList<QueueFileFormat> fmtItemList, ServerOptions serverOptions, String string) {
        super(faxListConnection, fmtItemList, serverOptions, string);
    }

    @Override
    public void reloadSettings(ServerOptions serverOptions) {
        List list = this.columns.getCompleteView();
        if (this.desiredItems == null) {
            this.desiredItems = new HashMap<String, int[]>();
        } else {
            this.desiredItems.clear();
        }
        for (int i = 0; i < list.size(); ++i) {
            int[] nArray;
            String string = ((QueueFileFormat)list.get(i)).getHylaFmt();
            if (string == null) continue;
            int[] nArray2 = this.desiredItems.get(string);
            if (nArray2 == null || nArray2.length == 0) {
                nArray = new int[]{i};
            } else {
                nArray = new int[nArray2.length + 1];
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                nArray[nArray2.length] = i;
            }
            this.desiredItems.put(string, nArray);
        }
    }

    @Override
    public TableType getJobType() {
        return TableType.SENT;
    }

    @Override
    protected DirectAccessFaxJob<QueueFileFormat> createJob(String string) throws IOException {
        String string2 = this.directory + "/q" + string;
        return new JobQueueFaxJob(this, string, string2);
    }

    @Override
    protected String[] translateDirectoryEntries(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            Matcher matcher = queueFilePattern.matcher(string);
            if (!matcher.matches()) continue;
            arrayList.add(matcher.group(1));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

