/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.hylafax;

import gnu.hylafax.HylaFAXClient;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.HylaClientManager;
import yajhfc.Utils;
import yajhfc.cache.Cache;
import yajhfc.model.JobFormat;
import yajhfc.model.RecvFormat;
import yajhfc.model.jobq.QueueFileFormat;
import yajhfc.model.servconn.ConnectionState;
import yajhfc.model.servconn.FaxJobList;
import yajhfc.model.servconn.FaxListConnection;
import yajhfc.model.servconn.FaxListConnectionListener;
import yajhfc.model.servconn.directaccess.archive.ArchiveFaxJobList;
import yajhfc.model.servconn.hylafax.ManagedFaxJobList;
import yajhfc.model.servconn.hylafax.RecvdFaxJobList;
import yajhfc.model.servconn.hylafax.SendingFaxJobList;
import yajhfc.model.servconn.hylafax.SentFaxJobList;
import yajhfc.server.ServerOptions;
import yajhfc.ui.YajOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HylaFaxListConnection
implements FaxListConnection {
    static final Logger log = Logger.getLogger(HylaFaxListConnection.class.getName());
    protected final List<FaxListConnectionListener> listeners = new ArrayList<FaxListConnectionListener>();
    protected HylaClientManager clientManager;
    protected YajOptionPane dialogUI;
    protected ConnectionState connectionState = ConnectionState.DISCONNECTED;
    protected Timer refreshTimer = new Timer("ListRefresher", true);
    protected TimerTask statusRefresher;
    protected TimerTask jobRefresher;
    protected ServerOptions fo;
    protected String statusText = "";
    protected ManagedFaxJobList<RecvFormat> receivedJobs;
    protected ManagedFaxJobList<JobFormat> sentJobs;
    protected ManagedFaxJobList<JobFormat> sendingJobs;
    protected ManagedFaxJobList<QueueFileFormat> archiveJobs;
    protected Cache listCache;

    @Override
    public synchronized void addFaxListConnectionListener(FaxListConnectionListener faxListConnectionListener) {
        this.listeners.add(faxListConnectionListener);
    }

    @Override
    public synchronized void removeFaxListConnectionListener(FaxListConnectionListener faxListConnectionListener) {
        this.listeners.remove(faxListConnectionListener);
    }

    protected synchronized void setConnectionState(ConnectionState connectionState) {
        if (connectionState != this.connectionState) {
            log.fine("Connection state change: " + (Object)((Object)this.connectionState) + "->" + (Object)((Object)connectionState));
            for (FaxListConnectionListener faxListConnectionListener : this.listeners) {
                faxListConnectionListener.connectionStateChange(this.connectionState, connectionState);
            }
            this.connectionState = connectionState;
        }
    }

    protected void saveToCache() {
        if (!Cache.useForNextLogin) {
            log.finer("Not using cache this time.");
            return;
        }
        try {
            Map<String, Object> map = this.listCache.getCachedData();
            map.clear();
            if (this.receivedJobs != null) {
                this.receivedJobs.saveJobsToCache(map, "receivedJobs");
            }
            if (this.sentJobs != null) {
                this.sentJobs.saveJobsToCache(map, "sentJobs");
            }
            if (this.sendingJobs != null) {
                this.sendingJobs.saveJobsToCache(map, "sendingJobs");
            }
            if (this.archiveJobs != null) {
                this.archiveJobs.saveJobsToCache(map, "archiveJobs");
            }
            this.listCache.writeToCache(this.fo.id);
            map.clear();
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error saving cache:", exception);
        }
    }

    protected void loadFromCache() {
        if (!Cache.useForNextLogin) {
            log.finer("Not using cache this time.");
            Cache.useForNextLogin = true;
            return;
        }
        try {
            if (this.listCache.readFromCache(this.fo.id)) {
                Map<String, Object> map = this.listCache.getCachedData();
                if (this.receivedJobs != null) {
                    this.receivedJobs.loadJobsFromCache(map, "receivedJobs");
                }
                if (this.sentJobs != null) {
                    this.sentJobs.loadJobsFromCache(map, "sentJobs");
                }
                if (this.sendingJobs != null) {
                    this.sendingJobs.loadJobsFromCache(map, "sendingJobs");
                }
                if (this.archiveJobs != null) {
                    this.archiveJobs.loadJobsFromCache(map, "archiveJobs");
                }
                this.fireRefreshComplete(FaxListConnectionListener.RefreshKind.FAXLISTS_FROM_CACHE, true);
                map.clear();
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error loading cache:", exception);
        }
    }

    @Override
    public boolean connect(boolean bl) {
        if (this.connectionState == ConnectionState.CONNECTED || this.connectionState == ConnectionState.CONNECTING) {
            throw new IllegalStateException("Already connecting.");
        }
        log.fine("Connecting; adminMode=" + bl);
        this.setConnectionState(ConnectionState.CONNECTING);
        this.setStatusText(Utils._("Connecting..."));
        if (this.fo.getParent().useFaxListCache) {
            log.fine("Loading cache...");
            this.putDefaultCacheCheckData();
            this.loadFromCache();
        }
        this.clientManager.setAdminMode(bl);
        if (this.clientManager.forceLogin(this.dialogUI) != null) {
            log.fine("ClientManager successfully logged in");
            this.statusRefresher = this.createStatusRefresher();
            this.refreshTimer.schedule(this.statusRefresher, 0L, (long)this.fo.getParent().statusUpdateInterval);
            this.jobRefresher = this.createJobListRefresher();
            this.refreshTimer.schedule(this.jobRefresher, 0L, (long)this.fo.getParent().tableUpdateInterval);
            log.fine("Refreshers scheduled");
            this.setConnectionState(ConnectionState.CONNECTED);
            return true;
        }
        log.fine("ClientManager failed to log in");
        this.setConnectionState(ConnectionState.DISCONNECTED);
        return false;
    }

    protected TimerTask createJobListRefresher() {
        return new JobListRefresher();
    }

    protected TimerTask createStatusRefresher() {
        return new StatusRefresher();
    }

    @Override
    public void disconnect() {
        log.fine("Disconnecting...");
        ConnectionState connectionState = this.connectionState;
        this.setConnectionState(ConnectionState.DISCONNECTING);
        if (this.statusRefresher != null) {
            this.statusRefresher.cancel();
            this.statusRefresher = null;
            this.setStatusText(Utils._("Disconnected."));
        }
        if (this.jobRefresher != null) {
            this.jobRefresher.cancel();
            this.jobRefresher = null;
        }
        log.fine("Cancelled refresh tasks");
        if (connectionState == ConnectionState.CONNECTED && this.fo.getParent().useFaxListCache) {
            log.fine("Saving cache");
            this.saveToCache();
        }
        this.clientManager.forceLogout();
        log.fine("forceLogout completed");
        if (this.receivedJobs != null) {
            this.receivedJobs.disconnectCleanup();
        }
        if (this.sentJobs != null) {
            this.sentJobs.disconnectCleanup();
        }
        if (this.sendingJobs != null) {
            this.sendingJobs.disconnectCleanup();
        }
        if (this.archiveJobs != null) {
            this.archiveJobs.disconnectCleanup();
        }
        log.fine("disconnectCleanups completed");
        this.setConnectionState(ConnectionState.DISCONNECTED);
    }

    @Override
    public FaxJobList<QueueFileFormat> getArchivedJobs() {
        return this.archiveJobs;
    }

    @Override
    public HylaClientManager getClientManager() {
        return this.clientManager;
    }

    @Override
    public FaxJobList<RecvFormat> getReceivedJobs() {
        return this.receivedJobs;
    }

    @Override
    public FaxJobList<JobFormat> getSendingJobs() {
        return this.sendingJobs;
    }

    @Override
    public FaxJobList<JobFormat> getSentJobs() {
        return this.sentJobs;
    }

    @Override
    public boolean isStatusAvailable() {
        return true;
    }

    @Override
    public void setOptions(ServerOptions serverOptions) {
        this.fo = serverOptions;
        this.createOrDestroyOptionalObjects();
        this.clientManager.optionsChanged(serverOptions);
        if (this.receivedJobs != null) {
            this.receivedJobs.reloadSettings(this.fo);
        }
        if (this.sentJobs != null) {
            this.sentJobs.reloadSettings(this.fo);
        }
        if (this.sendingJobs != null) {
            this.sendingJobs.reloadSettings(this.fo);
        }
    }

    @Override
    public void setUI(YajOptionPane yajOptionPane) {
        this.dialogUI = yajOptionPane;
    }

    public HylaFaxListConnection(ServerOptions serverOptions, YajOptionPane yajOptionPane) {
        this.setUI(yajOptionPane);
        this.clientManager = new HylaClientManager(serverOptions);
        this.fo = serverOptions;
        this.receivedJobs = this.createRecvdList();
        this.sentJobs = this.createSentList();
        this.sendingJobs = this.createSendingList();
        this.createOrDestroyOptionalObjects();
    }

    protected ManagedFaxJobList<JobFormat> createSendingList() {
        return new SendingFaxJobList(this);
    }

    protected ManagedFaxJobList<JobFormat> createSentList() {
        return new SentFaxJobList(this);
    }

    protected ManagedFaxJobList<RecvFormat> createRecvdList() {
        return new RecvdFaxJobList(this);
    }

    protected ManagedFaxJobList<QueueFileFormat> createArchiveList() {
        return new ArchiveFaxJobList(this, this.fo.getParent().archiveFmt, this.fo);
    }

    protected void createOrDestroyOptionalObjects() {
        if (this.archiveJobs == null) {
            if (this.fo.showArchive) {
                log.finer("Created new archive list");
                this.archiveJobs = this.createArchiveList();
            }
        } else if (!this.fo.showArchive) {
            log.finer("Removed archive list");
            this.archiveJobs = null;
        } else {
            log.finer("Reloaded archive list settings");
            this.archiveJobs.reloadSettings(this.fo);
        }
        if (this.listCache == null) {
            if (this.fo.getParent().useFaxListCache) {
                this.listCache = new Cache();
            }
        } else if (!this.fo.getParent().useFaxListCache) {
            this.listCache = null;
        }
    }

    protected void putDefaultCacheCheckData() {
        Map<String, Object> map = this.listCache.getCheckData();
        map.clear();
        map.put("AppVersion", "0.6.1 (srfax v4)");
        map.put("host", this.fo.host);
        map.put("port", this.fo.port);
        map.put("user", this.fo.user);
        map.put("showArchive", this.fo.showArchive);
        map.put("archiveLocation", this.fo.archiveLocation);
        map.put("dateOffsetSecs", this.fo.dateOffsetSecs);
        map.put("faxListConnectionType", (Object)this.fo.faxListConnectionType);
        map.put("directAccessSpoolPath", this.fo.directAccessSpoolPath);
        map.put("tzone", (Object)this.fo.tzone);
        map.put("recvfmt", this.fo.getParent().recvfmt.toString());
        map.put("sentfmt", this.fo.getParent().sentfmt.toString());
        map.put("sendingfmt", this.fo.getParent().sendingfmt.toString());
        map.put("archivefmt", this.fo.getParent().archiveFmt.toString());
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    protected synchronized void setStatusText(String string) {
        if (!this.statusText.equals(string)) {
            if (Utils.debugMode) {
                log.finer("Set new status text: " + string);
            }
            this.statusText = string;
            for (FaxListConnectionListener faxListConnectionListener : this.listeners) {
                faxListConnectionListener.serverStatusChanged(string);
            }
        }
    }

    protected synchronized void fireRefreshComplete(FaxListConnectionListener.RefreshKind refreshKind, boolean bl) {
        if (Utils.debugMode) {
            log.fine("refreshComplete: refreshKind=" + (Object)((Object)refreshKind) + ", success=" + bl);
        }
        for (FaxListConnectionListener faxListConnectionListener : this.listeners) {
            faxListConnectionListener.refreshComplete(refreshKind, bl);
        }
    }

    public HylaFAXClient beginServerTransaction() throws IOException {
        HylaFAXClient hylaFAXClient = this.clientManager.beginServerTransaction(this.dialogUI);
        if (hylaFAXClient == null) {
            throw new IOException("Could not get a HylaFAXClient connection.");
        }
        return hylaFAXClient;
    }

    public void endServerTransaction() {
        this.clientManager.endServerTransaction();
    }

    @Override
    public void beginMultiOperation() throws IOException {
        log.fine("Begin multi operation");
        this.beginServerTransaction();
    }

    @Override
    public void endMultiOperation() {
        log.fine("End multi operation");
        this.endServerTransaction();
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    @Override
    public void refreshFaxLists() {
        if (this.jobRefresher != null) {
            this.jobRefresher.run();
        }
    }

    @Override
    public void refreshStatus() {
        if (this.statusRefresher != null) {
            this.statusRefresher.run();
        }
    }

    @Override
    public ServerOptions getOptions() {
        return this.fo;
    }

    class JobListRefresher
    extends TimerTask {
        private static final boolean PROFILING = false;
        private final Level PROFILING_LOGLEVEL = Level.FINE;
        private boolean cancelled = false;

        JobListRefresher() {
        }

        /*
         * Exception decompiling
         */
        public synchronized void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean cancel() {
            this.cancelled = true;
            return super.cancel();
        }
    }

    class StatusRefresher
    extends TimerTask {
        StatusRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            boolean bl = false;
            try {
                HylaFAXClient hylaFAXClient = HylaFaxListConnection.this.clientManager.beginServerTransaction(HylaFaxListConnection.this.dialogUI);
                if (hylaFAXClient == null) {
                    HylaFaxListConnection.this.setStatusText(Utils._("Could not log in"));
                    this.cancel();
                    HylaFaxListConnection.this.disconnect();
                    return;
                }
                try {
                    Vector vector;
                    HylaFAXClient hylaFAXClient2 = hylaFAXClient;
                    synchronized (hylaFAXClient2) {
                        log.finest("In hyfc monitor");
                        vector = hylaFAXClient.getList("status");
                    }
                    log.finest("Out of hyfc monitor");
                    HylaFaxListConnection.this.setStatusText(Utils.listToString(vector, "\n"));
                    bl = true;
                }
                catch (SocketException socketException) {
                    log.log(Level.WARNING, "Socket Error refreshing the status, logging out.", socketException);
                    this.cancel();
                    HylaFaxListConnection.this.disconnect();
                    return;
                }
                catch (Exception exception) {
                    HylaFaxListConnection.this.setStatusText(Utils._("Error refreshing the status:") + " " + exception);
                    log.log(Level.WARNING, "Error refreshing the status:", exception);
                }
                finally {
                    HylaFaxListConnection.this.clientManager.endServerTransaction();
                }
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Error refreshing the status:", exception);
            }
            HylaFaxListConnection.this.fireRefreshComplete(FaxListConnectionListener.RefreshKind.STATUS, bl);
        }
    }
}

