/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.srfax;

import com.google.gson.JsonObject;
import gnu.inet.ftp.ServerResponseException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import yajhfc.file.FileFormat;
import yajhfc.model.FmtItem;
import yajhfc.model.JobFormat;
import yajhfc.model.RecvFormat;
import yajhfc.model.TableType;
import yajhfc.model.jobq.HylaDirAccessor;
import yajhfc.model.servconn.FaxDocument;
import yajhfc.model.servconn.JobState;
import yajhfc.model.servconn.defimpl.AbstractFaxJob;
import yajhfc.model.servconn.srfax.SRFaxDoc;
import yajhfc.model.servconn.srfax.SRFaxJobList;
import yajhfc.server.ServerOptions;
import yajhfc.util.SRFaxAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRFaxJob<T extends FmtItem>
extends AbstractFaxJob<T> {
    private static final long serialVersionUID = 1L;
    static final Logger log = Logger.getLogger(SRFaxJob.class.getName());
    protected final String jobID;
    private JsonObject parameters;
    private TableType tableType;

    protected SRFaxJob(SRFaxJobList<T> sRFaxJobList, JsonObject jsonObject, TableType tableType) throws IOException {
        super(sRFaxJobList);
        this.jobID = jsonObject.get("FileName").getAsString();
        this.parameters = jsonObject;
        this.tableType = tableType;
        this.documents = new ArrayList();
        this.documents.clear();
        this.documents.add(new SRFaxDoc(this, this.parameters, FileFormat.PDF, tableType));
    }

    @Override
    public void delete() throws IOException, ServerResponseException {
        if (this.tableType == TableType.SENDING) {
            this.suspend();
            return;
        }
        JsonObject jsonObject = null;
        String string = this.jobID.substring(this.jobID.indexOf("|") + 1);
        jsonObject = SRFaxAPI.sendPost("Delete_Fax&sFaxFileName_0=" + this.jobID + "&sFaxDetailsID_0=" + string + "&sDirection=" + (this.tableType == TableType.RECEIVED ? "IN" : "OUT"), this.parent.getParent().getOptions().user, this.parent.getParent().getOptions().pass.getPassword());
        if (jsonObject.get("Status").getAsString().compareTo("Failed") == 0) {
            throw new ServerResponseException(jsonObject.get("Result").getAsString());
        }
    }

    public boolean pollForChanges() throws IOException {
        this.readInbox();
        return true;
    }

    protected void readInbox() throws IOException {
        if (this.tableType == TableType.RECEIVED) {
            List list = this.parent.getColumns().getCompleteView();
            Object[] objectArray = new Object[list.size()];
            block38: for (int i = 0; i < list.size(); ++i) {
                switch ((RecvFormat)list.get(i)) {
                    case a: {
                        objectArray[i] = "";
                        continue block38;
                    }
                    case b: {
                        objectArray[i] = -1;
                        continue block38;
                    }
                    case d: {
                        objectArray[i] = "PDF";
                        continue block38;
                    }
                    case e: {
                        objectArray[i] = "";
                        continue block38;
                    }
                    case f: {
                        objectArray[i] = this.parameters.get("FileName").getAsString();
                        continue block38;
                    }
                    case h: {
                        objectArray[i] = null;
                        continue block38;
                    }
                    case i: {
                        objectArray[i] = "";
                        continue block38;
                    }
                    case j: {
                        objectArray[i] = this.parameters.get("CallerID").getAsString();
                        continue block38;
                    }
                    case l: {
                        objectArray[i] = -1;
                        continue block38;
                    }
                    case m: {
                        objectArray[i] = "-r--r--";
                        continue block38;
                    }
                    case n: {
                        objectArray[i] = this.parameters.get("Size").getAsInt();
                        continue block38;
                    }
                    case o: {
                        objectArray[i] = this.parameters.get("User_FaxNumber").isJsonNull() ? "" : this.parameters.get("User_FaxNumber").getAsString();
                        continue block38;
                    }
                    case p: {
                        objectArray[i] = this.parameters.get("Pages").getAsInt();
                        continue block38;
                    }
                    case r: {
                        objectArray[i] = -1;
                        continue block38;
                    }
                    case s: {
                        objectArray[i] = this.parameters.get("CallerID").getAsString() + " / " + this.parameters.get("RemoteID").getAsString();
                        continue block38;
                    }
                    case t: {
                        objectArray[i] = DateFormat.getDateTimeInstance().format(this.parameters.get("EpochTime").getAsLong() * 1000L);
                        continue block38;
                    }
                    case w: {
                        objectArray[i] = 1;
                        continue block38;
                    }
                    case z: {
                        objectArray[i] = Boolean.FALSE;
                        continue block38;
                    }
                    case Y: 
                    case Z: {
                        objectArray[i] = this.parameters.get("EpochTime").getAsLong() * 1000L;
                    }
                }
            }
            this.data = objectArray;
        } else if (this.tableType == TableType.SENT || this.tableType == TableType.SENDING) {
            List list = this.parent.getColumns().getCompleteView();
            Object[] objectArray = new Object[list.size()];
            block39: for (int i = 0; i < list.size(); ++i) {
                switch ((JobFormat)list.get(i)) {
                    case j: {
                        objectArray[i] = this.parameters.get("FileName").getAsString();
                        continue block39;
                    }
                    case s: {
                        if (this.tableType == TableType.SENT) {
                            objectArray[i] = this.parameters.get("SentStatus").getAsString().compareTo("Sent") == 0 ? "Sent" : this.parameters.get("ErrorCode").getAsString();
                            continue block39;
                        }
                        objectArray[i] = this.parameters.get("Status").getAsString();
                        continue block39;
                    }
                    case z: {
                        if (this.tableType == TableType.SENT) {
                            objectArray[i] = this.parameters.get("Duration").getAsString();
                            continue block39;
                        }
                        objectArray[i] = "";
                        continue block39;
                    }
                    case e: {
                        objectArray[i] = this.parameters.get("ToFaxNumber").getAsString();
                        continue block39;
                    }
                    case R: {
                        try {
                            objectArray[i] = this.parameters.get("ToFaxNumber").getAsString() + " / " + this.parameters.get("RemoteID").getAsString();
                        }
                        catch (Exception exception) {
                            objectArray[i] = "";
                        }
                        continue block39;
                    }
                    case Y: 
                    case Z: {
                        try {
                            objectArray[i] = this.parameters.get("EpochTime").getAsLong() * 1000L;
                        }
                        catch (Exception exception) {
                            objectArray[i] = -1L;
                        }
                        continue block39;
                    }
                    case M: {
                        objectArray[i] = this.parent.getParent().getOptions().SRFaxEmail;
                        continue block39;
                    }
                    case o: 
                    case S: {
                        if (this.tableType == TableType.SENT) {
                            objectArray[i] = this.parameters.get("User_FaxNumber").isJsonNull() ? "" : this.parameters.get("User_FaxNumber").getAsString();
                            continue block39;
                        }
                        objectArray[i] = this.parameters.get("User_ID").getAsString();
                        continue block39;
                    }
                    case p: 
                    case y: {
                        objectArray[i] = this.parameters.get("Pages").isJsonNull() ? Integer.valueOf(-1).intValue() : this.parameters.get("Pages").getAsInt();
                        continue block39;
                    }
                    case srfax_subject: {
                        objectArray[i] = this.parameters.get("Subject").isJsonNull() ? "" : this.parameters.get("Subject").getAsString();
                        continue block39;
                    }
                    case a: 
                    case n: 
                    case a_desc: 
                    case n_desc: {
                        if (this.tableType == TableType.SENT) {
                            objectArray[i] = this.parameters.get("SentStatus").getAsString().compareTo("Sent") == 0 ? JobState.DONE : (this.parameters.get("SentStatus").getAsString().compareTo("In Progress") == 0 ? JobState.PENDING : JobState.FAILED);
                            continue block39;
                        }
                        objectArray[i] = JobState.RUNNING;
                        continue block39;
                    }
                    default: {
                        objectArray[i] = -1;
                    }
                }
            }
            this.data = objectArray;
        }
        this.state = JobState.DONE;
    }

    @Override
    protected JobState calculateJobState() {
        return JobState.DONE;
    }

    protected void readSpoolFile(HylaDirAccessor hylaDirAccessor) throws IOException {
        this.readInbox();
    }

    @Override
    public void suspend() throws IOException, ServerResponseException {
        JsonObject jsonObject = null;
        String string = this.jobID.substring(this.jobID.indexOf("|") + 1);
        jsonObject = SRFaxAPI.sendPost("Stop_Fax&sFaxDetailsID=" + string, this.parent.getParent().getOptions().user, this.parent.getParent().getOptions().pass.getPassword());
        if (jsonObject.get("Status").getAsString().compareTo("Failed") == 0) {
            throw new ServerResponseException(jsonObject.get("Result").getAsString());
        }
    }

    @Override
    public void resume() throws IOException, ServerResponseException {
        throw new ServerResponseException("SRFax does not support resume operation.");
    }

    @Override
    public boolean isRead() {
        return this.parameters.get("ViewedStatus").getAsString().compareTo("Y") == 0;
    }

    @Override
    public void setRead(boolean bl) {
        this.parameters.remove("ViewedStatus");
        this.parameters.addProperty("ViewedStatus", "Y");
        ServerOptions serverOptions = this.parent.getParent().getOptions();
        String string = this.jobID.substring(this.jobID.indexOf("|") + 1);
        try {
            JsonObject jsonObject = SRFaxAPI.sendPost("Update_Viewed_Status&sFaxFileName=" + this.jobID + "&sFaxDetailsID=" + string + "&sDirection=" + (this.tableType == TableType.RECEIVED ? "IN" : "OUT") + "&sMarkasViewed=Y", serverOptions.user, serverOptions.pass.getPassword());
        }
        catch (ServerResponseException serverResponseException) {
            // empty catch block
        }
        this.setRead(bl, true);
    }

    @Override
    protected List<FaxDocument> calcDocuments() {
        return null;
    }

    @Override
    public Object getIDValue() {
        return this.jobID;
    }
}

