/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.srfax;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import gnu.hylafax.HylaFAXClient;
import gnu.inet.ftp.ServerResponseException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import yajhfc.model.FmtItem;
import yajhfc.model.FmtItemList;
import yajhfc.model.TableType;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.servconn.FaxListConnection;
import yajhfc.model.servconn.defimpl.AbstractFaxJobList;
import yajhfc.model.servconn.hylafax.ManagedFaxJobList;
import yajhfc.model.servconn.srfax.SRFaxJob;
import yajhfc.server.ServerOptions;
import yajhfc.util.SRFaxAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRFaxJobList<T extends FmtItem>
extends AbstractFaxJobList<T>
implements ManagedFaxJobList<T> {
    TableType tableType;

    protected SRFaxJobList(FmtItemList<T> fmtItemList, FaxListConnection faxListConnection, TableType tableType) {
        super(fmtItemList, faxListConnection);
        this.tableType = tableType;
    }

    @Override
    public TableType getJobType() {
        return this.tableType;
    }

    @Override
    public void pollForNewJobs(HylaFAXClient hylaFAXClient) throws IOException, ServerResponseException {
        this.setJobs(this.updateQueueFiles());
    }

    @Override
    public void reloadSettings(ServerOptions serverOptions) {
    }

    @Override
    public void disconnectCleanup() {
        this.setJobs(Collections.emptyList());
    }

    public List<FaxJob<T>> updateQueueFiles() throws IOException, ServerResponseException {
        Object object;
        Object object2;
        ArrayList<FaxJob<T>> arrayList = new ArrayList<FaxJob<T>>();
        ServerOptions serverOptions = this.getParent().getOptions();
        String string = this.tableType == TableType.RECEIVED ? "Get_Fax_Inbox&sIncludeSubUsers=Y" : (this.tableType == TableType.SENT ? "Get_Fax_Outbox&sIncludeSubUsers=Y" : "Get_Faxes_Queued&sIncludeSubUsers=Y");
        if (this.tableType != TableType.SENDING && serverOptions.SRFaxDayRange > 0) {
            object2 = LocalDateTime.now().plusDays(1L);
            object = ((LocalDateTime)object2).minusDays(serverOptions.SRFaxDayRange + 1);
            string = string + "&sPeriod=RANGE&sStartDate=" + ((LocalDateTime)object).format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "&sEndDate=" + ((LocalDateTime)object2).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        if (this.tableType == TableType.RECEIVED) {
            if (!serverOptions.SRFaxShowRead) {
                string = string + "&sViewedStatus=UNREAD";
            } else if (!serverOptions.SRFaxShowUnread) {
                string = string + "&sViewedStatus=READ";
            }
        }
        object = new JsonArray();
        try {
            object2 = SRFaxAPI.sendPost(string, serverOptions.user, serverOptions.pass.getPassword());
            if (((JsonObject)object2).get("Status").getAsString().compareTo("Failed") == 0) {
                return arrayList;
            }
            object = ((JsonObject)object2).get("Result").getAsJsonArray();
        }
        catch (Exception exception) {
            throw new ServerResponseException(exception.getMessage());
        }
        for (int i = 0; i < ((JsonArray)object).size(); ++i) {
            JsonObject jsonObject = ((JsonArray)object).get(i).getAsJsonObject();
            if (!serverOptions.SRFaxIncludeSubUsers && !serverOptions.user.equals(jsonObject.get("User_ID").getAsString())) continue;
            SRFaxJob<T> sRFaxJob = this.createJob(jsonObject);
            sRFaxJob.readInbox();
            arrayList.add(sRFaxJob);
        }
        return arrayList;
    }

    protected SRFaxJob<T> createJob(JsonObject jsonObject) throws IOException {
        return new SRFaxJob(this, jsonObject, this.tableType);
    }
}

