/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import yajhfc.FaxOptions;
import yajhfc.FileTextField;
import yajhfc.Utils;
import yajhfc.file.MultiFileConvFormat;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.options.MultiFileMode;
import yajhfc.options.OptionsWin;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ComponentEnabler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathAndViewPanel
extends AbstractOptionsPanel<FaxOptions> {
    public static boolean requireTIFF2PDF = true;
    FileTextField ftfFaxViewer;
    FileTextField ftfPSViewer;
    FileTextField ftfPDFViewer;
    FileTextField ftfGSLocation;
    FileTextField ftfTIFF2PDFLocation;
    JCheckBox checkCreateSingleFile;
    JCheckBox checkCreateAlwaysAsTargetFormat;
    JCheckBox checkCreateAlwaysAsTargetFormatView;
    JCheckBox checkUseTiffPaperSize;
    JCheckBox checkCustomFaxViewer;
    JCheckBox checkCustomPSViewer;
    JCheckBox checkCustomPDFViewer;
    JComboBox comboSendMode;
    JComboBox comboTargetFormat;
    JComboBox comboTargetFormatView;

    public PathAndViewPanel() {
        super(false);
    }

    @Override
    protected void createOptionsUI() {
        this.setLayout(new TableLayout(new double[][]{{5.0, 0.5, 5.0, -1.0, 5.0}, {5.0, -2.0, 5.0, -2.0, -1.0, 5.0}}));
        JPanel jPanel = this.createPanelPaths();
        JPanel jPanel2 = this.createPanelView();
        JPanel jPanel3 = this.createPanelSend();
        this.add((Component)jPanel, "1,1,3,1,f,f");
        this.add((Component)jPanel2, "1,3,f,f");
        this.add((Component)jPanel3, "3,3,f,f");
    }

    private JPanel createPanelPaths() {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Utils._("Path settings")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.ftfFaxViewer = new ExeFileTextField();
        this.ftfFaxViewer.setAlignmentX(0.0f);
        this.ftfPSViewer = new ExeFileTextField();
        this.ftfPSViewer.setAlignmentX(0.0f);
        this.ftfPDFViewer = new ExeFileTextField();
        this.ftfPDFViewer.setAlignmentX(0.0f);
        this.ftfGSLocation = new FileTextField();
        this.ftfGSLocation.getJTextField().addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.ftfGSLocation.setAlignmentX(0.0f);
        this.ftfTIFF2PDFLocation = new FileTextField();
        this.ftfTIFF2PDFLocation.getJTextField().addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.ftfTIFF2PDFLocation.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel(Utils._("Command line for fax viewer: (insert %s as a placeholder for the filename)"));
        jLabel.setAlignmentX(0.0f);
        JLabel jLabel2 = new JLabel(Utils._("Command line for Postscript viewer: (insert %s as a placeholder for the filename)"));
        jLabel2.setAlignmentX(0.0f);
        JLabel jLabel3 = new JLabel(Utils._("Command line for PDF viewer: (insert %s as a placeholder for the filename)"));
        jLabel3.setAlignmentX(0.0f);
        JLabel jLabel4 = new JLabel(Utils._("Location of GhostScript executable (optional):"));
        jLabel4.setAlignmentX(0.0f);
        JLabel jLabel5 = new JLabel(Utils._("Location of tiff2pdf executable (optional):"));
        jLabel5.setAlignmentX(0.0f);
        this.checkUseTiffPaperSize = new JCheckBox(Utils._("Always use paper size from YajHFC options in the PDF"));
        this.checkUseTiffPaperSize.setAlignmentX(0.0f);
        this.checkCustomFaxViewer = new JCheckBox(Utils._("Use custom fax viewer"));
        ComponentEnabler.installOn(this.checkCustomFaxViewer, true, this.ftfFaxViewer, jLabel);
        this.checkCustomPSViewer = new JCheckBox(Utils._("Use custom PostScript viewer"));
        ComponentEnabler.installOn(this.checkCustomPSViewer, true, this.ftfPSViewer, jLabel2);
        this.checkCustomPDFViewer = new JCheckBox(Utils._("Use custom PDF viewer"));
        ComponentEnabler.installOn(this.checkCustomPDFViewer, true, this.ftfPDFViewer, jLabel3);
        Dimension dimension = new Dimension(5, 5);
        jPanel.add(this.checkCustomFaxViewer);
        jPanel.add(jLabel);
        jPanel.add(this.ftfFaxViewer);
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(new JSeparator());
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(this.checkCustomPSViewer);
        jPanel.add(jLabel2);
        jPanel.add(this.ftfPSViewer);
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(new JSeparator());
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(this.checkCustomPDFViewer);
        jPanel.add(jLabel3);
        jPanel.add(this.ftfPDFViewer);
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(new JSeparator());
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(jLabel4);
        jPanel.add(this.ftfGSLocation);
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(jLabel5);
        jPanel.add(this.ftfTIFF2PDFLocation);
        jPanel.add(this.checkUseTiffPaperSize);
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private JPanel createPanelView() {
        double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0}, new double[7]};
        dArrayArray[1][6] = 5.0;
        for (int i = 0; i < 6; ++i) {
            dArrayArray[1][i] = i % 2 == 0 ? 0.3333333333333333 : -2.0;
        }
        dArrayArray[1][4] = -1.0;
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new TableLayout(dArrayArray));
        jPanel.setBorder(BorderFactory.createTitledBorder(Utils._("View settings")));
        this.checkCreateSingleFile = new JCheckBox("<html>" + Utils._("View faxes as single file (needs GhostScript+tiff2pdf)") + "</html>");
        this.checkCreateAlwaysAsTargetFormatView = new JCheckBox(Utils._("View faxes always in this format"));
        this.comboTargetFormatView = new JComboBox<MultiFileConvFormat>(MultiFileConvFormat.values());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PathAndViewPanel.this.checkPanelViewEnabled();
            }
        };
        this.checkCreateSingleFile.addActionListener(actionListener);
        jPanel.add((Component)this.checkCreateSingleFile, "1,0,1,1,f,c");
        Utils.addWithLabel(jPanel, (Component)this.comboTargetFormatView, Utils._("Format for viewing:"), "1,3,f,c");
        jPanel.add((Component)this.checkCreateAlwaysAsTargetFormatView, "1,4,f,c");
        return jPanel;
    }

    private JPanel createPanelSend() {
        double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0}, new double[7]};
        dArrayArray[1][6] = 5.0;
        for (int i = 0; i < 6; ++i) {
            dArrayArray[1][i] = i % 2 == 0 ? 0.3333333333333333 : -2.0;
        }
        dArrayArray[1][4] = -1.0;
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new TableLayout(dArrayArray));
        jPanel.setBorder(BorderFactory.createTitledBorder(Utils._("Send settings")));
        this.checkCreateAlwaysAsTargetFormat = new JCheckBox(Utils._("Send faxes always in this format"));
        this.comboTargetFormat = new JComboBox<MultiFileConvFormat>(MultiFileConvFormat.values());
        this.comboSendMode = new JComboBox<MultiFileMode>(MultiFileMode.values());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PathAndViewPanel.this.checkPanelSendEnabled();
            }
        };
        this.comboSendMode.addActionListener(actionListener);
        Utils.addWithLabel(jPanel, (Component)this.comboSendMode, Utils._("Send multiple files as:"), "1,1,f,c");
        Utils.addWithLabel(jPanel, (Component)this.comboTargetFormat, Utils._("Format for sending:"), "1,3,f,c");
        jPanel.add((Component)this.checkCreateAlwaysAsTargetFormat, "1,4,f,c");
        return jPanel;
    }

    void checkPanelViewEnabled() {
        boolean bl = this.checkCreateSingleFile.isSelected();
        this.checkCreateAlwaysAsTargetFormatView.setEnabled(bl);
        this.comboTargetFormatView.setEnabled(bl);
    }

    void checkPanelSendEnabled() {
        boolean bl = this.comboSendMode.getSelectedItem() != MultiFileMode.NONE;
        this.checkCreateAlwaysAsTargetFormat.setEnabled(bl);
        this.comboTargetFormat.setEnabled(bl);
    }

    @Override
    public void loadSettings(FaxOptions faxOptions) {
        this.ftfFaxViewer.setText(faxOptions.faxViewer);
        this.ftfPSViewer.setText(faxOptions.psViewer);
        this.ftfPDFViewer.setText(faxOptions.pdfViewer);
        this.ftfGSLocation.setText(faxOptions.ghostScriptLocation);
        this.ftfTIFF2PDFLocation.setText(faxOptions.tiff2PDFLocation);
        this.checkUseTiffPaperSize.setSelected(faxOptions.usePaperSizeForTIFF2Any);
        this.checkCreateAlwaysAsTargetFormat.setSelected(faxOptions.alwaysCreateTargetFormat);
        this.checkCreateAlwaysAsTargetFormatView.setSelected(faxOptions.alwaysCreateTargetFormatForViewing);
        this.checkCreateSingleFile.setSelected(faxOptions.createSingleFilesForViewing);
        this.checkCustomFaxViewer.setSelected(faxOptions.useCustomFaxViewer);
        this.checkCustomPSViewer.setSelected(faxOptions.useCustomPSViewer);
        this.checkCustomPDFViewer.setSelected(faxOptions.useCustomPDFViewer);
        this.comboSendMode.setSelectedItem((Object)faxOptions.multiFileSendMode);
        this.comboTargetFormat.setSelectedItem((Object)faxOptions.singleFileFormat);
        this.comboTargetFormatView.setSelectedItem((Object)faxOptions.singleFileFormatForViewing);
        this.checkPanelViewEnabled();
        this.checkPanelSendEnabled();
    }

    @Override
    public void saveSettings(FaxOptions faxOptions) {
        faxOptions.faxViewer = this.ftfFaxViewer.getText();
        faxOptions.psViewer = this.ftfPSViewer.getText();
        faxOptions.pdfViewer = this.ftfPDFViewer.getText();
        faxOptions.ghostScriptLocation = this.ftfGSLocation.getText();
        faxOptions.tiff2PDFLocation = this.ftfTIFF2PDFLocation.getText();
        faxOptions.usePaperSizeForTIFF2Any = this.checkUseTiffPaperSize.isSelected();
        faxOptions.alwaysCreateTargetFormat = this.checkCreateAlwaysAsTargetFormat.isSelected();
        faxOptions.alwaysCreateTargetFormatForViewing = this.checkCreateAlwaysAsTargetFormatView.isSelected();
        faxOptions.createSingleFilesForViewing = this.checkCreateSingleFile.isSelected();
        faxOptions.useCustomFaxViewer = this.checkCustomFaxViewer.isSelected();
        faxOptions.useCustomPSViewer = this.checkCustomPSViewer.isSelected();
        faxOptions.useCustomPDFViewer = this.checkCustomPDFViewer.isSelected();
        faxOptions.multiFileSendMode = (MultiFileMode)((Object)this.comboSendMode.getSelectedItem());
        faxOptions.singleFileFormat = (MultiFileConvFormat)((Object)this.comboTargetFormat.getSelectedItem());
        faxOptions.singleFileFormatForViewing = (MultiFileConvFormat)((Object)this.comboTargetFormatView.getSelectedItem());
    }

    @Override
    public boolean validateSettings(OptionsWin optionsWin) {
        boolean bl;
        if (this.checkCustomFaxViewer.isSelected() && !this.commandLineOK(this.ftfFaxViewer.getText())) {
            optionsWin.focusComponent(this.ftfFaxViewer.getJTextField());
            JOptionPane.showMessageDialog(optionsWin, Utils._("Please enter the command line for the fax viewer."), Utils._("Error"), 0);
            return false;
        }
        if (this.checkCustomPSViewer.isSelected() && !this.commandLineOK(this.ftfPSViewer.getText())) {
            optionsWin.focusComponent(this.ftfPSViewer.getJTextField());
            JOptionPane.showMessageDialog(optionsWin, Utils._("Please enter the command line for the PostScript viewer."), Utils._("Error"), 0);
            return false;
        }
        if (this.checkCustomPDFViewer.isSelected() && !this.commandLineOK(this.ftfPDFViewer.getText())) {
            optionsWin.focusComponent(this.ftfPDFViewer.getJTextField());
            JOptionPane.showMessageDialog(optionsWin, Utils._("Please enter the command line for the PDF viewer."), Utils._("Error"), 0);
            return false;
        }
        boolean bl2 = bl = this.checkCreateSingleFile.isSelected() || this.comboSendMode.getSelectedItem() != MultiFileMode.NONE;
        if (bl && !this.executableOK(this.ftfGSLocation.getText())) {
            optionsWin.focusComponent(this.ftfGSLocation.getJTextField());
            JOptionPane.showMessageDialog(optionsWin, Utils._("Please enter the location of the GhostScript executable."), Utils._("Error"), 0);
            return false;
        }
        if (requireTIFF2PDF && bl && !this.executableOK(this.ftfTIFF2PDFLocation.getText())) {
            optionsWin.focusComponent(this.ftfTIFF2PDFLocation.getJTextField());
            JOptionPane.showMessageDialog(optionsWin, Utils._("Please enter the location of the tiff2pdf executable."), Utils._("Error"), 0);
            return false;
        }
        return true;
    }

    private boolean commandLineOK(String string) {
        return string != null && string.length() > 0 && Utils.searchExecutableInPath(Utils.extractExecutableFromCmdLine(string)) != null;
    }

    private boolean executableOK(String string) {
        return string != null && string.length() > 0 && Utils.searchExecutableInPath(string) != null;
    }

    static class ExeFileTextField
    extends FileTextField {
        protected String readTextFieldFileName() {
            return Utils.extractExecutableFromCmdLine(this.getText());
        }

        protected void writeTextFieldFileName(String string) {
            if (string.contains(" ")) {
                this.setText("\"" + string + "\" \"%s\"");
            } else {
                this.setText(string + " \"%s\"");
            }
        }

        public ExeFileTextField() {
            this.getJTextField().addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        }
    }
}

