/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.convrules;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import yajhfc.Utils;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.convrules.ConcatRule;
import yajhfc.phonebook.convrules.EntryToStringRule;
import yajhfc.phonebook.convrules.EntryToStringRuleEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleParser {
    private static Map<String, PBEntryField> descToFieldMap;
    private static final Pattern stringPattern;
    private static final Pattern fieldPattern;

    public static Map<String, PBEntryField> getDescriptionToFieldMap() {
        if (descToFieldMap == null) {
            descToFieldMap = new HashMap<String, PBEntryField>(PBEntryField.FIELD_COUNT);
            for (PBEntryField pBEntryField : PBEntryField.values()) {
                descToFieldMap.put(pBEntryField.getDescription().toLowerCase(), pBEntryField);
            }
        }
        return descToFieldMap;
    }

    public static ConcatRule parseRule(String string, boolean bl) throws RuleParseException {
        Matcher matcher = stringPattern.matcher(string);
        Matcher matcher2 = fieldPattern.matcher(string);
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (n < string.length()) {
            if (matcher.find(n)) {
                arrayList.add(RuleParser.parseString(matcher));
                n = matcher.end();
                continue;
            }
            if (matcher2.find(n)) {
                arrayList.add(RuleParser.parseField(matcher2, bl));
                n = matcher2.end();
                continue;
            }
            throw new RuleParseException(MessageFormat.format("Error: Could not parse input beginning with \"{0}\".", string.substring(n)), MessageFormat.format(Utils._("Error: Could not parse input beginning with \"{0}\"."), string.substring(n)), n);
        }
        return new ConcatRule(arrayList.toArray());
    }

    private static Object parseString(Matcher matcher) {
        String string = matcher.group(1);
        if (string.indexOf(92) >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\\': {
                        if (++i >= string.length()) break;
                        c = string.charAt(i);
                    }
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private static Object parseField(Matcher matcher, boolean bl) throws RuleParseException {
        String string = matcher.group(1).toLowerCase();
        PBEntryField pBEntryField = bl ? RuleParser.getDescriptionToFieldMap().get(string) : PBEntryField.getKeyToFieldMap().get(string);
        if (pBEntryField == null) {
            throw new RuleParseException(MessageFormat.format("Unknown field \"{0}\".", string), MessageFormat.format(Utils._("Unknown field \"{0}\"."), string), matcher.start(), matcher.end() - 1);
        }
        return pBEntryField;
    }

    public static String ruleToString(EntryToStringRule entryToStringRule, boolean bl) {
        if (entryToStringRule instanceof EntryToStringRuleEnum) {
            entryToStringRule = ((EntryToStringRuleEnum)entryToStringRule).getWrappedRule();
        }
        if (!(entryToStringRule instanceof ConcatRule)) {
            throw new UnsupportedOperationException("Only ConcatRules supported!");
        }
        ConcatRule concatRule = (ConcatRule)entryToStringRule;
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : concatRule.getChildren()) {
            String string;
            if (object instanceof EntryToStringRule) {
                if (object instanceof ConcatRule) {
                    stringBuilder.append(RuleParser.ruleToString((ConcatRule)object, bl));
                    continue;
                }
                throw new UnsupportedOperationException("Nested non-concat rules not supported");
            }
            if (object instanceof PBEntryField) {
                string = bl ? ((PBEntryField)object).getDescription() : ((PBEntryField)object).getKey();
                stringBuilder.append('[').append(string).append(']');
                continue;
            }
            string = object.toString();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '[': 
                    case '\\': 
                    case ']': {
                        stringBuilder.append('\\');
                    }
                }
                stringBuilder.append(c);
            }
        }
        return stringBuilder.toString();
    }

    static {
        stringPattern = Pattern.compile("\\G((?:\\\\\\[|[^\\[])+)");
        fieldPattern = Pattern.compile("\\G\\[(.+?)\\]");
    }

    public static class RuleParseException
    extends ParseException {
        private final int errorEnd;
        private final String localizedMsg;

        public RuleParseException(String string, String string2, int n) {
            this(string, string2, n, -1);
        }

        public RuleParseException(String string, String string2, int n, int n2) {
            super(string, n);
            this.errorEnd = n2;
            this.localizedMsg = string2;
        }

        public String getLocalizedMessage() {
            return this.localizedMsg;
        }

        public int getErrorEnd() {
            return this.errorEnd;
        }
    }
}

