/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.csv;

import au.com.bytecode.opencsv.CSVWriter;
import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.PhoneBookException;
import yajhfc.phonebook.csv.CSVDialog;
import yajhfc.phonebook.csv.CSVPhonebookEntry;
import yajhfc.phonebook.csv.CSVSettings;
import yajhfc.phonebook.jdbc.ConnectionSettings;
import yajhfc.util.ExampleFileFilter;
import yajhfc.util.SafeJFileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVPhoneBook
extends PhoneBook {
    private static final Logger log = Logger.getLogger(CSVPhoneBook.class.getName());
    public static final String PB_Prefix = "CSV";
    public static final String PB_DisplayName = Utils._("CSV file");
    public static final String PB_Description = Utils._("A CSV/text file containing phone book entries.");
    public static final boolean PB_CanExport = true;
    protected CSVSettings settings;
    protected List<CSVPhonebookEntry> entries = new ArrayList<CSVPhonebookEntry>();
    protected List<PhoneBookEntry> entryView = Collections.unmodifiableList(this.entries);
    protected String[] columnHeaders;
    protected Map<PBEntryField, Integer> columnMapping = new EnumMap<PBEntryField, Integer>(PBEntryField.class);
    protected int columnCount;
    protected int maxMapIndex;
    protected boolean wasChanged = false;
    protected boolean open = false;

    public CSVPhoneBook(Dialog dialog) {
        super(dialog);
    }

    @Override
    public PhoneBookEntry addNewEntry() {
        Object[] objectArray = new String[this.columnCount];
        Arrays.fill(objectArray, "");
        CSVPhonebookEntry cSVPhonebookEntry = new CSVPhonebookEntry(this, (String[])objectArray);
        this.entries.add(cSVPhonebookEntry);
        this.fireEntriesAdded(this.entries.size() - 1, cSVPhonebookEntry);
        this.wasChanged = true;
        return cSVPhonebookEntry;
    }

    @Override
    public String browseForPhoneBook(boolean bl) {
        CSVSettings cSVSettings = new CSVSettings();
        if (this.settings != null) {
            cSVSettings.copyFrom(this.settings);
        }
        SafeJFileChooser safeJFileChooser = new SafeJFileChooser();
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter(new String[]{"txt", "csv"}, Utils._("CSV files"));
        safeJFileChooser.addChoosableFileFilter(exampleFileFilter);
        safeJFileChooser.setFileFilter(exampleFileFilter);
        if (cSVSettings.fileName != null && cSVSettings.fileName.length() > 0) {
            safeJFileChooser.setSelectedFile(new File(cSVSettings.fileName));
        }
        safeJFileChooser.setDialogType(bl ? 1 : 0);
        if (safeJFileChooser.showDialog(this.parentDialog, null) == 0) {
            cSVSettings.fileName = safeJFileChooser.getSelectedFile().getAbsolutePath();
            cSVSettings.overwrite = bl;
            if (this.settings == null && safeJFileChooser.getSelectedFile().exists()) {
                cSVSettings.tryAutodetect();
            }
            CSVDialog cSVDialog = new CSVDialog(this.parentDialog, cSVSettings);
            cSVDialog.setVisible(true);
            if (cSVDialog.clickedOK) {
                return "CSV:" + cSVSettings.saveToString();
            }
        }
        return null;
    }

    @Override
    public void close() {
        if (this.wasChanged) {
            try {
                this.saveEntries();
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Error saving the phone book:", iOException);
            }
            this.wasChanged = false;
            this.open = false;
        }
    }

    @Override
    public List<PhoneBookEntry> getEntries() {
        return this.entryView;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    protected void openInternal(String string) throws PhoneBookException {
        this.settings = new CSVSettings();
        this.settings.loadFromString(string);
        this.columnMapping.clear();
        this.maxMapIndex = -1;
        for (PBEntryField pBEntryField : PBEntryField.values()) {
            String string2 = this.settings.getMappingFor(pBEntryField);
            if (ConnectionSettings.isNoField(string2)) continue;
            int n = Integer.parseInt(string2);
            this.columnMapping.put(pBEntryField, n);
            if (n <= this.maxMapIndex) continue;
            this.maxMapIndex = n;
        }
        this.reloadEntries();
        this.open = true;
    }

    private String[] ensureSize(String[] stringArray) {
        if (stringArray.length > this.maxMapIndex) {
            return stringArray;
        }
        Object[] objectArray = new String[this.maxMapIndex + 1];
        Arrays.fill(objectArray, stringArray.length, objectArray.length, "");
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        return objectArray;
    }

    /*
     * Unable to fully structure code
     */
    private void reloadEntries() throws PhoneBookException {
        this.entries.clear();
        var1_1 = new File(this.settings.fileName);
        if (var1_1.exists()) {
            try {
                var2_2 = this.settings.createReader();
                if (this.settings.firstLineAreHeaders) {
                    this.columnHeaders = var2_2.readNext();
                    if (this.columnHeaders == null) {
                        this.initEmptyFile();
                        this.wasChanged = false;
                        return;
                    }
                } else {
                    this.columnHeaders = null;
                }
                while ((var3_4 = var2_2.readNext()) != null) {
                    this.entries.add(new CSVPhonebookEntry(this, this.ensureSize(var3_4)));
                }
                var2_2.close();
                if (this.settings.firstLineAreHeaders) {
                    this.columnCount = this.columnHeaders.length;
                } else if (this.entries.size() > 0) {
                    this.columnCount = this.entries.get((int)0).columnData.length;
                } else {
                    this.initEmptyFile();
                }
                if (this.columnCount > this.maxMapIndex) ** GOTO lbl32
                this.columnCount = this.maxMapIndex + 1;
            }
            catch (Exception var2_3) {
                throw new PhoneBookException(var2_3, false);
            }
        } else {
            this.initEmptyFile();
        }
lbl32:
        // 3 sources

        this.wasChanged = false;
    }

    private void initEmptyFile() {
        if (this.settings.firstLineAreHeaders) {
            PBEntryField[] pBEntryFieldArray = PBEntryField.values();
            this.columnHeaders = new String[pBEntryFieldArray.length];
            for (int i = 0; i < pBEntryFieldArray.length; ++i) {
                this.columnHeaders[i] = pBEntryFieldArray[i].getDescription();
            }
        } else {
            this.columnHeaders = null;
        }
        this.columnCount = PBEntryField.FIELD_COUNT;
    }

    void deleteEntry(PhoneBookEntry phoneBookEntry) {
        int n = Utils.identityIndexOf(this.entries, phoneBookEntry);
        if (n >= 0) {
            this.entries.remove(n);
            this.fireEntriesRemoved(n, phoneBookEntry);
            this.wasChanged = true;
        }
    }

    void writeEntry(PhoneBookEntry phoneBookEntry) {
        int n = Utils.identityIndexOf(this.entries, phoneBookEntry);
        this.fireEntriesChanged(n, phoneBookEntry);
        this.wasChanged = true;
    }

    private void saveEntries() throws IOException {
        CSVWriter cSVWriter = this.settings.createWriter();
        if (this.settings.firstLineAreHeaders) {
            cSVWriter.writeNext(this.columnHeaders);
        }
        for (CSVPhonebookEntry cSVPhonebookEntry : this.entries) {
            cSVWriter.writeNext(cSVPhonebookEntry.columnData);
        }
        cSVWriter.close();
    }

    @Override
    public String getDisplayCaption() {
        String string = this.settings.displayCaption;
        if (string != null && string.length() > 0) {
            return string;
        }
        return Utils.shortenFileNameForDisplay(this.settings.fileName, 40);
    }
}

