/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.jdbc;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import yajhfc.Utils;
import yajhfc.phonebook.AbstractConnectionSettings;
import yajhfc.phonebook.jdbc.ConnectionSettings;
import yajhfc.plugin.PluginManager;
import yajhfc.util.CancelAction;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.PasswordDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionDialog
extends JDialog
implements ActionListener {
    private static final Logger log = Logger.getLogger(ConnectionDialog.class.getName());
    private ArrayList<JComboBox> fieldCombos = new ArrayList();
    private JTextField textDriverClass;
    private JTextField textURL;
    private JTextField textUserName;
    private JComboBox comboTable;
    JCheckBox checkAskForPassword;
    JPasswordField textPassword;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton buttonTest;
    private boolean noFieldOK;
    private static final double border = 10.0;
    public boolean clickedOK;
    private Connection conn;
    private Map<String, FieldMapEntry> fieldNameMap;
    private Map<String, Component> settingsComponents = new HashMap<String, Component>();
    private static final String DBURL_FIELD = "dbURL";
    private static final String DRIVER_FIELD = "driver";
    private static final String USER_FIELD = "user";
    private static final String PASSWORD_FIELD = "pwd";
    private static final String TABLE_FIELD = "table";
    private static final String ASKFORPWD_FIELD = "askForPWD";
    private static final String FIELD_ClientProperty = "YajHFC-FieldComboField";

    private JComboBox addFieldCombo(JPanel jPanel, String string, String string2, int n, int n2) {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jComboBox.putClientProperty(FIELD_ClientProperty, string);
        this.fieldCombos.add(jComboBox);
        this.settingsComponents.put(string, jComboBox);
        TableLayoutConstraints tableLayoutConstraints = new TableLayoutConstraints(n, n2);
        tableLayoutConstraints.hAlign = 2;
        tableLayoutConstraints.vAlign = 1;
        Utils.addWithLabelHorz(jPanel, jComboBox, string2, tableLayoutConstraints);
        return jComboBox;
    }

    private JComponent addAdditionalEntryField(JPanel jPanel, String string, FieldMapEntry fieldMapEntry, int n, int n2) {
        JComponent jComponent;
        if (fieldMapEntry.dataType.equals(Boolean.class)) {
            jComponent = new JCheckBox(fieldMapEntry.caption);
            jPanel.add((Component)jComponent, new TableLayoutConstraints(n - 2, n2, n, n2, 0, 1));
        } else if (fieldMapEntry.dataType.equals(String.class)) {
            jComponent = new JTextField();
            jComponent.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
            Utils.addWithLabelHorz(jPanel, (Component)jComponent, fieldMapEntry.caption, new TableLayoutConstraints(n, n2, n, n2, 2, 1));
        } else {
            throw new IllegalArgumentException("Unsupported data type for additional field.");
        }
        this.settingsComponents.put(string, jComponent);
        return jComponent;
    }

    private void initialize(String string) {
        int n = 0;
        int n2 = 0;
        for (FieldMapEntry fieldMapEntry : this.fieldNameMap.values()) {
            if (fieldMapEntry.isDataField) {
                ++n;
                continue;
            }
            ++n2;
        }
        int n3 = (n + 1) / 2 * 2;
        int n4 = (n2 + 1) / 2 * 2;
        int n5 = n3 + n4 + 18;
        double[][] dArrayArray = new double[][]{{10.0, -2.0, 10.0, 0.5, 10.0, -2.0, 10.0, -1.0, 10.0}, new double[n5]};
        double d = 1.0 / (double)(n5 - 5) * 2.0;
        for (int i = 0; i < n5; ++i) {
            dArrayArray[1][i] = (i & 1) == 0 ? 10.0 : d;
        }
        dArrayArray[1][n5 - 1] = -2.0;
        dArrayArray[1][n5 - 3] = -2.0;
        dArrayArray[1][11 + n4] = -2.0;
        TableLayout tableLayout = new TableLayout(dArrayArray);
        JPanel jPanel = new JPanel(tableLayout);
        this.textDriverClass = new JTextField();
        this.textDriverClass.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textURL = new JTextField();
        this.textURL.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textUserName = new JTextField();
        this.textUserName.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textPassword = new JPasswordField();
        this.comboTable = new JComboBox();
        this.comboTable.setEditable(true);
        this.comboTable.setActionCommand("tablesel");
        this.comboTable.addActionListener(this);
        this.checkAskForPassword = new JCheckBox(Utils._("Always ask"));
        this.checkAskForPassword.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ConnectionDialog.this.textPassword.setEnabled(!ConnectionDialog.this.checkAskForPassword.isSelected());
            }
        });
        CancelAction cancelAction = new CancelAction(this);
        this.buttonCancel = cancelAction.createCancelButton();
        this.buttonOK = new JButton(Utils._("OK"));
        this.buttonOK.setActionCommand("ok");
        this.buttonOK.addActionListener(this);
        this.buttonTest = new JButton(Utils._("Test connection"));
        this.buttonTest.setActionCommand("test");
        this.buttonTest.addActionListener(this);
        Utils.addWithLabelHorz(jPanel, (Component)this.textDriverClass, Utils._("Driver class:"), "3, 1, 7, 1, f, c");
        this.settingsComponents.put(DRIVER_FIELD, this.textDriverClass);
        Utils.addWithLabelHorz(jPanel, (Component)this.textURL, Utils._("Database URL:"), "3, 3, 7, 3, f, c");
        this.settingsComponents.put(DBURL_FIELD, this.textURL);
        Utils.addWithLabelHorz(jPanel, (Component)this.textUserName, Utils._("Username:"), "3, 5, 5, 5, f, c");
        this.settingsComponents.put(USER_FIELD, this.textUserName);
        jPanel.add((Component)this.buttonTest, "7, 5");
        Utils.addWithLabelHorz(jPanel, (Component)this.textPassword, Utils._("Password:"), "3, 7, 5, 7, f, c");
        this.settingsComponents.put(PASSWORD_FIELD, this.textPassword);
        jPanel.add((Component)this.checkAskForPassword, "7, 7");
        this.settingsComponents.put(ASKFORPWD_FIELD, this.checkAskForPassword);
        Utils.addWithLabelHorz(jPanel, (Component)this.comboTable, Utils._("Table:"), "3, 9, 7, 9, f, c");
        this.settingsComponents.put(TABLE_FIELD, this.comboTable);
        jPanel.add((Component)new JSeparator(0), new TableLayoutConstraints(0, 11 + n4, 8, 11 + n4));
        jPanel.add((Component)new JLabel(string), new TableLayoutConstraints(1, 13 + n4, 7, 13 + n4, 2, 1));
        for (Map.Entry<String, FieldMapEntry> entry : this.fieldNameMap.entrySet()) {
            String string2 = entry.getKey();
            if (this.settingsComponents.containsKey(string2)) continue;
            int n6 = entry.getValue().ordinalPosition;
            if (entry.getValue().isDataField) {
                this.addFieldCombo(jPanel, string2, entry.getValue().caption, 3 + 4 * (n6 % 2), 15 + n4 + 2 * (n6 / 2));
                continue;
            }
            this.addAdditionalEntryField(jPanel, string2, entry.getValue(), 3 + 4 * (n6 % 2), 11 + 2 * (n6 / 2));
        }
        Box box = new Box(2);
        box.add(Box.createHorizontalGlue());
        box.add(this.buttonOK);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.buttonCancel);
        box.add(Box.createHorizontalGlue());
        jPanel.add((Component)new JSeparator(0), new TableLayoutConstraints(0, n5 - 3, 8, n5 - 3));
        jPanel.add((Component)box, new TableLayoutConstraints(0, n5 - 1, 8, n5 - 1));
        this.setContentPane(jPanel);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                ConnectionDialog.this.closeConnection();
            }

            public void windowClosing(WindowEvent windowEvent) {
                ConnectionDialog.this.closeConnection();
            }
        });
        this.pack();
    }

    private boolean inputMaybeValid() {
        if (this.textDriverClass.getDocument().getLength() == 0) {
            JOptionPane.showMessageDialog(this, Utils._("You have to specify a driver class."), Utils._("Error"), 0);
            return false;
        }
        if (this.textURL.getDocument().getLength() == 0) {
            JOptionPane.showMessageDialog(this, Utils._("You have to specify a database URL."), Utils._("Error"), 0);
            return false;
        }
        return true;
    }

    private boolean testConnection() {
        if (!this.inputMaybeValid()) {
            return false;
        }
        this.closeConnection();
        try {
            PluginManager.registerJDBCDriver(this.textDriverClass.getText());
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog(this, Utils._("Could not load the specified driver class:"), exception);
            return false;
        }
        try {
            String string;
            Object object;
            if (this.checkAskForPassword.isSelected()) {
                object = PasswordDialog.showPasswordDialog(this, Utils._("Database password"), MessageFormat.format(Utils._("Please enter the database password (database: {0}):"), this.textURL.getText()), this.textUserName.getText(), false);
                if (object == null) {
                    return false;
                }
                string = object[1];
            } else {
                string = new String(this.textPassword.getPassword());
            }
            this.conn = DriverManager.getConnection(this.textURL.getText(), this.textUserName.getText(), string);
            object = this.conn.getMetaData();
            ResultSet resultSet = object.getTables(null, null, "%", new String[]{"TABLE", "VIEW"});
            Vector<String> vector = new Vector<String>();
            while (resultSet.next()) {
                vector.add(resultSet.getString("TABLE_NAME"));
            }
            resultSet.close();
            Object object2 = this.comboTable.getSelectedItem();
            this.comboTable.setModel(new DefaultComboBoxModel(vector));
            if (object2 != null && !object2.equals("")) {
                this.comboTable.setSelectedItem(object2);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog(this, Utils._("Could not connect to the database:"), exception);
            return false;
        }
        return this.loadFieldNames();
    }

    void closeConnection() {
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean loadFieldNames() {
        if (this.conn == null) {
            return false;
        }
        try {
            Vector<String> vector;
            Object object;
            if (this.comboTable.getSelectedItem() != null) {
                Statement statement = this.conn.createStatement();
                ResultSet object2 = statement.executeQuery("SELECT * FROM " + this.comboTable.getSelectedItem().toString());
                object = object2.getMetaData();
                vector = new Vector(object.getColumnCount() + 1);
                for (int i = 1; i <= object.getColumnCount(); ++i) {
                    vector.add(object.getColumnName(i));
                }
                Collections.sort(vector);
                object2.close();
                statement.close();
            } else {
                vector = new Vector<String>();
            }
            if (this.noFieldOK) {
                vector.add(0, ConnectionSettings.noField_translated);
            }
            for (JComboBox jComboBox : this.fieldCombos) {
                object = jComboBox.getSelectedItem();
                jComboBox.setModel(new DefaultComboBoxModel(vector));
                if (object == null || object.equals("")) continue;
                jComboBox.setSelectedItem(object);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog(this, Utils._("Could not get the field names:"), exception);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            if (!this.inputMaybeValid()) {
                return;
            }
            if (this.comboTable.getSelectedItem().toString().length() == 0) {
                JOptionPane.showMessageDialog(this, Utils._("You have to specify a database table."), Utils._("Error"), 0);
                return;
            }
            this.clickedOK = true;
            this.setVisible(false);
        } else if (string.equals("test")) {
            if (this.testConnection()) {
                JOptionPane.showMessageDialog(this, Utils._("Connection to the database succeeded."));
            }
        } else if (string.equals("tablesel")) {
            this.loadFieldNames();
        }
    }

    private void setFieldComboSel(JComboBox jComboBox, String string) {
        if (string.equals("<none>")) {
            string = ConnectionSettings.noField_translated;
        }
        jComboBox.setSelectedItem(string);
    }

    private String getFieldComboSel(JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        if (object.equals(ConnectionSettings.noField_translated)) {
            return "<none>";
        }
        return (String)object;
    }

    private void readFromConnectionSettings(AbstractConnectionSettings abstractConnectionSettings) {
        for (Map.Entry<String, Component> entry : this.settingsComponents.entrySet()) {
            try {
                Component component = entry.getValue();
                if (component instanceof JComboBox) {
                    JComboBox jComboBox = (JComboBox)component;
                    if (jComboBox.getClientProperty(FIELD_ClientProperty) != null) {
                        this.setFieldComboSel(jComboBox, (String)abstractConnectionSettings.getField(entry.getKey()));
                        continue;
                    }
                    jComboBox.setSelectedItem(abstractConnectionSettings.getField(entry.getKey()));
                    continue;
                }
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).setText((String)abstractConnectionSettings.getField(entry.getKey()));
                    continue;
                }
                if (component instanceof JCheckBox) {
                    ((JCheckBox)component).setSelected((Boolean)abstractConnectionSettings.getField(entry.getKey()));
                    continue;
                }
                log.warning("Unknown component type: " + component);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error reading values", exception);
            }
        }
    }

    private void writeToConnectionSettings(AbstractConnectionSettings abstractConnectionSettings) {
        for (Map.Entry<String, Component> entry : this.settingsComponents.entrySet()) {
            try {
                Component component = entry.getValue();
                if (component instanceof JComboBox) {
                    JComboBox jComboBox = (JComboBox)component;
                    if (jComboBox.getClientProperty(FIELD_ClientProperty) != null) {
                        abstractConnectionSettings.setField(entry.getKey(), this.getFieldComboSel(jComboBox));
                        continue;
                    }
                    abstractConnectionSettings.setField(entry.getKey(), jComboBox.getSelectedItem());
                    continue;
                }
                if (component instanceof JTextComponent) {
                    abstractConnectionSettings.setField(entry.getKey(), ((JTextComponent)component).getText());
                    continue;
                }
                if (component instanceof JCheckBox) {
                    abstractConnectionSettings.setField(entry.getKey(), ((JCheckBox)component).isSelected());
                    continue;
                }
                log.warning("Unknown component type: " + component);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error saving values", exception);
            }
        }
    }

    public ConnectionDialog(Frame frame, String string, String string2, Map<String, FieldMapEntry> map, boolean bl) {
        super(frame, string);
        this.noFieldOK = bl;
        this.fieldNameMap = map;
        this.initialize(string2);
    }

    public ConnectionDialog(Dialog dialog, String string, String string2, Map<String, FieldMapEntry> map, boolean bl) {
        super(dialog, string);
        this.noFieldOK = bl;
        this.fieldNameMap = map;
        this.initialize(string2);
    }

    public boolean promptForNewSettings(AbstractConnectionSettings abstractConnectionSettings) {
        this.readFromConnectionSettings(abstractConnectionSettings);
        this.clickedOK = false;
        this.setVisible(true);
        if (this.clickedOK) {
            this.writeToConnectionSettings(abstractConnectionSettings);
        }
        this.dispose();
        return this.clickedOK;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldMapEntry {
        public final String caption;
        public final int ordinalPosition;
        public final boolean isDataField;
        public final Class<?> dataType;

        public FieldMapEntry(String string, int n) {
            this(string, n, true, String.class);
        }

        public FieldMapEntry(String string, int n, boolean bl, Class<?> clazz) {
            this.caption = string;
            this.isDataField = bl;
            this.ordinalPosition = n;
            this.dataType = clazz;
        }
    }
}

