/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.srfax;

import com.google.gson.JsonObject;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import yajhfc.Utils;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.PhoneBookException;
import yajhfc.phonebook.srfax.ConnectionDialog;
import yajhfc.phonebook.srfax.ConnectionSettings;
import yajhfc.phonebook.srfax.SRFaxPhoneBookEntry;
import yajhfc.util.SRFaxAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRFaxPhoneBook
extends PhoneBook {
    private static final Logger log = Logger.getLogger(SRFaxPhoneBook.class.getName());
    ConnectionSettings settings;
    boolean open = false;
    protected boolean wasChanged = false;
    List<SRFaxPhoneBookEntry> items = new ArrayList<SRFaxPhoneBookEntry>();
    List<SRFaxPhoneBookEntry> deleted_items = new ArrayList<SRFaxPhoneBookEntry>();
    List<PhoneBookEntry> itemsView = new ArrayList<PhoneBookEntry>();
    int[] maxLength = new int[PBEntryField.FIELD_COUNT];
    protected static final Map<String, ConnectionDialog.FieldMapEntry> fieldNameMap = new HashMap<String, ConnectionDialog.FieldMapEntry>();
    public static final String PB_Prefix = "SRFax";
    public static final String PB_DisplayName;
    public static final String PB_Description;

    public SRFaxPhoneBook(Dialog dialog) {
        super(dialog);
    }

    @Override
    public PhoneBookEntry addNewEntry() {
        String[] stringArray = new String[]{"YajHFC", "", "00000000000"};
        stringArray[1] = JOptionPane.showInputDialog(this.parentDialog, (Object)Utils._("Contact Name:"));
        stringArray[2] = JOptionPane.showInputDialog(this.parentDialog, (Object)Utils._("Fax number (11 digits):"));
        SRFaxPhoneBookEntry sRFaxPhoneBookEntry = new SRFaxPhoneBookEntry(this, stringArray);
        this.items.add(sRFaxPhoneBookEntry);
        this.fireEntriesAdded(this.items.size() - 1, sRFaxPhoneBookEntry);
        this.wasChanged = true;
        return sRFaxPhoneBookEntry;
    }

    @Override
    public String browseForPhoneBook(boolean bl) {
        ConnectionSettings connectionSettings = new ConnectionSettings(this.settings);
        ConnectionDialog connectionDialog = new ConnectionDialog(this.parentDialog, Utils._("New SRFax phone book"), fieldNameMap, true);
        if (connectionDialog.promptForNewSettings(connectionSettings)) {
            return "SRFax:" + connectionSettings.saveToString();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        int n = 0;
        while (n < this.items.size()) {
            SRFaxPhoneBookEntry sRFaxPhoneBookEntry = this.items.get(n);
            if (sRFaxPhoneBookEntry.dirty) {
                JsonObject jsonObject;
                try {
                    jsonObject = SRFaxAPI.sendPost("Remove_From_AddressBook&sFaxNumber=" + sRFaxPhoneBookEntry.columnData[2] + "&sGroupName=" + sRFaxPhoneBookEntry.columnData[0], this.settings.user, this.settings.pwd.getPassword());
                    if (jsonObject.get("Status").getAsString().compareTo("Success") == 0) {
                        // empty if block
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    jsonObject = SRFaxAPI.sendPost("Add_To_AddressBook&sFaxNumber=" + sRFaxPhoneBookEntry.columnData[2] + "&sGroupName=" + sRFaxPhoneBookEntry.columnData[0] + "&sContactName=" + sRFaxPhoneBookEntry.columnData[1], this.settings.user, this.settings.pwd.getPassword());
                    if (jsonObject.get("Status").getAsString().compareTo("Success") != 0) {
                        JOptionPane.showMessageDialog(this.parentDialog, jsonObject.get("Result").getAsString(), Utils._("Error"), 0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
        return;
    }

    @Override
    protected void openInternal(String string) throws PhoneBookException {
        this.settings = new ConnectionSettings(string);
        JsonObject jsonObject = null;
        try {
            jsonObject = SRFaxAPI.sendPost("Get_Address_Book", this.settings.user, this.settings.pwd.getPassword());
        }
        catch (Exception exception) {
            return;
        }
        if (jsonObject.get("Status").getAsString().compareTo("Success") == 0) {
            String string2 = jsonObject.get("Result").getAsString();
            this.loadItems(string2);
            this.open = true;
            return;
        }
    }

    protected void loadItems(String string) {
        this.deleted_items.clear();
        this.items.clear();
        this.itemsView.clear();
        if (string.isEmpty()) {
            return;
        }
        String[] stringArray = string.split("\\\\r\\\\n");
        for (int i = 0; i < stringArray.length; ++i) {
            SRFaxPhoneBookEntry sRFaxPhoneBookEntry = new SRFaxPhoneBookEntry(this, stringArray[i].replaceAll("^\"|\"$", "").split("\"\\|\""));
            this.items.add(sRFaxPhoneBookEntry);
            this.itemsView.add(sRFaxPhoneBookEntry);
        }
    }

    void updatePosition(SRFaxPhoneBookEntry sRFaxPhoneBookEntry) {
        int n = Utils.identityIndexOf(this.items, sRFaxPhoneBookEntry);
        this.fireEntriesChanged(n, sRFaxPhoneBookEntry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void deleteEntry(SRFaxPhoneBookEntry sRFaxPhoneBookEntry) {
        int n = Utils.identityIndexOf(this.items, sRFaxPhoneBookEntry);
        if (n >= 0) {
            try {
                JsonObject jsonObject = SRFaxAPI.sendPost("Remove_From_AddressBook&sFaxNumber=" + sRFaxPhoneBookEntry.getField(PBEntryField.FaxNumber), this.settings.user, this.settings.pwd.getPassword());
                if (jsonObject.get("Status").getAsString().compareTo("Success") == 0) {
                    // empty if block
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.items.remove(n);
            this.fireEntriesRemoved(n, sRFaxPhoneBookEntry);
        }
    }

    void writeEntry(PhoneBookEntry phoneBookEntry) {
        int n = Utils.identityIndexOf(this.items, phoneBookEntry);
        this.fireEntriesChanged(n, phoneBookEntry);
        this.wasChanged = true;
    }

    @Override
    public List<PhoneBookEntry> getEntries() {
        return this.itemsView;
    }

    @Override
    public String getDisplayCaption() {
        if (this.settings.displayCaption != null && this.settings.displayCaption.length() > 0) {
            return this.settings.displayCaption;
        }
        return "[SRFax] " + this.settings.user;
    }

    @Override
    public boolean isFieldAvailable(PBEntryField pBEntryField) {
        switch (pBEntryField) {
            case FaxNumber: {
                return true;
            }
            case GivenName: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean supportsDistributionLists() {
        return false;
    }

    static {
        fieldNameMap.put("displayCaption", new ConnectionDialog.FieldMapEntry(Utils._("Phone book name to display:"), 2, false, String.class));
        PB_DisplayName = Utils._("SRFax phone book");
        PB_Description = Utils._("The phone book in your SRFax account.");
    }
}

