/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import yajhfc.Utils;
import yajhfc.phonebook.DistributionList;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.ui.NewPhoneBookWin;
import yajhfc.phonebook.ui.PBEntryFieldTableModel;
import yajhfc.phonebook.ui.PhoneBookTableModel;
import yajhfc.phonebook.ui.PhonebookPanel;
import yajhfc.util.CancelAction;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.JTableTABAction;
import yajhfc.util.LimitedPlainDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionListPhonebookPanel
extends PhonebookPanel {
    private static final Logger log = Logger.getLogger(DistributionListPhonebookPanel.class.getName());
    protected PhoneBookTableModel tableModel;
    protected JTable entryTable;
    protected JTextField nameField;
    protected JLabel tableLabel;
    protected Action actAddNewItem;
    protected Action actRemoveItem;
    protected Action actAddExistingItem;
    protected JButton[] distListButtons;
    protected JButton createDistListButton;
    protected DistributionList listToEdit = null;
    protected final List<PhoneBookEntry> selectedRows = new ArrayList<PhoneBookEntry>();
    protected ExistingItemDialog existingItemDialog;

    public DistributionListPhonebookPanel(NewPhoneBookWin newPhoneBookWin) {
        super(newPhoneBookWin, null, false);
        this.createActions();
        double[][] dArrayArray = new double[][]{{-1.0, 5.0, 0.3333333333333333, 5.0, 0.3333333333333333}, {-2.0, -2.0, 5.0, -2.0, -1.0, -2.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.nameField = this.createEntryTextField(PBEntryField.Name);
        this.tableModel = new PhoneBookTableModel(null);
        this.entryTable = new JTable(this.tableModel);
        this.entryTable.setSelectionMode(2);
        this.entryTable.setAutoResizeMode(0);
        JTableTABAction.wrapDefTabAction(this.entryTable);
        this.entryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (DistributionListPhonebookPanel.this.listToEdit != null) {
                        int[] nArray = DistributionListPhonebookPanel.this.entryTable.getSelectedRows();
                        DistributionListPhonebookPanel.this.selectedRows.clear();
                        for (int n : nArray) {
                            DistributionListPhonebookPanel.this.selectedRows.add(DistributionListPhonebookPanel.this.listToEdit.getEntries().get(n));
                        }
                    }
                    DistributionListPhonebookPanel.this.checkEnable();
                }
            }
        });
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actAddNewItem);
        jPopupMenu.add(this.actAddExistingItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actRemoveItem);
        this.entryTable.setComponentPopupMenu(jPopupMenu);
        this.createDistListButton = new JButton(newPhoneBookWin.addDistListAction);
        this.createDistListButton.setText(Utils._("Create new distribution list from selection"));
        this.createDistListButton.setVisible(false);
        Utils.addWithLabel((JPanel)this, (Component)this.nameField, Utils._("Name") + ":", "0,1,4,1");
        this.tableLabel = Utils.addWithLabel((JPanel)this, (Component)new JScrollPane(this.entryTable), "Dummy", "0,4,4,4");
        this.distListButtons = new JButton[3];
        this.distListButtons[0] = new JButton(this.actAddNewItem);
        this.add((Component)this.distListButtons[0], "0,5");
        this.distListButtons[1] = new JButton(this.actAddExistingItem);
        this.add((Component)this.distListButtons[1], "2,5");
        this.distListButtons[2] = new JButton(this.actRemoveItem);
        this.add((Component)this.distListButtons[2], "4,5");
        this.add((Component)this.createDistListButton, "0,5,4,5");
        this.checkEnable();
    }

    private void createActions() {
        this.actAddNewItem = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                PhoneBook phoneBook = DistributionListPhonebookPanel.this.getCurrentPhoneBook();
                if (DistributionListPhonebookPanel.this.listToEdit == null || phoneBook == null || phoneBook.isReadOnly()) {
                    return;
                }
                int n = DistributionListPhonebookPanel.this.listToEdit.getEntries().indexOf(DistributionListPhonebookPanel.this.listToEdit.addNewEntry());
                DistributionListPhonebookPanel.this.entryTable.getSelectionModel().setSelectionInterval(n, n);
            }
        };
        this.actAddNewItem.putValue("Name", Utils._("Add new item"));
        this.actAddNewItem.putValue("SmallIcon", Utils.loadIcon("general/New"));
        this.actAddNewItem.putValue("ShortDescription", Utils._("Add a new entry to the distribution list"));
        this.actAddNewItem.setEnabled(false);
        this.actAddExistingItem = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                PhoneBook phoneBook = DistributionListPhonebookPanel.this.getCurrentPhoneBook();
                if (DistributionListPhonebookPanel.this.listToEdit == null || phoneBook == null || phoneBook.isReadOnly()) {
                    return;
                }
                if (DistributionListPhonebookPanel.this.existingItemDialog == null || !DistributionListPhonebookPanel.this.existingItemDialog.isVisible()) {
                    DistributionListPhonebookPanel.this.existingItemDialog = new ExistingItemDialog();
                    DistributionListPhonebookPanel.this.existingItemDialog.setVisible(true);
                } else {
                    DistributionListPhonebookPanel.this.existingItemDialog.toFront();
                }
            }
        };
        this.actAddExistingItem.putValue("Name", Utils._("Add existing item"));
        this.actAddExistingItem.putValue("SmallIcon", Utils.loadIcon("general/Add"));
        this.actAddExistingItem.putValue("ShortDescription", Utils._("Add an existing phone book entry to the distribution list"));
        this.actAddExistingItem.setEnabled(false);
        this.actRemoveItem = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                if (DistributionListPhonebookPanel.this.selectedRows.size() == 0) {
                    return;
                }
                if (JOptionPane.showConfirmDialog(DistributionListPhonebookPanel.this.parent, Utils._("Do you want to delete the selected entries?"), Utils._("Delete entries"), 0) == 0) {
                    for (PhoneBookEntry phoneBookEntry : DistributionListPhonebookPanel.this.selectedRows.toArray(new PhoneBookEntry[DistributionListPhonebookPanel.this.selectedRows.size()])) {
                        phoneBookEntry.delete();
                    }
                }
            }
        };
        this.actRemoveItem.putValue("Name", Utils._("Delete"));
        this.actRemoveItem.putValue("SmallIcon", Utils.loadIcon("general/Delete"));
        this.actRemoveItem.putValue("ShortDescription", Utils._("Delete selected entry"));
        this.actRemoveItem.setEnabled(false);
    }

    void checkEnable() {
        PhoneBook phoneBook = this.getCurrentPhoneBook();
        boolean bl = this.listToEdit != null && phoneBook != null && !phoneBook.isReadOnly();
        boolean bl2 = this.selectedRows.size() > 0;
        boolean bl3 = bl && bl2;
        this.actAddExistingItem.setEnabled(bl);
        this.actAddNewItem.setEnabled(bl);
        this.actRemoveItem.setEnabled(bl3);
    }

    PhoneBook getCurrentPhoneBook() {
        return this.listToEdit == null ? null : this.listToEdit.getParent();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl && this.existingItemDialog != null) {
            this.existingItemDialog.dispose();
            this.existingItemDialog = null;
            this.tableModel.setPhoneBook(null);
        }
    }

    @Override
    public void readFromTextFields(PhoneBookEntry phoneBookEntry, boolean bl) {
        if (phoneBookEntry.getParent().isReadOnly()) {
            return;
        }
        if (phoneBookEntry != this.listToEdit) {
            log.warning("pb != listToEdit");
        }
        if (phoneBookEntry instanceof DistributionList) {
            if (this.entryTable.isEditing()) {
                this.entryTable.getCellEditor().stopCellEditing();
            }
            phoneBookEntry.setField(PBEntryField.Name, this.nameField.getText());
            phoneBookEntry.commit();
        } else {
            log.severe("No distribution list specified in readFromTextFields!");
        }
    }

    @Override
    public void writeToTextFields(PhoneBook phoneBook, PhoneBookEntry phoneBookEntry) {
        if (phoneBookEntry instanceof DistributionList) {
            if (this.existingItemDialog != null) {
                this.existingItemDialog.dispose();
                this.existingItemDialog = null;
            }
            this.listToEdit = (DistributionList)phoneBookEntry;
            boolean bl = !phoneBook.isReadOnly();
            this.tableModel.setPhoneBook(this.listToEdit);
            this.tableModel.setEditable(bl);
            this.entryTable.setModel(this.tableModel);
            this.nameField.setText(phoneBookEntry.getField(PBEntryField.Name));
            this.nameField.setEditable(bl);
            ((LimitedPlainDocument)this.nameField.getDocument()).setLimit(phoneBook.getMaxLength(PBEntryField.Name));
            this.configureUI(true);
            this.checkEnable();
        } else {
            log.severe("No distribution list specified in writeToTextFields!");
        }
    }

    private void configureUI(boolean bl) {
        this.tableLabel.setText(bl ? Utils._("Items in the distribution list:") : Utils._("Items in the current selection:"));
        if (this.createDistListButton.isVisible() == bl) {
            for (JButton jButton : this.distListButtons) {
                jButton.setVisible(bl);
            }
            this.createDistListButton.setVisible(!bl);
        }
    }

    public void showMultiSelection(PhoneBook phoneBook, List<PhoneBookEntry> list) {
        if (this.existingItemDialog != null) {
            this.existingItemDialog.dispose();
            this.existingItemDialog = null;
        }
        this.listToEdit = null;
        PBEntryFieldTableModel pBEntryFieldTableModel = new PBEntryFieldTableModel(Collections.unmodifiableList(NewPhoneBookWin.resolveDistributionLists(list)));
        pBEntryFieldTableModel.setEditable(false);
        this.entryTable.setModel(pBEntryFieldTableModel);
        this.nameField.setEditable(false);
        this.nameField.setText("<" + Utils._("Current selection") + ">");
        this.configureUI(false);
        this.checkEnable();
    }

    protected class ExistingItemDialog
    extends JDialog
    implements TreeSelectionListener {
        private Action addAction;
        List<PhoneBookEntry> selItems;
        private JTree itemsTree;

        public ExistingItemDialog() {
            super((Dialog)DistributionListPhonebookPanel.this.parent, Utils._("Items to add"));
            this.selItems = new ArrayList<PhoneBookEntry>();
            double[][] dArrayArray = new double[][]{{-1.0}, {-2.0, -1.0, 5.0, -2.0, -2.0}};
            JPanel jPanel = new JPanel(new TableLayout(dArrayArray));
            this.itemsTree = new JTree(DistributionListPhonebookPanel.this.parent.treeModel);
            this.itemsTree.setEditable(false);
            this.itemsTree.setRootVisible(true);
            this.itemsTree.getSelectionModel().setSelectionMode(4);
            this.itemsTree.setCellRenderer(DistributionListPhonebookPanel.this.parent.phoneBookRenderer);
            this.itemsTree.addTreeSelectionListener(this);
            this.addAction = new ExcDialogAbstractAction(){

                public void actualActionPerformed(ActionEvent actionEvent) {
                    if (DistributionListPhonebookPanel.this.listToEdit != null) {
                        DistributionListPhonebookPanel.this.listToEdit.addEntries(NewPhoneBookWin.resolveDistributionLists(ExistingItemDialog.this.selItems));
                    }
                }
            };
            this.addAction.putValue("Name", Utils._("Add"));
            this.addAction.putValue("SmallIcon", Utils.loadIcon("general/Add"));
            this.addAction.putValue("ShortDescription", Utils._("Add the selected entry to the distribution list"));
            this.addAction.setEnabled(false);
            CancelAction cancelAction = new CancelAction(this, Utils._("Close"));
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.addAction);
            this.itemsTree.setComponentPopupMenu(jPopupMenu);
            jPanel.add((Component)new JLabel("<html>" + Utils._("Please select the items to add to the distribution list:") + "</html>"), "0,0");
            jPanel.add((Component)new JScrollPane(this.itemsTree), "0,1");
            jPanel.add((Component)new JButton(this.addAction), "0,3");
            jPanel.add((Component)cancelAction.createCancelButton(), "0,4");
            this.setContentPane(jPanel);
            this.setResizable(true);
            this.pack();
            Rectangle rectangle = this.getGraphicsConfiguration().getBounds();
            this.setLocation(rectangle.x + rectangle.width - this.getWidth(), rectangle.y + (rectangle.height - this.getHeight()) / 2);
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath[] treePathArray = this.itemsTree.getSelectionPaths();
            this.selItems.clear();
            if (treePathArray != null && treePathArray.length > 0) {
                for (TreePath treePath : treePathArray) {
                    if (treePath.getPathCount() != 3) continue;
                    this.selItems.add((PhoneBookEntry)treePath.getPathComponent(2));
                }
            }
            this.addAction.setEnabled(this.selItems.size() > 0);
        }
    }
}

