/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.ui;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextField;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.ui.NewPhoneBookWin;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.LimitedPlainDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhonebookPanel
extends JPanel {
    protected NewPhoneBookWin parent;
    protected EntryTextFieldListener entryListener = new EntryTextFieldListener();
    protected static final String PBFIELD_PROP = "YajHFC-PBEntryfield";

    public abstract void writeToTextFields(PhoneBook var1, PhoneBookEntry var2);

    public abstract void readFromTextFields(PhoneBookEntry var1, boolean var2);

    protected JTextField createEntryTextField(PBEntryField pBEntryField) {
        JTextField jTextField = new JTextField(new LimitedPlainDocument(0), "", 0);
        jTextField.addFocusListener(this.entryListener);
        jTextField.addActionListener(this.entryListener);
        jTextField.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        jTextField.putClientProperty(PBFIELD_PROP, pBEntryField);
        return jTextField;
    }

    protected List<PhoneBookEntry> getSelectedItems() {
        return this.parent.selectedItems;
    }

    public PhonebookPanel(NewPhoneBookWin newPhoneBookWin, LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
        this.parent = newPhoneBookWin;
    }

    protected class EntryTextFieldListener
    implements ActionListener,
    FocusListener {
        protected EntryTextFieldListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.updateListEntries();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.updateListEntries();
        }

        private void updateListEntries() {
            List<PhoneBookEntry> list = PhonebookPanel.this.getSelectedItems();
            if (PhonebookPanel.this.isVisible() && list.size() == 1) {
                PhonebookPanel.this.readFromTextFields(list.get(0), true);
            }
        }
    }
}

