/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.print;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import java.util.Date;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.IconMap;
import yajhfc.model.TableType;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.table.FaxListTableModel;
import yajhfc.model.ui.TooltipJTable;
import yajhfc.print.StatusDialogPrintable;
import yajhfc.print.tableprint.Alignment;
import yajhfc.print.tableprint.DefaultCellFormatModel;
import yajhfc.print.tableprint.IconMapCellRenderer;
import yajhfc.print.tableprint.TablePrintColumn;
import yajhfc.print.tableprint.TablePrintable;
import yajhfc.util.CancelAction;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.TableSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaxTablePrinter
extends JDialog {
    static final String COLUMN_WIDTH_AUTO = Utils._("Fit to contents");
    static final String COLUMN_WIDTH_USER = Utils._("Same as on screen");
    private static final int border = 6;
    JComboBox comboColumnWidths;
    JCheckBox checkMarkUnreadFaxes;
    JCheckBox checkMarkErrors;
    boolean showUnreadOptions;
    Action okAction;
    boolean modalResult = false;

    protected FaxTablePrinter(Frame frame, TooltipJTable<? extends FmtItem> tooltipJTable, String string, boolean bl) {
        super(frame, MessageFormat.format(Utils._("Print {0}"), string), true);
        this.showUnreadOptions = bl;
        this.initialize();
    }

    private void initialize() {
        this.okAction = new ExcDialogAbstractAction(Utils._("Print")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                FaxTablePrinter.this.modalResult = true;
                FaxOptions faxOptions = Utils.getFaxOptions();
                faxOptions.faxprintColumnWidthAsOnScreen = FaxTablePrinter.this.comboColumnWidths.getSelectedItem() == COLUMN_WIDTH_USER;
                faxOptions.faxprintMarkErrors = FaxTablePrinter.this.checkMarkErrors.isSelected();
                if (FaxTablePrinter.this.showUnreadOptions) {
                    faxOptions.faxprintMarkUnread = FaxTablePrinter.this.checkMarkUnreadFaxes.isSelected();
                }
                FaxTablePrinter.this.dispose();
            }
        };
        CancelAction cancelAction = new CancelAction(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new TableLayout(new double[][]{{6.0, -1.0, -2.0, 6.0, -2.0, -1.0, 6.0}, {6.0, -2.0, -2.0, this.showUnreadOptions ? 6.0 : 0.0, this.showUnreadOptions ? -2.0 : 0.0, 6.0, -2.0, 3.0, -2.0, 3.0, -2.0, 6.0}}));
        FaxOptions faxOptions = Utils.getFaxOptions();
        this.comboColumnWidths = new JComboBox<Object>(new Object[]{COLUMN_WIDTH_AUTO, COLUMN_WIDTH_USER});
        this.comboColumnWidths.setSelectedIndex(faxOptions.faxprintColumnWidthAsOnScreen ? 1 : 0);
        if (this.showUnreadOptions) {
            this.checkMarkUnreadFaxes = new JCheckBox(Utils._("Use a bold font for unread faxes"));
            this.checkMarkUnreadFaxes.setSelected(faxOptions.faxprintMarkUnread);
        }
        this.checkMarkErrors = new JCheckBox(Utils._("Mark failed jobs"));
        this.checkMarkErrors.setSelected(faxOptions.faxprintMarkErrors);
        Utils.addWithLabel(jPanel, (Component)this.comboColumnWidths, Utils._("Column widths:"), "1,2,5,2");
        if (this.showUnreadOptions) {
            jPanel.add((Component)this.checkMarkUnreadFaxes, "1,4,5,4");
        }
        jPanel.add((Component)this.checkMarkErrors, "1,6,5,6");
        jPanel.add((Component)new JSeparator(), "0,8,6,8");
        jPanel.add((Component)new JButton(this.okAction), "2,10");
        jPanel.add((Component)cancelAction.createCancelButton(), "4,10");
        this.setContentPane(jPanel);
        this.setDefaultCloseOperation(2);
        this.pack();
        Utils.setDefWinPos(this);
    }

    public static TablePrintable getFaxTablePrintable(Frame frame, TooltipJTable<? extends FmtItem> tooltipJTable, String string) {
        Object object;
        Object object2;
        FaxOptions faxOptions = Utils.getFaxOptions();
        TableModel tableModel = tooltipJTable.getModel();
        FaxListTableModel<? extends FmtItem> faxListTableModel = tooltipJTable.getRealModel();
        boolean bl = faxListTableModel.getTableType() == TableType.RECEIVED;
        FaxTablePrinter faxTablePrinter = new FaxTablePrinter(frame, tooltipJTable, string, bl);
        faxTablePrinter.setVisible(true);
        if (!faxTablePrinter.modalResult) {
            return null;
        }
        TablePrintable tablePrintable = new TablePrintable(tableModel);
        tablePrintable.getPageHeader().put(Alignment.CENTER, new MessageFormat("'" + string + "'"));
        if (faxOptions.faxprintMarkErrors || bl && faxOptions.faxprintMarkUnread) {
            Color color = null;
            if (faxOptions.faxprintMarkErrors) {
                color = faxListTableModel.getErrorColor();
            }
            object2 = null;
            if (bl && faxOptions.faxprintMarkUnread) {
                object2 = tablePrintable.getTableFont().deriveFont(1);
            }
            tablePrintable.setFormatModel(new FaxCellFormatModel(color, (Font)object2));
        }
        if (faxOptions.faxprintColumnWidthAsOnScreen) {
            for (int i = 0; i < tooltipJTable.getColumnCount(); ++i) {
                object2 = tablePrintable.getColumnLayout().getHeaderLayout()[i];
                object = tooltipJTable.getColumnModel().getColumn(i);
                ((TablePrintColumn)object2).setWidth(((TableColumn)object).getWidth());
            }
        }
        for (int i = 0; i < tooltipJTable.getColumnCount(); ++i) {
            int n = tooltipJTable.getColumnModel().getColumn(i).getModelIndex();
            object = (FmtItem)faxListTableModel.getColumns().get(n);
            if (object.getDataType() != Date.class) continue;
            tablePrintable.getColumnLayout().getHeaderLayout()[i].setColumnFormat(object.getDisplayDateFormat());
        }
        tablePrintable.getRendererMap().put(IconMap.class, new IconMapCellRenderer());
        return tablePrintable;
    }

    public static void printFaxTable(Frame frame, TooltipJTable<? extends FmtItem> tooltipJTable, String string) {
        try {
            TablePrintable tablePrintable = FaxTablePrinter.getFaxTablePrintable(frame, tooltipJTable, string);
            if (tablePrintable == null) {
                return;
            }
            FaxOptions faxOptions = Utils.getFaxOptions();
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            if (faxOptions.printAttributes == null) {
                hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
            } else {
                for (Attribute attribute : faxOptions.printAttributes) {
                    hashPrintRequestAttributeSet.add(attribute);
                }
            }
            if (StatusDialogPrintable.printWithDialog(frame, tablePrintable, hashPrintRequestAttributeSet)) {
                faxOptions.printAttributes = hashPrintRequestAttributeSet.toArray();
            }
        }
        catch (PrinterException printerException) {
            ExceptionDialog.showExceptionDialog(frame, Utils._("Error printing the table:"), printerException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FaxCellFormatModel
    extends DefaultCellFormatModel {
        protected Color errorBackground;
        protected Font unreadFont;

        protected FaxJob<? extends FmtItem> getJob(TableModel tableModel, int n) {
            FaxListTableModel faxListTableModel;
            if (tableModel instanceof TableSorter) {
                TableSorter tableSorter = (TableSorter)tableModel;
                faxListTableModel = (FaxListTableModel)tableSorter.getTableModel();
                n = tableSorter.modelIndex(n);
            } else if (tableModel instanceof FaxListTableModel) {
                faxListTableModel = (FaxListTableModel)tableModel;
            } else {
                return null;
            }
            return faxListTableModel.getJob(n);
        }

        @Override
        public Color getCellBackgroundColor(TablePrintColumn tablePrintColumn, TableModel tableModel, int n) {
            FaxJob<? extends FmtItem> faxJob;
            if (this.errorBackground != null && (faxJob = this.getJob(tableModel, n)).isError()) {
                return this.errorBackground;
            }
            return super.getCellBackgroundColor(tablePrintColumn, tableModel, n);
        }

        @Override
        public Font getCellFont(TablePrintColumn tablePrintColumn, TableModel tableModel, int n) {
            FaxJob<? extends FmtItem> faxJob;
            if (this.unreadFont != null && (faxJob = this.getJob(tableModel, n)).isRead()) {
                return this.unreadFont;
            }
            return super.getCellFont(tablePrintColumn, tableModel, n);
        }

        public FaxCellFormatModel(Color color, Font font) {
            this.errorBackground = color;
            this.unreadFont = font;
        }
    }
}

