/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.print;

import java.awt.Graphics2D;
import javax.swing.table.TableModel;
import yajhfc.phonebook.DistributionList;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.ui.PBEntryFieldTableModel;
import yajhfc.print.tableprint.SimpleColumnLayout;
import yajhfc.print.tableprint.TablePrintColumn;
import yajhfc.print.tableprint.TablePrintable;

public class PhoneBookColumnLayout
extends SimpleColumnLayout {
    protected PBEntryFieldTableModel model;
    protected TablePrintColumn[] filteredColumns;
    protected TablePrintColumn[] distListColumns;
    protected PBEntryField[] filter;
    private boolean calcDistLists;

    private void applyFilter2(PBEntryField[] pBEntryFieldArray) {
        if (this.tableColumns == null) {
            return;
        }
        if (pBEntryFieldArray == null) {
            this.filteredColumns = this.tableColumns;
        } else {
            this.filteredColumns = new TablePrintColumn[pBEntryFieldArray.length];
            for (int i = 0; i < pBEntryFieldArray.length; ++i) {
                this.filteredColumns[i] = this.getColumnFor(pBEntryFieldArray[i]);
            }
        }
    }

    public void applyFilter(PBEntryField[] pBEntryFieldArray) {
        this.filter = pBEntryFieldArray;
        this.applyFilter2(pBEntryFieldArray);
    }

    public void initializeLayout(TablePrintable tablePrintable, TableModel tableModel) {
        super.initializeLayout(tablePrintable, tableModel);
        this.model = (PBEntryFieldTableModel)tableModel;
        this.applyFilter2(this.filter);
        this.distListColumns = new TablePrintColumn[]{new TablePrintColumn(tablePrintable, this.model.indexOfField(PBEntryField.Name)), new DistListColumn(tablePrintable)};
    }

    public TablePrintColumn getColumnFor(PBEntryField pBEntryField) {
        return this.tableColumns[this.model.indexOfField(pBEntryField)];
    }

    public TablePrintColumn getDistListColumn(boolean bl) {
        return this.distListColumns[bl ? 0 : 1];
    }

    public TablePrintColumn[] getTableColumns() {
        return this.filteredColumns;
    }

    protected boolean useForPreferredWidth(TablePrintColumn tablePrintColumn, int n) {
        if (this.model.getRow(n) instanceof DistributionList) {
            return this.calcDistLists;
        }
        return !this.calcDistLists;
    }

    public void calculateColumnWidths(Graphics2D graphics2D, double d, double d2) {
        this.calcDistLists = false;
        double d3 = this.calculateColumnWidth(graphics2D, this.filteredColumns, d, d2);
        this.calcDistLists = true;
        double d4 = this.calculateColumnWidth(graphics2D, this.distListColumns, Math.max(d, d3), d2);
        this.tableWidth = Math.max(d3, d4);
    }

    public TablePrintColumn[] getLayoutForRow(int n) {
        if (this.model.getRow(n) instanceof DistributionList) {
            return this.distListColumns;
        }
        return this.filteredColumns;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DistListColumn
    extends TablePrintColumn {
        public DistListColumn(TablePrintable tablePrintable) {
            super(tablePrintable, -1);
            this.width = -2.0f;
        }

        @Override
        protected Class<?> getColumnClass() {
            return DistributionList.class;
        }

        @Override
        public Object getData(int n) {
            return ((PBEntryFieldTableModel)this.parent.getModel()).getRow(n);
        }

        @Override
        public String getHeaderText() {
            return "Dummy";
        }
    }
}

