/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.print.tableprint;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import yajhfc.print.tableprint.TableCellRenderer;
import yajhfc.print.tableprint.TablePrintColumn;

public class BooleanRenderer
implements TableCellRenderer {
    private static final double scaleScale = 0.8;
    protected Shape checkedShape;
    protected Shape uncheckedShape;

    protected Shape getCheckedShape() {
        if (this.checkedShape == null) {
            GeneralPath generalPath = new GeneralPath(1);
            generalPath.moveTo(1.84375f, -14.578125f);
            generalPath.lineTo(16.09375f, -14.578125f);
            generalPath.lineTo(16.15625f, -14.515625f);
            generalPath.lineTo(16.15625f, -0.0625f);
            generalPath.lineTo(16.09375f, 0.0f);
            generalPath.lineTo(1.84375f, 0.0f);
            generalPath.lineTo(1.78125f, -0.0625f);
            generalPath.lineTo(1.78125f, -14.515625f);
            generalPath.lineTo(1.84375f, -14.578125f);
            generalPath.closePath();
            generalPath.moveTo(2.875f, -13.5f);
            generalPath.lineTo(2.875f, -1.078125f);
            generalPath.lineTo(15.0625f, -1.078125f);
            generalPath.lineTo(15.0625f, -13.5f);
            generalPath.lineTo(2.875f, -13.5f);
            generalPath.closePath();
            generalPath.moveTo(13.734375f, -11.96875f);
            generalPath.lineTo(13.734375f, -11.90625f);
            generalPath.quadTo(13.0f, -11.265625f, 12.59375f, -10.703125f);
            generalPath.quadTo(9.40625f, -6.390625f, 8.796875f, -3.234375f);
            generalPath.quadTo(8.734375f, -2.65625f, 8.578125f, -2.65625f);
            generalPath.quadTo(7.4375f, -2.203125f, 7.3125f, -2.203125f);
            generalPath.quadTo(6.328125f, -4.71875f, 4.328125f, -4.71875f);
            generalPath.lineTo(4.109375f, -4.71875f);
            generalPath.lineTo(4.109375f, -4.78125f);
            generalPath.lineTo(5.6875f, -5.5f);
            generalPath.quadTo(7.15625f, -5.5f, 7.875f, -4.21875f);
            generalPath.lineTo(7.9375f, -4.21875f);
            generalPath.quadTo(8.421875f, -5.84375f, 9.046875f, -6.96875f);
            generalPath.quadTo(10.0f, -8.71875f, 11.515625f, -10.546875f);
            generalPath.quadTo(12.46875f, -11.71875f, 13.734375f, -11.96875f);
            generalPath.closePath();
            this.checkedShape = generalPath;
        }
        return this.checkedShape;
    }

    protected Shape getUncheckedShape() {
        if (this.uncheckedShape == null) {
            GeneralPath generalPath = new GeneralPath(1);
            generalPath.moveTo(1.859375f, -14.578125f);
            generalPath.lineTo(16.078125f, -14.578125f);
            generalPath.lineTo(16.140625f, -14.515625f);
            generalPath.lineTo(16.140625f, -0.0625f);
            generalPath.lineTo(16.078125f, 0.0f);
            generalPath.lineTo(1.859375f, 0.0f);
            generalPath.lineTo(1.796875f, -0.0625f);
            generalPath.lineTo(1.796875f, -14.515625f);
            generalPath.lineTo(1.859375f, -14.578125f);
            generalPath.closePath();
            generalPath.moveTo(2.875f, -13.5f);
            generalPath.lineTo(2.875f, -1.078125f);
            generalPath.lineTo(15.0625f, -1.078125f);
            generalPath.lineTo(15.0625f, -13.5f);
            generalPath.lineTo(2.875f, -13.5f);
            generalPath.closePath();
            this.uncheckedShape = generalPath;
        }
        return this.uncheckedShape;
    }

    protected Shape getShapeForValue(Object object) {
        Boolean bl = (Boolean)object;
        if (bl != null && bl.booleanValue()) {
            return this.getCheckedShape();
        }
        return this.getUncheckedShape();
    }

    public double drawCell(Graphics2D graphics2D, double d, double d2, Object object, TablePrintColumn tablePrintColumn, Color color, double d3, double d4, double d5, boolean bl, TableCellRenderer.ColumnPageData columnPageData) {
        if (bl) {
            return Double.MIN_VALUE;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d6 = (double)fontMetrics.getHeight() + 2.0 * d4;
        if (d2 + d6 > d5) {
            return 0.0;
        }
        Shape shape = this.getShapeForValue(object);
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d7 = 0.8 * (double)fontMetrics.getHeight() / rectangle2D.getHeight();
        Shape shape2 = graphics2D.getClip();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, tablePrintColumn.getEffectiveColumnWidth(), d6);
        graphics2D.clip(double_);
        if (color != null) {
            Color color2 = graphics2D.getColor();
            graphics2D.setColor(color);
            graphics2D.fill(double_);
            graphics2D.setColor(color2);
        }
        double d8 = rectangle2D.getWidth() * d7;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(tablePrintColumn.getAlignment().calculateX(d, d8, tablePrintColumn.getEffectiveColumnWidth(), d3), d2 + d4 + ((double)fontMetrics.getHeight() + rectangle2D.getHeight() * d7) / 2.0);
        graphics2D.scale(d7, d7);
        graphics2D.fill(shape);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape2);
        return d6;
    }

    public double getPreferredWidth(Graphics2D graphics2D, Object object, FontMetrics fontMetrics, Format format, TablePrintColumn tablePrintColumn) {
        Shape shape = this.getShapeForValue(object);
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d = 0.8 * (double)fontMetrics.getHeight() / rectangle2D.getHeight();
        return rectangle2D.getWidth() * d;
    }
}

