/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.print.tableprint;

import java.awt.Color;
import java.awt.Font;
import java.text.Format;
import yajhfc.print.tableprint.Alignment;
import yajhfc.print.tableprint.TableCellRenderer;
import yajhfc.print.tableprint.TablePrintable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePrintColumn {
    protected final TablePrintable parent;
    protected final int index;
    protected Font font = null;
    protected Font headerFont = null;
    protected Color background = null;
    public static final float WIDTH_PREFERRED = -1.0f;
    public static final float WIDTH_FILL = -2.0f;
    protected float width = -1.0f;
    protected Alignment alignment;
    protected boolean wordWrap = false;
    protected boolean headerWordWrap = true;
    protected Alignment headerAlignment = Alignment.CENTER;
    protected Format columnFormat = null;
    protected TableCellRenderer renderer = null;
    protected double effectiveColumnWidth;

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public Format getColumnFormat() {
        return this.columnFormat;
    }

    public void setColumnFormat(Format format) {
        this.columnFormat = format;
    }

    public boolean isWordWrap() {
        return this.wordWrap;
    }

    public void setWordWrap(boolean bl) {
        this.wordWrap = bl;
    }

    public Alignment getHeaderAlignment() {
        return this.headerAlignment;
    }

    public void setHeaderAlignment(Alignment alignment) {
        this.headerAlignment = alignment;
    }

    public TableCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TableCellRenderer tableCellRenderer) {
        this.renderer = tableCellRenderer;
    }

    public TablePrintable getParent() {
        return this.parent;
    }

    public int getModelIndex() {
        return this.index;
    }

    public Font getEffectiveFont() {
        return this.getFont() == null ? this.parent.getTableFont() : this.getFont();
    }

    public Font getEffectiveHeaderFont() {
        return this.getHeaderFont() == null ? this.parent.getHeaderFont() : this.getHeaderFont();
    }

    public Format getEffectiveFormat() {
        if (this.getColumnFormat() != null) {
            return this.getColumnFormat();
        }
        return this.parent.getFormatMap().get(this.getColumnClass());
    }

    public String getHeaderText() {
        return this.parent.getModel().getColumnName(this.index);
    }

    public Object getData(int n) {
        return this.parent.getModel().getValueAt(n, this.index);
    }

    protected Class<?> getColumnClass() {
        return this.parent.getModel().getColumnClass(this.index);
    }

    public TableCellRenderer getEffectiveRenderer() {
        if (this.renderer != null) {
            return this.renderer;
        }
        TableCellRenderer tableCellRenderer = this.parent.getRendererMap().get(this.getColumnClass());
        return tableCellRenderer == null ? this.parent.getDefaultRenderer() : tableCellRenderer;
    }

    public double getEffectiveColumnWidth() {
        return this.effectiveColumnWidth;
    }

    public void setEffectiveColumnWidth(double d) {
        this.effectiveColumnWidth = d;
    }

    public boolean isHeaderWordWrap() {
        return this.headerWordWrap;
    }

    public void setHeaderWordWrap(boolean bl) {
        this.headerWordWrap = bl;
    }

    public Color getBackgroundColor() {
        return this.background;
    }

    public void setBackgroundColor(Color color) {
        this.background = color;
    }

    public TablePrintColumn(TablePrintable tablePrintable, int n) {
        this.parent = tablePrintable;
        this.index = n;
        Class<?> clazz = this.getColumnClass();
        if (Number.class.isAssignableFrom(clazz)) {
            this.setAlignment(Alignment.RIGHT);
        } else if (clazz == Boolean.class) {
            this.setAlignment(Alignment.CENTER);
        } else {
            this.setAlignment(Alignment.LEFT);
        }
    }
}

