/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.print.tableprint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import yajhfc.DateKind;
import yajhfc.Utils;
import yajhfc.print.tableprint.Alignment;
import yajhfc.print.tableprint.BooleanRenderer;
import yajhfc.print.tableprint.CellFormatModel;
import yajhfc.print.tableprint.ColumnLayout;
import yajhfc.print.tableprint.DefaultCellFormatModel;
import yajhfc.print.tableprint.DefaultCellRenderer;
import yajhfc.print.tableprint.DefaultHeaderRenderer;
import yajhfc.print.tableprint.HeaderPrintMode;
import yajhfc.print.tableprint.ResizeMode;
import yajhfc.print.tableprint.SimpleColumnLayout;
import yajhfc.print.tableprint.TableCellRenderer;
import yajhfc.print.tableprint.TablePrintColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePrintable
implements Printable {
    private static final String DEFAULT_FONT_NAME = "sans-serif";
    protected TableModel model;
    protected Font tableFont;
    protected Font headerFont;
    protected HeaderPrintMode headerPrintMode = HeaderPrintMode.PRINT_ALWAYS;
    protected ResizeMode resizeMode = ResizeMode.RESIZE_SHRINK_ONLY;
    protected final Map<Alignment, MessageFormat> pageHeader = new EnumMap<Alignment, MessageFormat>(Alignment.class);
    protected final Map<Alignment, MessageFormat> pageFooter = new EnumMap<Alignment, MessageFormat>(Alignment.class);
    protected Font pageHeaderFont;
    protected Font pageFooterFont;
    protected float lineWidth = 0.125f;
    protected float headerLineWidth = 0.125f;
    protected float cellInsetX = -0.333f;
    protected float cellInsetY = -0.333f;
    protected final Map<Class<?>, Format> formatMap = new HashMap();
    protected final Map<Class<?>, TableCellRenderer> rendererMap = new HashMap();
    protected TableCellRenderer defaultRenderer = new DefaultCellRenderer();
    protected TableCellRenderer headerRenderer = new DefaultHeaderRenderer();
    protected Color headerBackground = new Color(240, 240, 240);
    protected Color[] cellBackground = null;
    protected ColumnLayout columnLayout;
    protected CellFormatModel formatModel = new DefaultCellFormatModel();
    protected int currentRow;
    protected int lastStartRow;
    protected int currentPage;
    protected final List<TableCellRenderer.ColumnPageData[]> pageData = new ArrayList<TableCellRenderer.ColumnPageData[]>();

    public TablePrintable(TableModel tableModel) {
        this(tableModel, new SimpleColumnLayout());
    }

    public TablePrintable(TableModel tableModel, ColumnLayout columnLayout) {
        this.columnLayout = columnLayout;
        this.pageFooter.put(Alignment.LEFT, new MessageFormat("'" + DateKind.DATE_AND_TIME.getFormat().format(new Date()) + "'"));
        this.pageFooter.put(Alignment.RIGHT, new MessageFormat(Utils._("page {0}")));
        this.tableFont = new Font(DEFAULT_FONT_NAME, 0, 10);
        this.headerFont = new Font(DEFAULT_FONT_NAME, 1, 10);
        this.pageHeaderFont = new Font(DEFAULT_FONT_NAME, 1, 11);
        this.pageFooterFont = new Font(DEFAULT_FONT_NAME, 0, 9);
        this.formatMap.put(Date.class, DateKind.DATE_AND_TIME.getFormat());
        this.rendererMap.put(Boolean.class, new BooleanRenderer());
        if (tableModel != null) {
            this.setModel(tableModel);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        double d;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D.Double double_ = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        if (this.pageHeader.size() > 0) {
            graphics2D.setFont(this.pageHeaderFont);
            d = this.drawHeaderOrFooter(graphics2D, this.pageHeader, double_, n, false) + (double)this.pageHeaderFont.getSize2D();
            double_.y += d;
            double_.height -= d;
        }
        if (this.pageFooter.size() > 0) {
            graphics2D.setFont(this.pageFooterFont);
            double_.height -= this.drawHeaderOrFooter(graphics2D, this.pageFooter, double_, n, true) + (double)this.pageFooterFont.getSize2D();
        }
        d = (d = (double)Math.max(this.lineWidth, this.headerLineWidth)) <= 0.0 ? 1.0 : (d += 1.0);
        double_.height -= d;
        double_.width -= d;
        if (n == 0) {
            this.currentRow = 0;
            this.lastStartRow = 0;
            this.currentPage = 0;
        } else if (n == this.currentPage) {
            this.currentRow = this.lastStartRow;
        } else {
            this.lastStartRow = this.currentRow;
            this.currentPage = n;
        }
        return this.drawTable(graphics2D, double_, n) == 0.0 ? 1 : 0;
    }

    protected double drawHeaderOrFooter(Graphics2D graphics2D, Map<Alignment, MessageFormat> map, Rectangle2D rectangle2D, int n, boolean bl) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = 0.0;
        Object[] objectArray = new Object[]{n + 1};
        Alignment[] alignmentArray = Alignment.values();
        String[] stringArray = new String[alignmentArray.length];
        Rectangle2D[] rectangle2DArray = new Rectangle2D[alignmentArray.length];
        for (Alignment alignment : alignmentArray) {
            MessageFormat messageFormat = map.get((Object)alignment);
            if (messageFormat == null) continue;
            String string = messageFormat.format(objectArray);
            stringArray[alignment.ordinal()] = string;
            String string2 = string;
            Rectangle2D rectangle2D2 = rectangle2DArray[alignment.ordinal()] = fontMetrics.getStringBounds(string2, graphics2D);
            Rectangle2D rectangle2D3 = rectangle2D2;
            if (!(rectangle2D3.getHeight() > d)) continue;
            d = rectangle2D3.getHeight();
        }
        float f = bl ? (float)(rectangle2D.getY() + rectangle2D.getHeight() - d + (double)fontMetrics.getAscent()) : (float)(rectangle2D.getY() + (double)fontMetrics.getAscent());
        if (map.containsKey((Object)Alignment.LEFT)) {
            graphics2D.drawString(stringArray[Alignment.LEFT.ordinal()], (float)rectangle2D.getX(), f);
        }
        if (map.containsKey((Object)Alignment.CENTER)) {
            graphics2D.drawString(stringArray[Alignment.CENTER.ordinal()], (float)(rectangle2D.getX() + (rectangle2D.getWidth() - rectangle2DArray[Alignment.CENTER.ordinal()].getWidth()) / 2.0), f);
        }
        if (map.containsKey((Object)Alignment.RIGHT)) {
            graphics2D.drawString(stringArray[Alignment.RIGHT.ordinal()], (float)(rectangle2D.getX() + rectangle2D.getWidth() - rectangle2DArray[Alignment.RIGHT.ordinal()].getWidth()), f);
        }
        return d;
    }

    public double drawTable(Graphics2D graphics2D, Rectangle2D rectangle2D, int n) {
        TablePrintColumn[] tablePrintColumnArray;
        boolean bl;
        double d;
        boolean bl2;
        if (this.currentRow >= this.model.getRowCount()) {
            return 0.0;
        }
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        double d2 = this.cellInsetY < 0.0f ? (double)(this.tableFont.getSize2D() * -this.cellInsetY) : (double)this.cellInsetY;
        double d3 = this.cellInsetX < 0.0f ? (double)(this.tableFont.getSize2D() * -this.cellInsetX) : (double)this.cellInsetX;
        if (n == 0) {
            this.columnLayout.calculateColumnWidths(graphics2D, rectangle2D.getWidth(), d3);
            this.pageData.clear();
        }
        double d4 = this.columnLayout.getTableWidth();
        double d5 = rectangle2D.getHeight();
        switch (this.resizeMode) {
            default: {
                bl2 = false;
                break;
            }
            case RESIZE_SHRINK_ONLY: {
                bl2 = d4 > rectangle2D.getWidth();
                break;
            }
            case RESIZE_GROW_ONLY: {
                bl2 = d4 < rectangle2D.getWidth();
                break;
            }
            case RESIZE_GROW_AND_SHRINK: {
                bl2 = d4 != rectangle2D.getWidth();
            }
        }
        double d6 = 1.0;
        if (bl2) {
            d = 0.0;
            d6 = rectangle2D.getWidth() / d4;
            graphics2D.scale(d6, d6);
            d5 /= d6;
        } else {
            d = d4 < rectangle2D.getWidth() ? (rectangle2D.getWidth() - d4) / 2.0 : 0.0;
        }
        double d7 = d;
        double d8 = 0.0;
        Line2D.Double double_ = new Line2D.Double();
        double[] dArray = new double[this.columnLayout.getMaximumColumnCount()];
        Rectangle2D.Double double_2 = new Rectangle2D.Double();
        switch (this.headerPrintMode) {
            case PRINT_ALWAYS: {
                bl = true;
                break;
            }
            default: {
                bl = false;
                break;
            }
            case PRINT_ON_FIRST_PAGE: {
                boolean bl3 = bl = n == 0;
            }
        }
        if (bl) {
            if (this.headerLinesEnabled()) {
                BasicStroke basicStroke = new BasicStroke(this.getHeaderLineWidth());
                graphics2D.setStroke(basicStroke);
            }
            double d9 = 0.0;
            d7 = d;
            tablePrintColumnArray = this.columnLayout.getHeaderLayout();
            for (int i = 0; i < tablePrintColumnArray.length; ++i) {
                double d10;
                TablePrintColumn tablePrintColumn = tablePrintColumnArray[i];
                graphics2D.setFont(tablePrintColumn.getEffectiveHeaderFont());
                dArray[i] = d10 = this.headerRenderer.drawCell(graphics2D, d7, d8, tablePrintColumn.getHeaderText(), tablePrintColumn, this.headerBackground, d3, d2, d5, false, null);
                if (d10 > d9) {
                    d9 = d10;
                }
                d7 += tablePrintColumn.effectiveColumnWidth;
            }
            double d11 = d8 + d9;
            if (this.headerBackground != null) {
                d7 = d;
                for (int i = 0; i < dArray.length; ++i) {
                    TablePrintColumn tablePrintColumn = tablePrintColumnArray[i];
                    if (dArray[i] < d9) {
                        double_2.x = d7;
                        double_2.width = tablePrintColumn.getEffectiveColumnWidth();
                        double_2.y = d8 + dArray[i];
                        double_2.height = d9 - dArray[i];
                        Color color = graphics2D.getColor();
                        graphics2D.setColor(this.headerBackground);
                        graphics2D.fill(double_2);
                        graphics2D.setColor(color);
                    }
                    d7 += tablePrintColumn.getEffectiveColumnWidth();
                }
            }
            if (this.headerLinesEnabled()) {
                d7 = d;
                double_.y1 = d8;
                double_.y2 = d11;
                for (int i = 0; i < tablePrintColumnArray.length; ++i) {
                    double_.x1 = double_.x2 = d7;
                    graphics2D.draw(double_);
                    d7 += tablePrintColumnArray[i].effectiveColumnWidth;
                }
                double_.x1 = double_.x2 = d7;
                graphics2D.draw(double_);
                double_.x1 = d;
                double_.x2 = d + d4;
                double_.y1 = double_.y2 = d8;
                graphics2D.draw(double_);
                double_.y1 = double_.y2 = d11;
                graphics2D.draw(double_);
            }
            d8 = d11;
        }
        if (this.gridLinesEnabled()) {
            BasicStroke basicStroke = new BasicStroke(this.getLineWidth());
            graphics2D.setStroke(basicStroke);
        }
        boolean bl4 = n != 0;
        TableCellRenderer.ColumnPageData[] columnPageDataArray = new TableCellRenderer.ColumnPageData[this.columnLayout.getMaximumColumnCount()];
        try {
            tablePrintColumnArray = bl4 ? this.pageData.get(n - 1) : null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            tablePrintColumnArray = null;
        }
        while (this.currentRow < this.model.getRowCount()) {
            int n2;
            TablePrintColumn[] tablePrintColumnArray2 = this.columnLayout.getLayoutForRow(this.currentRow);
            double d12 = 0.0;
            Arrays.fill(dArray, 0.0);
            boolean bl5 = false;
            d7 = d;
            for (int i = 0; i < tablePrintColumnArray2.length; ++i) {
                TablePrintColumn tablePrintColumn = tablePrintColumnArray2[i];
                Object object = null;
                if (bl4) {
                    if (tablePrintColumnArray != null) {
                        object = tablePrintColumnArray[i];
                    }
                    object = object == null ? new TableCellRenderer.ColumnPageData() : (TableCellRenderer.ColumnPageData)((TableCellRenderer.ColumnPageData)object).clone();
                } else {
                    object = columnPageDataArray[i];
                    if (object == null) {
                        object = new TableCellRenderer.ColumnPageData();
                    }
                }
                if (!bl4 || ((TableCellRenderer.ColumnPageData)object).lastDrawState != 0) {
                    graphics2D.setFont(this.formatModel.getCellFont(tablePrintColumn, this.model, this.currentRow));
                    double d13 = tablePrintColumn.getEffectiveRenderer().drawCell(graphics2D, d7, d8, tablePrintColumn.getData(this.currentRow), tablePrintColumn, this.formatModel.getCellBackgroundColor(tablePrintColumn, this.model, this.currentRow), d3, d2, d5, bl4 && ((TableCellRenderer.ColumnPageData)object).lastDrawState != 2, (TableCellRenderer.ColumnPageData)object);
                    columnPageDataArray[i] = object;
                    if (d13 == 0.0) {
                        bl5 = true;
                        ((TableCellRenderer.ColumnPageData)object).lastDrawState = 2;
                    } else if (d13 == Double.MIN_VALUE) {
                        ((TableCellRenderer.ColumnPageData)object).lastDrawState = 0;
                    } else if (d13 < 0.0) {
                        bl5 = true;
                        dArray[i] = -d13;
                        if (-d13 > d12) {
                            d12 = -d13;
                        }
                        ((TableCellRenderer.ColumnPageData)object).lastDrawState = 1;
                    } else {
                        dArray[i] = d13;
                        if (d13 > d12) {
                            d12 = d13;
                        }
                        ((TableCellRenderer.ColumnPageData)object).lastDrawState = 0;
                    }
                }
                d7 += tablePrintColumn.effectiveColumnWidth;
            }
            if (bl5 && d12 == 0.0) break;
            double d14 = d8 + d12;
            d7 = d;
            for (n2 = 0; n2 < tablePrintColumnArray2.length; ++n2) {
                Color color;
                TablePrintColumn tablePrintColumn = tablePrintColumnArray2[n2];
                if (dArray[n2] < d12 && (color = this.formatModel.getCellBackgroundColor(tablePrintColumn, this.model, this.currentRow)) != null) {
                    double_2.x = d7;
                    double_2.width = tablePrintColumn.getEffectiveColumnWidth();
                    double_2.y = d8 + dArray[n2];
                    double_2.height = d12 - dArray[n2];
                    Color color2 = graphics2D.getColor();
                    graphics2D.setColor(color);
                    graphics2D.fill(double_2);
                    graphics2D.setColor(color2);
                }
                d7 += tablePrintColumn.getEffectiveColumnWidth();
            }
            if (this.gridLinesEnabled()) {
                d7 = d;
                double_.y1 = d8;
                double_.y2 = d14;
                for (n2 = 0; n2 < tablePrintColumnArray2.length; ++n2) {
                    double_.x1 = double_.x2 = d7;
                    graphics2D.draw(double_);
                    d7 += tablePrintColumnArray2[n2].effectiveColumnWidth;
                }
                double_.x1 = double_.x2 = d7;
                graphics2D.draw(double_);
                double_.x1 = d;
                double_.x2 = d + d4;
                double_.y1 = double_.y2 = d8;
                graphics2D.draw(double_);
            }
            d8 = d14;
            if (bl5) break;
            bl4 = false;
            ++this.currentRow;
        }
        if (this.pageData.size() > n) {
            this.pageData.set(n, columnPageDataArray);
        } else {
            while (this.pageData.size() < n) {
                this.pageData.add(null);
            }
            this.pageData.add(columnPageDataArray);
        }
        if (this.gridLinesEnabled()) {
            double_.x1 = d;
            double_.x2 = d + d4;
            double_.y1 = double_.y2 = d8;
            graphics2D.draw(double_);
        }
        return (this.currentRow >= this.model.getRowCount() ? d8 : -d8) * d6;
    }

    protected boolean gridLinesEnabled() {
        return this.lineWidth >= 0.0f;
    }

    protected boolean headerLinesEnabled() {
        return this.headerLineWidth >= 0.0f;
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel tableModel) {
        this.model = tableModel;
        this.columnLayout.initializeLayout(this, tableModel);
    }

    public Font getTableFont() {
        return this.tableFont;
    }

    public void setTableFont(Font font) {
        this.tableFont = font;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font;
    }

    public Font getPageHeaderFont() {
        return this.pageHeaderFont;
    }

    public void setPageHeaderFont(Font font) {
        this.pageHeaderFont = font;
    }

    public Font getPageFooterFont() {
        return this.pageFooterFont;
    }

    public void setPageFooterFont(Font font) {
        this.pageFooterFont = font;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
    }

    public Map<Class<?>, Format> getFormatMap() {
        return this.formatMap;
    }

    public Map<Class<?>, TableCellRenderer> getRendererMap() {
        return this.rendererMap;
    }

    public Map<Alignment, MessageFormat> getPageFooter() {
        return this.pageFooter;
    }

    public Map<Alignment, MessageFormat> getPageHeader() {
        return this.pageHeader;
    }

    public void setHeaderPrintMode(HeaderPrintMode headerPrintMode) {
        this.headerPrintMode = headerPrintMode;
    }

    public HeaderPrintMode getHeaderPrintMode() {
        return this.headerPrintMode;
    }

    public Color getHeaderBackground() {
        return this.headerBackground;
    }

    public void setHeaderBackground(Color color) {
        this.headerBackground = color;
    }

    public Color[] getCellBackground() {
        return this.cellBackground;
    }

    public void setCellBackground(Color[] colorArray) {
        this.cellBackground = colorArray;
    }

    public ResizeMode getResizeMode() {
        return this.resizeMode;
    }

    public void setResizeMode(ResizeMode resizeMode) {
        this.resizeMode = resizeMode;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setHeaderRenderer(TableCellRenderer tableCellRenderer) {
        this.headerRenderer = tableCellRenderer;
    }

    public void setColumnLayout(ColumnLayout columnLayout) {
        this.columnLayout = columnLayout;
        if (this.model != null) {
            columnLayout.initializeLayout(this, this.model);
        }
    }

    public ColumnLayout getColumnLayout() {
        return this.columnLayout;
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
        this.defaultRenderer = tableCellRenderer;
    }

    public float getHeaderLineWidth() {
        return this.headerLineWidth;
    }

    public float getCellInsetX() {
        return this.cellInsetX;
    }

    public float getCellInsetY() {
        return this.cellInsetY;
    }

    public CellFormatModel getFormatModel() {
        return this.formatModel;
    }

    public void setFormatModel(CellFormatModel cellFormatModel) {
        this.formatModel = cellFormatModel;
    }

    public void setHeaderLineWidth(float f) {
        this.headerLineWidth = f;
    }

    public void setCellInsetX(float f) {
        this.cellInsetX = f;
    }

    public void setCellInsetY(float f) {
        this.cellInsetY = f;
    }
}

