/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.report;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import yajhfc.MainWin;
import yajhfc.Utils;
import yajhfc.launch.Launcher2;
import yajhfc.model.FmtItem;
import yajhfc.model.FmtItemList;
import yajhfc.model.TableType;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.ui.TooltipJTable;
import yajhfc.report.EntryPoint;
import yajhfc.report.ReportOptions;
import yajhfc.report.SendReport;
import yajhfc.report.SendReportDialog;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.ProgressWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrintReportAction
extends ExcDialogAbstractAction
implements ListSelectionListener,
ChangeListener {
    public PrintReportAction() {
        this.putValue("Name", Utils._("Print report") + "...");
        this.putValue("ShortDescription", Utils._("Prints a send or receive report for the fax"));
        this.putValue("SmallIcon", Utils.loadCustomIcon("printreport.gif"));
        this.setEnabled(false);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.doEnableCheck();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.doEnableCheck();
    }

    public void doEnableCheck() {
        boolean bl;
        MainWin mainWin = (MainWin)Launcher2.application;
        TooltipJTable<? extends FmtItem> tooltipJTable = mainWin.getSelectedTable();
        switch (tooltipJTable.getRealModel().getTableType()) {
            case RECEIVED: 
            case SENT: {
                bl = tooltipJTable.getSelectedRow() >= 0;
                break;
            }
            default: {
                bl = false;
            }
        }
        this.setEnabled(bl);
    }

    @Override
    protected void actualActionPerformed(ActionEvent actionEvent) {
        try {
            MainWin mainWin = (MainWin)Launcher2.application;
            TooltipJTable<? extends FmtItem> tooltipJTable = mainWin.getSelectedTable();
            PrintReportAction.printReport(mainWin, tooltipJTable.getSelectedJobs(), tooltipJTable.getRealModel().getColumns(), tooltipJTable.getRealModel().getTableType(), mainWin.getTablePanel());
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog(Launcher2.application.getFrame(), Utils._("Error generating report:"), exception);
        }
    }

    public static <T extends FmtItem> void printReport(Frame frame, final FaxJob<T>[] faxJobArray, FmtItemList<T> fmtItemList, TableType tableType, ProgressWorker.ProgressUI progressUI) {
        final SendReport<T> sendReport = SendReportDialog.showSendReportDialog(frame, fmtItemList, tableType);
        if (sendReport == null) {
            return;
        }
        ProgressWorker progressWorker = new ProgressWorker(){
            boolean success;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doWork() {
                SendReport.SendReportPageable sendReportPageable = null;
                try {
                    sendReportPageable = sendReport.createPageableForJobs(faxJobArray, this);
                    this.updateNote(Utils._("Initializing print dialog..."));
                    ReportOptions reportOptions = EntryPoint.getOptions();
                    final HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                    if (reportOptions.printAttributes == null) {
                        hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
                    } else {
                        for (Attribute attribute : reportOptions.printAttributes) {
                            hashPrintRequestAttributeSet.add(attribute);
                        }
                    }
                    final PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPageable(sendReportPageable);
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            this.getProgressMonitor().setNote(Utils._("Showing print dialog"));
                            success = printerJob.printDialog(hashPrintRequestAttributeSet);
                        }
                    });
                    if (!this.success) {
                        return;
                    }
                    this.updateNote(Utils._("Printing..."));
                    sendReportPageable.setPageFormat(PrintReportAction.retrievePageFormat(printerJob, hashPrintRequestAttributeSet));
                    printerJob.print(hashPrintRequestAttributeSet);
                    this.updateNote(Utils._("Cleaning up..."));
                    reportOptions.printAttributes = hashPrintRequestAttributeSet.toArray();
                }
                catch (Exception exception) {
                    this.showExceptionDialog(Utils._("Error printing report:"), exception);
                }
                finally {
                    if (sendReportPageable != null) {
                        sendReportPageable.cleanup();
                    }
                }
            }
        };
        progressWorker.setProgressMonitor(progressUI);
        progressWorker.startWork(frame, Utils._("Printing reports..."));
    }

    static PageFormat retrievePageFormat(PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet) {
        try {
            Method method = printerJob.getClass().getMethod("getPageFormat", PrintRequestAttributeSet.class);
            return (PageFormat)method.invoke((Object)printerJob, printRequestAttributeSet);
        }
        catch (Exception exception) {
            Logger.getLogger(PrintReportAction.class.getName()).log(Level.INFO, "Using default page format", exception);
            return printerJob.defaultPage();
        }
    }
}

