/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.report;

import gnu.inet.ftp.ServerResponseException;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.file.FileConverter;
import yajhfc.file.FormattedFile;
import yajhfc.file.UnknownFormatException;
import yajhfc.model.FmtItem;
import yajhfc.model.servconn.FaxDocument;
import yajhfc.model.servconn.FaxJob;
import yajhfc.report.Fax2ImageConverter;
import yajhfc.util.ProgressWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendReport<T extends FmtItem> {
    static final Logger log = Logger.getLogger(SendReport.class.getName());
    protected List<T> columns = new ArrayList<T>();
    protected int thumbnailsPerPage = 0;
    protected String headLine = Utils._("Fax send report");
    protected Font normalFont = new Font("sans-serif", 0, 10);
    protected Font headerFont = new Font("sans-serif", 1, 18);
    protected float lineWidth = 0.125f;
    protected int startPage = 0;
    protected int endPage = 0;

    public SendReportPrintable createPrintableForJob(FaxJob<T> faxJob, ProgressWorker progressWorker) throws IOException, ServerResponseException, UnknownFormatException, FileConverter.ConversionException {
        return new SendReportPrintable(faxJob, progressWorker);
    }

    public SendReportPageable createPageableForJobs(FaxJob<T>[] faxJobArray, ProgressWorker progressWorker) throws IOException, ServerResponseException, UnknownFormatException, FileConverter.ConversionException {
        return new SendReportPageable(faxJobArray, progressWorker);
    }

    public List<T> getColumns() {
        return this.columns;
    }

    public void setColumns(List<T> list) {
        this.columns = list;
    }

    public int getThumbnailsPerPage() {
        return this.thumbnailsPerPage;
    }

    public void setThumbnailsPerPage(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("thumbnailsPerPage must be >= 0");
        }
        this.thumbnailsPerPage = n;
    }

    public String getHeadLine() {
        return this.headLine;
    }

    public void setHeadLine(String string) {
        this.headLine = string;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setNormalFont(Font font) {
        this.normalFont = font;
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
    }

    public void setStartPage(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("startPage must be >= 1");
        }
        this.startPage = n;
    }

    public void setEndPage(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("startPage must be >= 0");
        }
        this.endPage = n;
    }

    static class Row {
        public final String description;
        public final String value;
        public Rectangle2D bbox;

        public Row(String string, String string2) {
            this.description = string;
            this.value = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SendReportPageable
    implements Pageable {
        protected PageFormat pageFormat = new PageFormat();
        protected SendReportPrintable[] printables;
        protected int totalNumberOfPages;
        protected ProgressWorker worker;

        protected SendReportPageable(FaxJob<T>[] faxJobArray, ProgressWorker progressWorker) throws IOException, ServerResponseException, UnknownFormatException, FileConverter.ConversionException {
            this.createPrintables(faxJobArray, progressWorker);
        }

        public void createPrintables(FaxJob<T>[] faxJobArray, ProgressWorker progressWorker) throws IOException, ServerResponseException, UnknownFormatException, FileConverter.ConversionException {
            this.printables = new SendReportPrintable[faxJobArray.length];
            this.totalNumberOfPages = 0;
            this.worker = progressWorker;
            for (int i = 0; i < faxJobArray.length; ++i) {
                SendReportPrintable sendReportPrintable = SendReport.this.createPrintableForJob(faxJobArray[i], progressWorker);
                sendReportPrintable.setPageOffset(this.totalNumberOfPages);
                this.totalNumberOfPages += sendReportPrintable.getNumberOfPages();
                this.printables[i] = sendReportPrintable;
            }
        }

        public void cleanup() {
            if (this.printables != null) {
                for (SendReportPrintable sendReportPrintable : this.printables) {
                    if (sendReportPrintable == null) continue;
                    sendReportPrintable.cleanup();
                }
                this.printables = null;
            }
        }

        @Override
        public int getNumberOfPages() {
            return this.totalNumberOfPages;
        }

        @Override
        public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
            return this.pageFormat;
        }

        public void setPageFormat(PageFormat pageFormat) {
            this.pageFormat = pageFormat;
        }

        @Override
        public Printable getPrintable(int n) throws IndexOutOfBoundsException {
            if (n >= this.totalNumberOfPages) {
                throw new IndexOutOfBoundsException();
            }
            if (this.worker != null) {
                this.worker.updateNote(MessageFormat.format(Utils._("Printing page {0}"), n + 1));
                this.worker.setProgress(n * 100 / this.totalNumberOfPages);
            }
            for (SendReportPrintable sendReportPrintable : this.printables) {
                if (n - sendReportPrintable.getPageOffset() >= sendReportPrintable.getNumberOfPages()) continue;
                return sendReportPrintable;
            }
            throw new IndexOutOfBoundsException("No report found with page " + n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SendReportPrintable
    implements Printable {
        protected int totalOutPages;
        protected Row[] rows;
        protected Fax2ImageConverter reader;
        protected int pageOffset = 0;

        protected SendReportPrintable(FaxJob<T> faxJob, ProgressWorker progressWorker) throws IOException, ServerResponseException, UnknownFormatException, FileConverter.ConversionException {
            this.initializeForJob(faxJob, progressWorker);
        }

        public void setPageOffset(int n) {
            this.pageOffset = n;
        }

        public int getPageOffset() {
            return this.pageOffset;
        }

        protected void initializeForJob(FaxJob<T> faxJob, ProgressWorker progressWorker) throws IOException, ServerResponseException, UnknownFormatException, FileConverter.ConversionException {
            Object object;
            if (Utils.debugMode) {
                log.fine("Generating report for job " + faxJob);
            }
            String string = MessageFormat.format(Utils._("Fax {0}: "), faxJob.getIDValue());
            if (progressWorker != null) {
                progressWorker.updateNote(string + Utils._("Calculating information..."));
            }
            if (Utils.debugMode) {
                log.fine("Columns: " + SendReport.this.columns);
            }
            this.rows = new Row[SendReport.this.columns.size()];
            for (int i = 0; i < this.rows.length; ++i) {
                object = (FmtItem)SendReport.this.columns.get(i);
                String string2 = object.getDescription();
                Object object2 = faxJob.getData((FmtItem)object);
                String string3 = object2 == null ? "" : (object.getDataType() == Date.class ? object.getDisplayDateFormat().format(object2) : (object.getDataType() == Boolean.class ? ((Boolean)object2 != false ? Utils._("yes") : Utils._("no")) : object2.toString()));
                this.rows[i] = new Row(string2, string3);
            }
            if (progressWorker != null) {
                progressWorker.updateNote(string + Utils._("Retrieving list of documents..."));
            }
            log.fine("Retrieving list of documents...");
            Collection<FaxDocument> collection = faxJob.getDocuments();
            if (Utils.debugMode) {
                log.fine("Documents are: " + collection);
            }
            if (progressWorker != null) {
                progressWorker.updateNote(string + Utils._("Downloading documents..."));
            }
            log.fine("Downloading documents...");
            object = new ArrayList(collection.size());
            for (FaxDocument faxDocument : collection) {
                object.add(faxDocument.getDocument());
            }
            if (progressWorker != null) {
                progressWorker.updateNote(string + Utils._("Converting documents to PNG..."));
            }
            this.reader = new Fax2ImageConverter();
            this.reader.readFiles((List<FormattedFile>)object, SendReport.this.startPage - 1, SendReport.this.endPage - 1);
            if (this.reader.getNumberOfPages() == 0) {
                throw new FileConverter.ConversionException("The report has no pages. Is the selected range of pages valid?");
            }
            this.totalOutPages = SendReport.this.thumbnailsPerPage == 0 ? 1 : (this.reader.getNumberOfPages() + SendReport.this.thumbnailsPerPage - 1) / SendReport.this.thumbnailsPerPage;
        }

        protected float printHeader(Graphics2D graphics2D, float f, float f2, float f3, int n, int n2) {
            graphics2D.setFont(SendReport.this.headerFont);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            LineMetrics lineMetrics = fontMetrics.getLineMetrics(SendReport.this.headLine, graphics2D);
            graphics2D.drawString(SendReport.this.headLine, f, f2 + lineMetrics.getAscent());
            graphics2D.setFont(SendReport.this.normalFont);
            String string = MessageFormat.format(Utils._("Page {0} of {1}"), n, n2);
            fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
            graphics2D.drawString(string, f + f3 - (float)rectangle2D.getWidth(), f2 + lineMetrics.getAscent());
            return f2 + lineMetrics.getHeight() * 1.5f;
        }

        protected float printRows(Graphics2D graphics2D, float f, float f2, float f3, Row[] rowArray) {
            graphics2D.setFont(SendReport.this.normalFont);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            LineMetrics lineMetrics = fontMetrics.getLineMetrics("X", graphics2D);
            float f4 = lineMetrics.getHeight() * 0.25f;
            graphics2D.setStroke(new BasicStroke(SendReport.this.lineWidth));
            Line2D.Float float_ = new Line2D.Float(f, f2 += f4, f + f3, f2);
            graphics2D.draw(float_);
            f2 += f4;
            float f5 = 0.0f;
            for (Row row : rowArray) {
                row.bbox = fontMetrics.getStringBounds(row.description, graphics2D);
                if (!(row.bbox.getWidth() > (double)f5)) continue;
                f5 = (float)row.bbox.getWidth();
            }
            for (Row row : rowArray) {
                graphics2D.drawString(row.description + ": " + row.value, f + f5 - (float)row.bbox.getWidth(), f2 + lineMetrics.getAscent());
                f2 += (float)row.bbox.getHeight();
            }
            float_.y1 = float_.y2 = (f2 += f4);
            graphics2D.draw(float_);
            return f2 += f4;
        }

        protected int printNUp(Graphics2D graphics2D, float f, float f2, float f3, float f4, int n, int n2) throws IOException {
            float f5;
            float f6;
            if (this.reader.getNumberOfPages() == 0) {
                throw new IOException("No pages in report (reader.NumberOfPages=0).");
            }
            BufferedImage bufferedImage = this.reader.getImage(0);
            float f7 = bufferedImage.getWidth();
            float f8 = bufferedImage.getHeight();
            int n3 = this.reader.getNumberOfPages() - n + 1;
            if (n2 > 0 && n3 > n2) {
                n3 = n2;
            }
            int n4 = n3;
            int n5 = 1;
            while (f4 / (f6 = f8 * (f5 = Math.min(f3 / (f7 * (float)n5), f4 / (f8 * (float)n4)))) > (float)(n5 + 1)) {
                n4 = (n3 + ++n5 - 1) / n5;
            }
            graphics2D.setStroke(new BasicStroke(SendReport.this.lineWidth));
            f6 = f3 / (float)n4;
            float f9 = f4 / (float)n5;
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n4; ++j) {
                    n6 = i * n4 + j + n;
                    if (n6 >= n + n3) {
                        return n6 - 1;
                    }
                    BufferedImage bufferedImage2 = this.reader.getImage(n6 - 1);
                    f5 = Math.min(f6 / (float)bufferedImage2.getWidth(), f9 / (float)bufferedImage2.getHeight());
                    float f10 = (float)bufferedImage2.getWidth() * f5;
                    float f11 = (float)bufferedImage2.getHeight() * f5;
                    float f12 = f + (float)j * f6 + (f6 - f10) / 2.0f;
                    float f13 = f2 + (float)i * f9 + (f9 - f11) / 2.0f;
                    graphics2D.drawImage(bufferedImage2, new AffineTransform(f5, 0.0f, 0.0f, f5, f12, f13), null);
                    graphics2D.draw(new Rectangle2D.Float(f12, f13, f10, f11));
                }
            }
            return n6;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            if ((n -= this.pageOffset) >= this.totalOutPages) {
                return 1;
            }
            try {
                int n2 = n * SendReport.this.thumbnailsPerPage + 1;
                int n3 = this.reader.getNumberOfPages();
                if (Utils.debugMode) {
                    log.fine("maxPage=" + n3 + "; totalOutPages=" + this.totalOutPages + "; thumbnailsPerPage=" + SendReport.this.thumbnailsPerPage);
                }
                if (Utils.debugMode) {
                    log.fine("Writing page " + n + "; firstPage=" + n2);
                }
                Graphics2D graphics2D = (Graphics2D)graphics;
                float f = (float)pageFormat.getImageableX();
                float f2 = (float)pageFormat.getImageableY();
                float f3 = (float)pageFormat.getImageableWidth() - SendReport.this.lineWidth;
                f2 = this.printHeader(graphics2D, f, f2, f3, n + 1, this.totalOutPages);
                f2 = this.printRows(graphics2D, f, f2, f3, this.rows);
                float f4 = (float)pageFormat.getImageableHeight() + (float)pageFormat.getImageableY() - f2 - SendReport.this.lineWidth;
                this.printNUp(graphics2D, f, f2, f3, f4, n2, Math.min(SendReport.this.thumbnailsPerPage, n3 - n2 + 1));
                return 0;
            }
            catch (Exception exception) {
                throw (PrinterException)new PrinterException("Error printing report page " + (n + 1)).initCause(exception);
            }
        }

        public int getNumberOfPages() {
            return this.totalOutPages;
        }

        public void cleanup() {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
    }
}

