/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.send;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import yajhfc.Utils;
import yajhfc.send.TFLItem;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ListListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextFieldList<T extends TFLItem>
extends JPanel
implements ListSelectionListener,
KeyListener,
MouseListener,
DocumentListener,
FocusListener {
    protected JTextField textField;
    protected JList list;
    protected JScrollPane scrollPane;
    protected ListListModel<T> model;
    protected Action addAction;
    protected Action removeAction;
    protected Action modifyAction;
    protected Action upAction;
    protected Action downAction;
    protected JPopupMenu popup;
    protected boolean useUpDown;
    protected ArrayList<JComponent> localComponents;
    protected TFLItem lastSelection;
    protected JButton btnRemove;

    public Action getUpAction() {
        if (this.upAction == null) {
            this.upAction = new ExcDialogAbstractAction(){

                public void actualActionPerformed(ActionEvent actionEvent) {
                    if (!this.isEnabled()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    int n = TextFieldList.this.list.getSelectedIndex();
                    if (n >= 1) {
                        TextFieldList.this.model.moveUp(new int[]{n});
                    }
                }
            };
            this.upAction.putValue("Name", Utils._("Up"));
            this.upAction.putValue("ShortDescription", Utils._("Moves the item upwards"));
            this.upAction.putValue("SmallIcon", Utils.loadIcon("navigation/Up"));
            this.upAction.setEnabled(false);
        }
        return this.upAction;
    }

    public Action getDownAction() {
        if (this.downAction == null) {
            this.downAction = new ExcDialogAbstractAction(){

                public void actualActionPerformed(ActionEvent actionEvent) {
                    if (!this.isEnabled()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    int n = TextFieldList.this.list.getSelectedIndex();
                    if (n >= 0 && n < TextFieldList.this.model.getSize() - 1) {
                        TextFieldList.this.model.moveDown(new int[]{n});
                    }
                }
            };
            this.downAction.putValue("Name", Utils._("Down"));
            this.downAction.putValue("ShortDescription", Utils._("Moves the item downwards"));
            this.downAction.putValue("SmallIcon", Utils.loadIcon("navigation/Down"));
            this.downAction.setEnabled(false);
        }
        return this.downAction;
    }

    public Action getAddAction() {
        if (this.addAction == null) {
            this.addAction = new ExcDialogAbstractAction(){

                public void actualActionPerformed(ActionEvent actionEvent) {
                    if (!this.isEnabled()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    TextFieldList.this.addListItem(TextFieldList.this.textField.getText());
                }
            };
            this.addAction.putValue("Name", Utils._("Add"));
            this.addAction.putValue("ShortDescription", Utils._("Adds the text to the list"));
            this.addAction.putValue("SmallIcon", Utils.loadIcon("general/Add"));
        }
        return this.addAction;
    }

    public Action getRemoveAction() {
        if (this.removeAction == null) {
            this.removeAction = new ExcDialogAbstractAction(){

                public void actualActionPerformed(ActionEvent actionEvent) {
                    if (!this.isEnabled()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    if (TextFieldList.this.list.getSelectedIndex() >= 0) {
                        TextFieldList.this.lastSelection = null;
                        TextFieldList.this.model.removeAll(TextFieldList.this.list.getSelectedIndices());
                        TextFieldList.this.textField.setText("");
                    }
                }
            };
            this.removeAction.putValue("Name", Utils._("Remove"));
            this.removeAction.putValue("ShortDescription", Utils._("Removes the selected item from the list"));
            this.removeAction.putValue("SmallIcon", Utils.loadIcon("general/Delete"));
            this.removeAction.setEnabled(false);
        }
        return this.removeAction;
    }

    public Action getModifyAction() {
        if (this.modifyAction == null) {
            this.modifyAction = new ExcDialogAbstractAction(){

                public void actualActionPerformed(ActionEvent actionEvent) {
                    if (!this.isEnabled()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    TFLItem tFLItem = (TFLItem)TextFieldList.this.list.getSelectedValue();
                    TextFieldList.this.modifyListItem(tFLItem);
                }
            };
            this.modifyAction.putValue("Name", Utils._("Update"));
            this.modifyAction.putValue("ShortDescription", Utils._("Updates the selected list item"));
            this.modifyAction.putValue("SmallIcon", Utils.loadIcon("general/Refresh"));
            this.modifyAction.setEnabled(false);
        }
        return this.modifyAction;
    }

    protected void commitChanges(TFLItem tFLItem) {
        tFLItem.setText(this.textField.getText());
    }

    protected abstract T createListItem(String var1);

    protected void modifyListItem(TFLItem tFLItem) {
        if (tFLItem != null && tFLItem.isMutable() && this.textField.getDocument().getLength() > 0) {
            this.commitChanges(tFLItem);
            this.list.repaint();
        }
    }

    public void addListItem(T t) {
        if (!this.model.getList().contains(t)) {
            this.lastSelection = null;
            this.model.add(t);
            this.list.setSelectedIndex(this.model.getSize() - 1);
        }
    }

    public void addListItem(String string) {
        if (string.length() > 0) {
            this.addListItem(this.createListItem(string));
        }
    }

    public JList getList() {
        if (this.list == null) {
            this.list = new JList<T>(this.model);
            this.list.setVisibleRowCount(3);
        }
        return this.list;
    }

    public JPopupMenu getPopup() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.popup.add(new JMenuItem(this.getModifyAction()));
            this.popup.addSeparator();
            this.popup.add(new JMenuItem(this.getAddAction()));
            this.popup.add(new JMenuItem(this.getRemoveAction()));
            if (this.useUpDown) {
                this.popup.addSeparator();
                this.popup.add(new JMenuItem(this.getUpAction()));
                this.popup.add(new JMenuItem(this.getDownAction()));
            }
        }
        return this.popup;
    }

    public TextFieldList(JTextField jTextField, boolean bl) {
        this(jTextField, bl, new ArrayList());
    }

    public TextFieldList(JTextField jTextField, boolean bl, List<T> list) {
        super(null, false);
        this.useUpDown = bl;
        this.textField = jTextField;
        double[][] dArrayArray = new double[][]{{-1.0, -2.0}, {-2.0, -2.0, -1.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.localComponents = new ArrayList();
        this.model = new ListListModel<T>(list);
        this.scrollPane = new JScrollPane(this.getList(), 22, 31);
        this.localComponents.add(this.scrollPane);
        this.add((Component)this.scrollPane, "0, 0, 0, 2, F, F");
        JButton jButton = new JButton(this.getAddAction());
        jButton.setText("");
        this.localComponents.add(jButton);
        this.btnRemove = new JButton(this.getRemoveAction());
        this.btnRemove.setText("");
        this.localComponents.add(this.btnRemove);
        this.add((Component)jButton, "1, 0");
        this.add((Component)this.btnRemove, "1, 1");
        jTextField.addKeyListener(this);
        jTextField.getDocument().addDocumentListener(this);
        this.localComponents.add(jTextField);
        this.list.addKeyListener(this);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(this);
        this.localComponents.add(this.list);
        for (JComponent jComponent : this.localComponents) {
            jComponent.addFocusListener(this);
        }
        this.updateAddEnabled();
    }

    public void addLocalComponent(JComponent jComponent) {
        this.localComponents.add(jComponent);
        jComponent.addFocusListener(this);
    }

    public void removeLocalComponent(JComponent jComponent) {
        if (this.localComponents.remove(jComponent)) {
            jComponent.removeFocusListener(this);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.list) {
            if (keyEvent.getKeyCode() == 127) {
                this.getRemoveAction().actionPerformed(null);
            }
        } else if (keyEvent.getSource() == this.textField && keyEvent.getKeyCode() == 10) {
            if (keyEvent.isControlDown() || this.list.getSelectedIndex() < 0) {
                this.getAddAction().actionPerformed(null);
            } else {
                this.getModifyAction().actionPerformed(null);
            }
        }
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.getPopup().show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.list.getSelectedIndex();
        TFLItem tFLItem = (TFLItem)this.list.getSelectedValue();
        if (!listSelectionEvent.getValueIsAdjusting() && this.lastSelection != null) {
            this.modifyListItem(this.lastSelection);
        }
        this.getModifyAction().setEnabled(n >= 0 && tFLItem.isMutable());
        this.getRemoveAction().setEnabled(n >= 0 && tFLItem.isDeletable());
        if (this.useUpDown) {
            this.getUpAction().setEnabled(n >= 1);
            this.getDownAction().setEnabled(n >= 0 && n < this.model.getSize() - 1);
        }
        if (tFLItem != null && !listSelectionEvent.getValueIsAdjusting()) {
            this.displayItem(tFLItem);
            this.lastSelection = tFLItem;
        }
    }

    protected void displayItem(TFLItem tFLItem) {
        if (tFLItem.isMutable()) {
            this.textField.setText(tFLItem.getText());
        } else {
            this.textField.setText("");
        }
    }

    private void updateAddEnabled() {
        this.getAddAction().setEnabled(this.textField.getDocument().getLength() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateAddEnabled();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateAddEnabled();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateAddEnabled();
    }

    public void commit() {
        if (this.model.getSize() == 0 && this.getAddAction().isEnabled()) {
            this.getAddAction().actionPerformed(null);
        } else if (this.getModifyAction().isEnabled()) {
            this.getModifyAction().actionPerformed(null);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent().isEnabled() && !this.localComponents.contains(focusEvent.getOppositeComponent())) {
            this.commit();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && (n = this.list.getSelectedIndex()) >= 0 && this.list.getCellBounds(n, n).contains(mouseEvent.getPoint())) {
            this.getRemoveAction().actionPerformed(null);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (Component component : this.getComponents()) {
            component.setEnabled(bl);
        }
        this.list.setEnabled(bl);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }
}

