/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.shutdown;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import yajhfc.Utils;
import yajhfc.shutdown.MySignalHandler;
import yajhfc.shutdown.ShutdownManager;

public class Win32ShutdownManager
extends ShutdownManager {
    protected final List<Runnable> runnables = new ArrayList<Runnable>();
    protected final Set<File> deleteOnExitFiles = new HashSet<File>();
    static Writer shutdownLog;
    static final SimpleDateFormat logFormat;

    protected static void logShutdownMsg(String string) {
        if (shutdownLog == null) {
            try {
                shutdownLog = new FileWriter(new File(Utils.getConfigDir(), "shutdown.log"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            shutdownLog.write(logFormat.format(new Date()));
            shutdownLog.write(string);
            shutdownLog.write(System.getProperty("line.separator", "\n"));
            shutdownLog.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Win32ShutdownManager() {
        MySignalHandler.install("TERM", this.runnables);
        MySignalHandler.install("INT", this.runnables);
        this.registerShutdownHook(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Set<File> set = Win32ShutdownManager.this.deleteOnExitFiles;
                synchronized (set) {
                    for (File file : Win32ShutdownManager.this.deleteOnExitFiles) {
                        file.delete();
                    }
                    Win32ShutdownManager.this.deleteOnExitFiles.clear();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDeleteOnExit(File file) {
        Set<File> set = this.deleteOnExitFiles;
        synchronized (set) {
            this.deleteOnExitFiles.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerShutdownHook(Runnable runnable) {
        runnable = new SingleInvocationRunnable(runnable);
        List<Runnable> list = this.runnables;
        synchronized (list) {
            this.runnables.add(runnable);
        }
        super.registerShutdownHook(runnable);
    }

    static {
        logFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS: ", Locale.US);
    }

    protected static class SingleInvocationRunnable
    implements Runnable {
        private final Runnable wrapped;
        private boolean started = false;

        public SingleInvocationRunnable(Runnable runnable) {
            this.wrapped = runnable;
        }

        public synchronized void run() {
            Win32ShutdownManager.logShutdownMsg(this.getClass().getName() + ".run(): wrapped=" + this.wrapped + ",started=" + this.started);
            if (this.started) {
                return;
            }
            this.started = true;
            this.wrapped.run();
            Win32ShutdownManager.logShutdownMsg(this.getClass().getName() + ".run(): wrapped=" + this.wrapped + "; DONE!");
        }
    }
}

