/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.tiff;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import yajhfc.tiff.TIFFTag;

public class TIFFReader {
    protected int numberOfPages;
    protected TIFFTag[] tags;

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public TIFFTag[] getTags() {
        return this.tags;
    }

    public void read(FileInputStream fileInputStream) throws IOException {
        this.read(fileInputStream, true);
    }

    protected boolean shouldTagBeRead(int n, int n2) {
        return true;
    }

    public TIFFTag findTag(int n) {
        return this.findTag(n, -1);
    }

    public TIFFTag findTag(int n, int n2) {
        for (TIFFTag tIFFTag : this.tags) {
            if (tIFFTag.ID != n || n2 >= 0 && tIFFTag.nIFD != n2) continue;
            return tIFFTag;
        }
        return null;
    }

    public void read(FileInputStream fileInputStream, boolean bl) throws IOException {
        ArrayList<TIFFTag> arrayList = new ArrayList<TIFFTag>();
        this.numberOfPages = 0;
        FileChannel fileChannel = fileInputStream.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        byte[] byArray = new byte[4];
        ((ByteBuffer)mappedByteBuffer).position(0);
        mappedByteBuffer.get(byArray);
        if (byArray[0] == 77 && byArray[1] == 77 && byArray[2] == 0 && byArray[3] == 42) {
            mappedByteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else if (byArray[0] == 73 && byArray[1] == 73 && byArray[2] == 42 && byArray[3] == 0) {
            mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            throw new IOException("Not a supported TIFF file");
        }
        int n = mappedByteBuffer.getInt();
        while (n > 0) {
            ((ByteBuffer)mappedByteBuffer).position(n);
            int n2 = TIFFReader.readUShort(mappedByteBuffer);
            if (bl) {
                for (int i = 0; i < n2; ++i) {
                    Object object;
                    int n3 = TIFFReader.readUShort(mappedByteBuffer);
                    if (!this.shouldTagBeRead(n3, this.numberOfPages)) {
                        ((ByteBuffer)mappedByteBuffer).position(mappedByteBuffer.position() + 10);
                        continue;
                    }
                    short s = mappedByteBuffer.getShort();
                    int n4 = mappedByteBuffer.getInt();
                    int n5 = TIFFTag.getLengthForDatatype(s) * n4;
                    int n6 = mappedByteBuffer.position();
                    if (n5 <= 0) {
                        ((ByteBuffer)mappedByteBuffer).position(n6 + 4);
                        continue;
                    }
                    if (n5 <= 4) {
                        object = this.readTagData(mappedByteBuffer, s, n4);
                    } else {
                        int n7 = mappedByteBuffer.getInt();
                        ((ByteBuffer)mappedByteBuffer).position(n7);
                        object = this.readTagData(mappedByteBuffer, s, n4);
                    }
                    ((ByteBuffer)mappedByteBuffer).position(n6 + 4);
                    arrayList.add(new TIFFTag(n3, this.numberOfPages, s, object));
                }
            } else {
                ((ByteBuffer)mappedByteBuffer).position(mappedByteBuffer.position() + n2 * 12);
            }
            n = mappedByteBuffer.getInt();
            ++this.numberOfPages;
        }
        this.tags = arrayList.toArray(new TIFFTag[arrayList.size()]);
    }

    protected Object readTagData(ByteBuffer byteBuffer, int n, int n2) throws UnsupportedEncodingException {
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = new byte[n2];
                byteBuffer.get(byArray);
                return byArray;
            }
            case 2: {
                byte[] byArray = new byte[n2 - 1];
                byteBuffer.get(byArray);
                return new String(byArray, "ISO-8859-1");
            }
            case 3: {
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = TIFFReader.readUShort(byteBuffer);
                }
                return nArray;
            }
            case 8: {
                short[] sArray = new short[n2];
                for (int i = 0; i < n2; ++i) {
                    sArray[i] = byteBuffer.getShort();
                }
                return sArray;
            }
            case 4: {
                long[] lArray = new long[n2];
                for (int i = 0; i < n2; ++i) {
                    lArray[i] = TIFFReader.readUInt(byteBuffer);
                }
                return lArray;
            }
            case 9: {
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = byteBuffer.getInt();
                }
                return nArray;
            }
            case 11: {
                float[] fArray = new float[n2];
                for (int i = 0; i < n2; ++i) {
                    fArray[i] = byteBuffer.getFloat();
                }
                return fArray;
            }
            case 12: {
                double[] dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = byteBuffer.getDouble();
                }
                return dArray;
            }
            case 5: {
                long[] lArray = new long[n2 * 2];
                for (int i = 0; i < n2 * 2; ++i) {
                    lArray[i] = TIFFReader.readUInt(byteBuffer);
                }
                return lArray;
            }
            case 10: {
                int[] nArray = new int[n2 * 2];
                for (int i = 0; i < n2 * 2; ++i) {
                    nArray[i] = byteBuffer.getInt();
                }
                return nArray;
            }
        }
        return null;
    }

    private static long readUInt(ByteBuffer byteBuffer) {
        return (long)byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    private static int readUShort(ByteBuffer byteBuffer) {
        return byteBuffer.getShort() & 0xFFFF;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Usage: TIFFReader file1 ...");
        }
        TIFFReader tIFFReader = new TIFFReader();
        for (String string : stringArray) {
            System.out.println("Reading " + string + "...");
            FileInputStream fileInputStream = new FileInputStream(string);
            tIFFReader.read(fileInputStream, true);
            fileInputStream.close();
            System.out.println("Number of pages: " + tIFFReader.numberOfPages);
            System.out.println("Tags:");
            for (TIFFTag tIFFTag : tIFFReader.tags) {
                System.out.println(tIFFTag);
            }
            System.out.println("Resolution X: " + tIFFReader.findTag(282).doubleValue());
            System.out.println("-----------------------------");
            System.out.println();
        }
    }
}

