/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.tray;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Timer;
import yajhfc.MainWin;
import yajhfc.Utils;
import yajhfc.model.RecvFormat;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.table.ReadStateFaxListTableModel;
import yajhfc.model.table.UnreadItemEvent;
import yajhfc.model.table.UnreadItemListener;
import yajhfc.server.Server;
import yajhfc.server.ServerManager;
import yajhfc.tray.ITrayIcon;
import yajhfc.tray.TrayFactory;
import yajhfc.tray.TrayManager;
import yajhfc.util.ExcDialogAbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YajHFCTrayIcon
implements UnreadItemListener<RecvFormat>,
WindowListener {
    private static final int BLINK_INTERVAL = 500;
    private static final long MINIMIZE_THRESHOLD = 2000L;
    ITrayIcon trayIcon = null;
    MainWin mainw;
    ShowAction showAction;
    boolean connected = false;
    boolean minimizeToTray = false;
    ReadStateFaxListTableModel<RecvFormat> recvModel;
    Image faxIcon;
    Image emptyImage;
    Timer blinkTimer;
    long blinkStartTime = -1L;
    long lastShowTime = -1L;

    public YajHFCTrayIcon(MainWin mainWin, ReadStateFaxListTableModel<RecvFormat> readStateFaxListTableModel, Action ... actionArray) {
        this.mainw = mainWin;
        this.recvModel = readStateFaxListTableModel;
        try {
            if (TrayFactory.trayIsAvailable()) {
                this.showAction = new ShowAction();
                PopupMenu popupMenu = new PopupMenu();
                popupMenu.add(this.createMenuItemForAction(this.showAction));
                popupMenu.addSeparator();
                for (Action action : actionArray) {
                    if (action == null) {
                        popupMenu.addSeparator();
                        continue;
                    }
                    popupMenu.add(this.createMenuItemForAction(action));
                }
                TrayManager trayManager = TrayFactory.getTrayManager();
                if (trayManager == null) {
                    Logger.getLogger(YajHFCTrayIcon.class.getName()).log(Level.WARNING, "Could not get a tray manager!");
                    this.trayIcon = null;
                    return;
                }
                Dimension dimension = trayManager.getTrayIconSize();
                this.faxIcon = Toolkit.getDefaultToolkit().getImage(YajHFCTrayIcon.class.getResource("/yajhfc/logo-large.png")).getScaledInstance(dimension.width, dimension.height, 4);
                this.emptyImage = new BufferedImage(dimension.width, dimension.height, 3);
                this.trayIcon = trayManager.installTrayIcon(this.faxIcon, "YajHFC", popupMenu, this.showAction);
                this.trayIcon.addMouseListener(this.showAction);
                readStateFaxListTableModel.addUnreadItemListener(this);
                mainWin.addWindowListener(this);
                this.updateTooltip();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(YajHFCTrayIcon.class.getName()).log(Level.SEVERE, "Error creating tray icon:", exception);
            this.trayIcon = null;
        }
    }

    public boolean isValid() {
        return this.trayIcon != null;
    }

    private MenuItem createMenuItemForAction(Action action) {
        MenuItem menuItem = new MenuItem((String)action.getValue("Name"));
        menuItem.setEnabled(action.isEnabled());
        menuItem.addActionListener(action);
        action.addPropertyChangeListener(new MenuItemActionPropChangeListener(action, menuItem));
        return menuItem;
    }

    public void setConnectedState(boolean bl) {
        this.connected = bl;
        this.updateTooltip();
    }

    @Override
    public void newItemsAvailable(UnreadItemEvent<RecvFormat> unreadItemEvent) {
        if (this.trayIcon != null && !unreadItemEvent.isOldDataNull()) {
            if (Utils.getFaxOptions().newFaxTrayNotification) {
                StringBuffer stringBuffer = new StringBuffer();
                new MessageFormat(Utils._("{0} fax(es) received ({1} unread fax(es)):")).format(new Object[]{unreadItemEvent.getItems().size(), this.recvModel.getNumberOfUnreadFaxes()}, stringBuffer, (FieldPosition)null);
                int n = this.recvModel.getColumns().getCompleteView().indexOf(RecvFormat.s);
                if (n >= 0) {
                    for (FaxJob<RecvFormat> faxJob : unreadItemEvent.getItems()) {
                        stringBuffer.append('\n');
                        stringBuffer.append(faxJob.getData(n));
                    }
                }
                this.trayIcon.displayMessage(Utils._("New fax received"), stringBuffer.toString(), 1);
            }
            this.updateTooltip();
            if ((Utils.getFaxOptions().newFaxAction & 0x10) != 0) {
                this.startBlinking();
            }
        }
    }

    private void updateTooltip() {
        if (this.trayIcon != null) {
            String string;
            int n = this.recvModel.getNumberOfUnreadFaxes();
            if (this.connected) {
                StringBuffer stringBuffer = new StringBuffer();
                Server server = ServerManager.getDefault().getCurrent();
                if (server != null) {
                    String string2 = server.isConnected() ? server.getOptions().user : server.getClientManager().getUser();
                    stringBuffer.append(string2).append('@').append(server.getOptions().host);
                } else {
                    stringBuffer.append("<no server>");
                }
                stringBuffer.append(" - ");
                new MessageFormat(Utils._("{0} unread fax(es)")).format(new Object[]{n}, stringBuffer, (FieldPosition)null);
                string = stringBuffer.toString();
            } else {
                string = Utils._("Disconnected");
            }
            this.trayIcon.setToolTip(string);
        }
    }

    private void startBlinking() {
        if (this.trayIcon != null) {
            if (this.blinkTimer == null) {
                this.blinkTimer = new Timer(500, new ActionListener(){
                    private boolean blinkState = false;

                    public void actionPerformed(ActionEvent actionEvent) {
                        YajHFCTrayIcon.this.trayIcon.setImage(this.blinkState ? YajHFCTrayIcon.this.faxIcon : YajHFCTrayIcon.this.emptyImage);
                        this.blinkState = !this.blinkState;
                    }
                });
                this.blinkTimer.start();
            }
            this.blinkStartTime = System.currentTimeMillis();
        }
    }

    private void stopBlinking() {
        if (this.trayIcon != null && this.blinkTimer != null && this.blinkStartTime > 0L && System.currentTimeMillis() - this.blinkStartTime > 500L) {
            this.blinkTimer.stop();
            this.blinkTimer = null;
            this.trayIcon.setImage(this.faxIcon);
            this.blinkStartTime = -1L;
        }
    }

    public void setMinimizeToTray(boolean bl) {
        this.minimizeToTray = bl;
    }

    public boolean isMinimizeToTray() {
        return this.minimizeToTray;
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        if (System.currentTimeMillis() < this.lastShowTime + 2000L) {
            return;
        }
        if (this.minimizeToTray && this.trayIcon != null) {
            this.mainw.setVisible(false);
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.dispose();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        this.stopBlinking();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.stopBlinking();
    }

    @Override
    public void readStateChanged() {
        this.updateTooltip();
    }

    public void dispose() {
        if (this.trayIcon != null) {
            TrayFactory.getTrayManager().removeTrayIcon(this.trayIcon);
            this.trayIcon = null;
            this.mainw.removeWindowListener(this);
            this.recvModel.removeUnreadItemListener(this);
        }
    }

    private static class MenuItemActionPropChangeListener
    implements PropertyChangeListener {
        private final Action action;
        private final WeakReference<MenuItem> itemRef;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MenuItem menuItem = (MenuItem)this.itemRef.get();
            if (menuItem == null) {
                this.action.removePropertyChangeListener(this);
            } else {
                String string = propertyChangeEvent.getPropertyName();
                if ("Name".equals(string)) {
                    menuItem.setLabel((String)this.action.getValue("Name"));
                } else if ("enabled".equals(string)) {
                    menuItem.setEnabled(this.action.isEnabled());
                }
            }
        }

        public MenuItemActionPropChangeListener(Action action, MenuItem menuItem) {
            this.action = action;
            this.itemRef = new WeakReference<MenuItem>(menuItem);
        }
    }

    final class ShowAction
    extends ExcDialogAbstractAction
    implements MouseListener {
        public ShowAction() {
            this.putValue("Name", Utils._("Restore"));
        }

        protected void actualActionPerformed(ActionEvent actionEvent) {
            if (System.currentTimeMillis() < YajHFCTrayIcon.this.lastShowTime + 100L) {
                return;
            }
            YajHFCTrayIcon.this.lastShowTime = System.currentTimeMillis();
            YajHFCTrayIcon.this.mainw.bringToFront();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                this.actionPerformed(null);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

