/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.ui.swing;

import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import yajhfc.Utils;
import yajhfc.ui.YajOptionPane;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.PasswordDialog;
import yajhfc.util.ProgressWorker;

public class SwingYajOptionPane
extends YajOptionPane {
    static final Logger log = Logger.getLogger(SwingYajOptionPane.class.getName());
    protected final Window parent;

    public SwingYajOptionPane(Window window) {
        this.parent = window;
    }

    public void showExceptionDialog(String string, String string2, Exception exception) {
        ExceptionDialog.showExceptionDialog((Component)this.parent, string, string2, exception);
    }

    public void showExceptionDialog(String string, Exception exception) {
        ExceptionDialog.showExceptionDialog(this.parent, string, exception);
    }

    public void showExceptionDialog(String string, String string2, Exception exception, int n) {
        ExceptionDialog.showExceptionDialog(this.parent, string, string2, exception, n);
    }

    public void showExceptionDialog(String string, Exception exception, int n) {
        ExceptionDialog.showExceptionDialog((Component)this.parent, string, exception, n);
    }

    public String[] showPasswordDialog(String string, String string2, String string3, boolean bl) {
        return PasswordDialog.showPasswordDialog(this.parent, string, string2, string3, bl);
    }

    public String[] showPasswordDialog(String string, String string2, String string3, boolean bl, boolean bl2) {
        return PasswordDialog.showPasswordDialog(this.parent, string, string2, string3, bl, bl2);
    }

    public void showMessageDialog(final String string, final String string2, final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(this.parent, string, string2, n);
        } else {
            try {
                if (Utils.debugMode) {
                    log.info("showMessageDialog: msg=\"" + string + "\", title = \"" + string2 + "\", msgType=" + n);
                }
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(SwingYajOptionPane.this.parent, string, string2, n);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public int showConfirmDialog(String string, String string2, int n, int n2) {
        if (SwingUtilities.isEventDispatchThread()) {
            return JOptionPane.showConfirmDialog(this.parent, string, string2, n, n2);
        }
        ConfirmDlgDisplayer confirmDlgDisplayer = new ConfirmDlgDisplayer(this.parent, string, string2, n, n2);
        try {
            SwingUtilities.invokeAndWait(confirmDlgDisplayer);
            return confirmDlgDisplayer.returnValue;
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
        catch (InvocationTargetException invocationTargetException) {
            return -1;
        }
    }

    public Window getParent() {
        return this.parent;
    }

    public void invokeLater(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public ProgressWorker.ProgressUI createDefaultProgressMonitor(String string, String string2, int n, int n2) {
        return new MyProgressMonitor(this.parent, string, string2, n, n2);
    }

    private static class ConfirmDlgDisplayer
    implements Runnable {
        private Component parent;
        private String msg;
        private String title;
        private int msgType;
        private int optionType = Integer.MIN_VALUE;
        public int returnValue = 0;

        public void run() {
            this.returnValue = JOptionPane.showConfirmDialog(this.parent, this.msg, this.title, this.optionType, this.msgType);
            if (Utils.debugMode) {
                log.info("showConfirmDialog: returnValue=" + this.returnValue + " (for msg=\"" + this.msg + "\", title = \"" + this.title + "\", msgType=" + this.msgType + ", optionType=" + this.optionType + ")");
            }
        }

        public ConfirmDlgDisplayer(Component component, String string, String string2, int n, int n2) {
            this.parent = component;
            this.msg = string;
            this.title = string2;
            this.msgType = n2;
            this.optionType = n;
            if (Utils.debugMode) {
                log.info("showConfirmDialog: msg=\"" + string + "\", title = \"" + string2 + "\", msgType=" + n2 + ", optionType=" + n);
            }
        }
    }

    protected static class MyProgressMonitor
    extends ProgressMonitor
    implements ProgressWorker.ProgressUI {
        public MyProgressMonitor(Component component, Object object, String string, int n, int n2) {
            super(component, object, string, n, n2);
        }

        public void showDeterminateProgress(String string, String string2, int n, int n2) {
            throw new IllegalStateException("Can not reinitialize a progress monitor.");
        }

        public void showIndeterminateProgress(String string, String string2) {
            throw new UnsupportedOperationException("Indeterminate progress not supported.");
        }

        public boolean supportsIndeterminateProgress() {
            return false;
        }

        public boolean isShowingIndeterminate() {
            return false;
        }
    }
}

