/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class AWTExceptionLogger
implements Thread.UncaughtExceptionHandler {
    private static final Logger log = Logger.getLogger(AWTExceptionLogger.class.getName());

    public void handle(Throwable throwable) {
        log.log(Level.SEVERE, "An uncaught exception occurred during event dispatching:", throwable);
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        log.log(Level.SEVERE, "An uncaught exception occurred during event dispatching (Thread: " + thread + "):", throwable);
    }

    public static void register() {
        System.setProperty("sun.awt.exception.handler", AWTExceptionLogger.class.getName());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Thread.currentThread().setUncaughtExceptionHandler(new AWTExceptionLogger());
            }
        });
    }
}

