/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import yajhfc.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncComboBoxOrListModel<T>
extends AbstractListModel
implements ListModel,
ComboBoxModel {
    private Object selectedItem;
    protected final List<T> elements;
    protected Future<List<T>> future;
    protected boolean finished = false;
    private Callable<List<T>> listCallable;

    public AsyncComboBoxOrListModel(List<T> list, final Callable<List<T>> callable, final boolean bl, final Runnable runnable) {
        this.elements = new ArrayList<T>(list);
        this.listCallable = new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                List list = (List)callable.call();
                final int n = AsyncComboBoxOrListModel.this.elements.size();
                if (bl) {
                    AsyncComboBoxOrListModel.this.elements.clear();
                }
                AsyncComboBoxOrListModel.this.elements.addAll(list);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (bl) {
                            AsyncComboBoxOrListModel.this.fireIntervalRemoved(AsyncComboBoxOrListModel.this, 0, n - 1);
                            AsyncComboBoxOrListModel.this.fireIntervalAdded(AsyncComboBoxOrListModel.this, 0, AsyncComboBoxOrListModel.this.elements.size() - 1);
                        } else {
                            AsyncComboBoxOrListModel.this.fireIntervalAdded(AsyncComboBoxOrListModel.this, n, AsyncComboBoxOrListModel.this.elements.size() - 1);
                        }
                        if (runnable != null) {
                            runnable.run();
                        }
                        AsyncComboBoxOrListModel.this.finished = true;
                    }
                });
                return list;
            }
        };
        this.refreshListAsync();
    }

    public void refreshListAsync() {
        this.future = Utils.executorService.submit(this.listCallable);
    }

    @Override
    public Object getElementAt(int n) {
        return this.elements.get(n);
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    @Override
    public void setSelectedItem(Object object) {
        if (this.selectedItem != object) {
            this.selectedItem = object;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Future<List<T>> getFuture() {
        return this.future;
    }
}

