/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import yajhfc.PlatformInfo;
import yajhfc.Utils;
import yajhfc.launch.Launcher2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalProcessExecutor
extends Thread {
    private static final Logger log = Logger.getLogger(ExternalProcessExecutor.class.getName());
    private Process process;
    private String commandName;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_DQUOTE = 1;
    private static final int STATE_SQUOTE = 2;
    private static final int STATE_WHITESPACE = 3;

    public ExternalProcessExecutor(List<String> list) throws IOException {
        ExternalProcessExecutor.quoteCommandLine(list);
        this.commandName = list.get(0);
        this.setDaemon(true);
        this.setName(this.commandName + " executor");
        this.setPriority(1);
        this.process = new ProcessBuilder(list).redirectErrorStream(true).start();
        this.start();
    }

    @Override
    public void run() {
        try {
            String string;
            this.process.getOutputStream().close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                log.info(this.commandName + " output: " + string);
            }
            bufferedReader.close();
            int n = this.process.waitFor();
            if (n != 0) {
                log.warning(this.commandName + " did not execute successfully (exitCode=" + n + ").");
            } else if (Utils.debugMode) {
                log.info(this.commandName + " executed successfully.");
            }
        }
        catch (Exception exception) {
            Launcher2.application.getDialogUI().showExceptionDialog(MessageFormat.format(Utils._("Error executing {0}:"), this.commandName), exception);
        }
    }

    public static void executeProcess(String string) throws IOException {
        ExternalProcessExecutor.executeProcess(ExternalProcessExecutor.splitCommandLine(string));
    }

    public static void executeProcess(String ... stringArray) throws IOException {
        ExternalProcessExecutor.executeProcess(Arrays.asList(stringArray));
    }

    public static void executeProcess(List<String> list) throws IOException {
        new ExternalProcessExecutor(list);
    }

    public static List<String> splitCommandLine(String string) {
        return ExternalProcessExecutor.splitCommandLine(string, !PlatformInfo.IS_WINDOWS);
    }

    public static List<String> splitCommandLine(String string, boolean bl) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        string = string.trim();
        block16: for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            switch (n2) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            n2 = 2;
                            continue block16;
                        }
                        case '\"': {
                            n2 = 1;
                            continue block16;
                        }
                        case ' ': {
                            String string2 = string.substring(n3, n);
                            if (bl) {
                                string2 = Utils.stripQuotes(string2);
                            }
                            arrayList.add(string2);
                            n2 = 3;
                            continue block16;
                        }
                    }
                    continue block16;
                }
                case 1: {
                    if (c != '\"') continue block16;
                    n2 = 0;
                    continue block16;
                }
                case 2: {
                    if (c != '\'') continue block16;
                    n2 = 0;
                    continue block16;
                }
                case 3: {
                    switch (c) {
                        case ' ': {
                            continue block16;
                        }
                        case '\'': {
                            n3 = n;
                            n2 = 2;
                            continue block16;
                        }
                        case '\"': {
                            n3 = n;
                            n2 = 1;
                            continue block16;
                        }
                    }
                    n3 = n;
                    n2 = 0;
                }
            }
        }
        if (n3 < string.length() - 1) {
            String string3 = string.substring(n3);
            if (bl) {
                string3 = Utils.stripQuotes(string3);
            }
            arrayList.add(string3);
        }
        if (Utils.debugMode) {
            log.fine("Result from parsing command line \u00ab" + string + "\u00bb:");
            for (n = 0; n < arrayList.size(); ++n) {
                log.fine("" + n + ": \u00ab" + (String)arrayList.get(n) + '\u00bb');
            }
        }
        return arrayList;
    }

    public static void quoteCommandLine(List<String> list) {
        if (PlatformInfo.IS_WINDOWS) {
            ListIterator<String> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                char c;
                char c2;
                String string = listIterator.next();
                if (string.indexOf(32) < 0 || (c2 = string.charAt(0)) == (c = string.charAt(string.length() - 1)) && (c2 == '\"' || c2 == '\'')) continue;
                listIterator.set("\"" + string + "\"");
            }
        }
    }
}

