/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import yajhfc.Utils;
import yajhfc.util.CancelAction;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.JTableTABAction;
import yajhfc.util.MapTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapEditorDialog
extends JDialog {
    protected Map<String, String> mapToEdit;
    protected MapTableModel model;
    protected JTable mapTable;
    protected Action okAction;
    protected Action deleteAction;

    public MapEditorDialog(Frame frame, String string, Map<String, String> map) throws HeadlessException {
        super(frame, string, true);
        this.mapToEdit = map;
        this.initialize();
    }

    public MapEditorDialog(Dialog dialog, String string, Map<String, String> map) throws HeadlessException {
        super(dialog, string, true);
        this.mapToEdit = map;
        this.initialize();
    }

    protected void initialize() {
        this.deleteAction = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                int n = MapEditorDialog.this.mapTable.getSelectedRow();
                if (n >= 0 && MapEditorDialog.this.model.rowIsDeletable(n)) {
                    MapEditorDialog.this.model.deleteRow(n);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        };
        this.deleteAction.putValue("Name", Utils._("Remove row"));
        this.okAction = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                if (MapEditorDialog.this.mapTable.isEditing()) {
                    MapEditorDialog.this.mapTable.getCellEditor().stopCellEditing();
                }
                MapEditorDialog.this.mapToEdit.clear();
                MapEditorDialog.this.mapToEdit.putAll(MapEditorDialog.this.model.getMapToEdit());
                MapEditorDialog.this.dispose();
            }
        };
        this.okAction.putValue("Name", Utils._("OK"));
        CancelAction cancelAction = new CancelAction(this);
        this.model = new MapTableModel(new TreeMap<String, String>(this.mapToEdit));
        this.mapTable = new JTable(this.model);
        this.mapTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MapEditorDialog.this.deleteAction.setEnabled(listSelectionEvent.getFirstIndex() >= 0 && MapEditorDialog.this.model.rowIsDeletable(listSelectionEvent.getFirstIndex()));
            }
        });
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.deleteAction);
        this.mapTable.setComponentPopupMenu(jPopupMenu);
        JComboBox<String> jComboBox = new JComboBox<String>(this.getAvailableProperties());
        jComboBox.setEditable(true);
        this.mapTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(jComboBox));
        this.mapTable.getActionMap().put(this.deleteAction.getClass().getName(), this.deleteAction);
        this.mapTable.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.deleteAction.getClass().getName());
        JTableTABAction.wrapDefTabAction(this.mapTable);
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        Box box = Box.createHorizontalBox();
        Dimension dimension = new Dimension(6, 6);
        box.add(Box.createHorizontalGlue());
        box.add(new JButton(this.okAction));
        box.add(Box.createRigidArea(dimension));
        box.add(cancelAction.createCancelButton());
        box.add(Box.createHorizontalGlue());
        jPanel.add((Component)new JLabel("<html>" + this.getCaption() + "</html>"), "North");
        jPanel.add((Component)new JScrollPane(this.mapTable), "Center");
        jPanel.add((Component)box, "South");
        this.setContentPane(jPanel);
        this.pack();
        if (this.getWidth() > 640) {
            this.setSize(640, this.getHeight());
        }
        Utils.setDefWinPos(this);
    }

    protected abstract String getCaption();

    protected abstract String[] getAvailableProperties();
}

