/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import yajhfc.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapTableModel
extends AbstractTableModel {
    protected final List<Row> rows = new ArrayList<Row>();
    protected Map<String, String> mapToEdit;
    public String keyColumnName = Utils._("Key");
    public String valueColumnName = Utils._("Value");

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return this.keyColumnName;
            }
            case 1: {
                return this.valueColumnName;
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Row row = this.rows.get(n);
        switch (n2) {
            case 0: {
                return row.getKey();
            }
            case 1: {
                return row.getValue();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Row row = this.rows.get(n);
        switch (n2) {
            case 0: {
                if ("".equals(object)) {
                    return;
                }
                row.setKey(object.toString());
                break;
            }
            case 1: {
                row.setValue(object.toString());
                break;
            }
            default: {
                return;
            }
        }
        this.fireTableCellUpdated(n, n2);
        if (row.isNewRow) {
            row.isNewRow = false;
            this.rows.add(new Row(true));
            this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
        }
    }

    public boolean rowIsDeletable(int n) {
        return !this.rows.get((int)n).isNewRow;
    }

    public void deleteRow(int n) {
        Row row = this.rows.get(n);
        if (row.isNewRow) {
            throw new IllegalArgumentException("Cannot delete the new row!");
        }
        this.rows.remove(n);
        this.mapToEdit.remove(row.getKey());
        this.fireTableRowsDeleted(n, n);
    }

    protected void loadFromMap() {
        this.rows.clear();
        for (Map.Entry<String, String> entry : this.mapToEdit.entrySet()) {
            this.rows.add(new Row(entry));
        }
        this.rows.add(new Row(true));
        this.fireTableDataChanged();
    }

    public Map<String, String> getMapToEdit() {
        return this.mapToEdit;
    }

    public MapTableModel(Map<String, String> map) {
        this.mapToEdit = map;
        this.loadFromMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Row
    implements Map.Entry<String, String> {
        private String key;
        private String value;
        public boolean isNewRow = false;

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String string) {
            String string2 = this.value;
            this.value = string;
            MapTableModel.this.mapToEdit.put(this.key, string);
            return string2;
        }

        public void setKey(String string) {
            if (string != null && !string.equals(this.key)) {
                if (this.key != null) {
                    MapTableModel.this.mapToEdit.remove(this.key);
                }
                MapTableModel.this.mapToEdit.put(string, this.value);
                this.key = string;
            }
        }

        public Row(boolean bl) {
            this.isNewRow = bl;
        }

        public Row(Map.Entry<String, String> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }
    }
}

